/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.SelectNewsgroupDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionEditPanel
extends ItemEditPanel {
    private static Logger logger = Logger.getLogger(DiscussionEditPanel.class);
    protected OrientableButton btnNewsgroups;
    protected OrientableButton btnFollow;
    protected ContactSearchComboField etcNewsgroups;
    protected ContactSearchComboField etcFollow;
    private NntpAccount nntpAccount;

    public DiscussionEditPanel(MVCController theParentController, ComposeMode composeMode) {
        super(theParentController, "ATTACHLIST_SPLITPOS_DISCUSSIION", composeMode, false);
        this.focusTraversalPolicy = new DiscussionFocusPolicy();
    }

    private List<IRecipient> convertFoldersToRecipients(List<String> foldersNames, RecipientCopyType recipientCopyType) {
        LinkedList<IRecipient> recipients = new LinkedList<IRecipient>();
        for (String folderName : foldersNames) {
            IAddress address = APIAbWrapperManager.createAddress(folderName, folderName);
            recipients.add(APIAbWrapperManager.createRecipient(address, recipientCopyType));
        }
        return recipients;
    }

    @Override
    protected ItemEditPanelController createController(MVCController parentController) {
        return new ItemEditPanelController<DiscussionEditPanel>(this, parentController);
    }

    @Override
    public void setRecipients(AbstractItem newItem) {
        this.etcNewsgroups.setRecipients(newItem.getToRecipients());
        this.etcFollow.setRecipients(newItem.getCcRecipients());
    }

    @Override
    public List<IRecipient> getRecipientsList() {
        LinkedList<IRecipient> result = new LinkedList<IRecipient>();
        result.addAll(this.etcNewsgroups.getRecipients());
        result.addAll(this.etcFollow.getRecipients());
        return result;
    }

    @Override
    public AbstractItem getGWItemComposition() {
        AbstractItem item = super.getGWItemComposition();
        item.setSubject(this.tfSubject.getText());
        return item;
    }

    @Override
    public void setGWItemComposition(AbstractItem newItem) {
        assert (newItem.getNativeItem().getSendingAccount() != null);
        super.setGWItemComposition(newItem);
        if (newItem.getNativeItem().getSendingAccount() instanceof NntpAccount) {
            this.nntpAccount = (NntpAccount)newItem.getNativeItem().getSendingAccount();
        }
        this.setRecipients(this.newItem);
        this.tfSubject.setText(this.newItem.getSubject());
    }

    @Override
    protected void build() {
        super.build();
        this.initComponents();
        this.contentPanel.setLayout(new BorderLayout());
        this.compFrom = new FromComponent(this);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.tfTo);
        this.lbCC = new JMnemonicLabel(StringResources.CC_C, this.tfCC);
        this.lbBC = new JMnemonicLabel(StringResources.BC_C, this.tfBC);
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        OrientablePanel messagePanel = new OrientablePanel(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        messagePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel attachmentsPanel = new OrientablePanel(new BorderLayout());
        attachmentsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        attachmentsPanel.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(attachmentsPanel);
        this.messageSplit.setTopComponent(messagePanel);
        this.buildAddressPane();
        this.contentPanel.add((Component)this.messageSplit, "Center");
        this.contentPanel.add((Component)this.addressPane, "North");
    }

    private void initComponents() {
        this.btnNewsgroups = new OrientableButton(new NewsgroupAction());
        this.btnFollow = new OrientableButton(new FollowAction());
        this.etcNewsgroups = new ContactSearchComboField(this.getController(), RecipientCopyType.getTo());
        this.etcNewsgroups.setEditable(false);
        this.etcFollow = new ContactSearchComboField(this.getController(), RecipientCopyType.getCc());
        this.etcFollow.setEditable(false);
    }

    private void buildAddressPane() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.addressPane.setComponentOrientation(UIUtils.getComponentOrientation());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.compFrom, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, c);
        c.anchor = 21;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.btnNewsgroups, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcNewsgroups, c);
        c.anchor = 21;
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 10, 8, 10);
        this.addressPane.add((Component)this.btnFollow, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcFollow, c);
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(0, 0, 0, 10);
        c.ipadx = 0;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbSubject, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 3.5;
        this.addressPane.add((Component)this.createEditableTextComponent(this.tfSubject), c);
    }

    private void showFolderSelectDialog(boolean isNewsgroupFolder) {
        if (this.nntpAccount != null) {
            LinkedList<String> newsgroupFolders = new LinkedList<String>();
            for (IRecipient recipient : this.etcNewsgroups.getRecipients()) {
                newsgroupFolders.add(recipient.getAddressable().getEmailAddress());
            }
            LinkedList<String> followFolders = new LinkedList<String>();
            for (IRecipient recipient : this.etcFollow.getRecipients()) {
                followFolders.add(recipient.getAddressable().getEmailAddress());
            }
            SelectNewsgroupDialog dialog = new SelectNewsgroupDialog(ControlsUtils.getFrameForController(this.getController()), this.nntpAccount, newsgroupFolders, followFolders, isNewsgroupFolder);
            dialog.showMe();
            if (dialog.isActionCompleteSuccessfully()) {
                List<IRecipient> recipients = this.convertFoldersToRecipients(dialog.getFollowupFolders(), RecipientCopyType.getCc());
                this.etcFollow.setRecipients(recipients);
                recipients = this.convertFoldersToRecipients(dialog.getNewsgroupFolders(), RecipientCopyType.getTo());
                this.etcNewsgroups.setRecipients(recipients);
            }
        }
    }

    private class FollowAction
    extends AbstractAction {
        public FollowAction() {
            super(StringResources.FOLLOWUP_TO_C);
        }

        public void actionPerformed(ActionEvent e) {
            DiscussionEditPanel.this.showFolderSelectDialog(false);
        }
    }

    private class NewsgroupAction
    extends AbstractAction {
        public NewsgroupAction() {
            super(StringResources.NEWSGROUPS_C);
        }

        public void actionPerformed(ActionEvent e) {
            DiscussionEditPanel.this.showFolderSelectDialog(true);
        }
    }

    private class DiscussionFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private DiscussionFocusPolicy() {
        }
    }
}

