/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level02;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.DnDUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTable;
import com.novell.gw.jclient.application.controls.itemlisttable.level02.ItemListTable_Level02;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCallBackListener;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import org.apache.log4j.Logger;

class ItemListTableDropTargetListener
extends DropTargetAdapter {
    private static Logger logger = Logger.getLogger(ItemListTableDropTargetListener.class);
    private Point dragLocation;
    private ItemListTable_Level02 table;
    private boolean transferFromDifferentFolder = true;
    private boolean transferFromDifferentView = false;
    private int targetViewMode;
    private DropTargetItemListListener itemListlistener = new DropTargetItemListListener();

    public ItemListTableDropTargetListener(ItemListTable_Level02 table) {
        if (table == null) {
            throw new IllegalArgumentException("itemListtable is null");
        }
        this.table = table;
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.dragLocation = dtde.getLocation();
        this.table.setPaintArrow(false);
        this.table.setPaintDropTargetCell(false);
        Transferable transferable = dtde.getTransferable();
        this.transferFromDifferentFolder = DnDUtils.isTransferFromDifferentFolder(this.getParentFolder(), transferable);
        if (!this.transferFromDifferentFolder && dtde.getTransferable().isDataFlavorSupported(GWFlavors.viewModeFlavor)) {
            try {
                int viewMode = (Integer)dtde.getTransferable().getTransferData(GWFlavors.viewModeFlavor);
                this.targetViewMode = this.table.getViewDisplaySettings().getViewMode();
                this.transferFromDifferentView = viewMode != this.targetViewMode;
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        boolean acceptDrag = false;
        if (!(this.table instanceof ItemListTable)) {
            return;
        }
        ItemListTable table = (ItemListTable)this.table;
        if (DnDUtils.isSameUserGuid(transferable, ControlsUtils.getUserGuid(table.getController()))) {
            Point location = dtde.getLocation();
            if (UIUtils.getComponentOrientation().isLeftToRight() && location.x < 2 || !UIUtils.getComponentOrientation().isLeftToRight() && location.x > this.table.getWidth() - 2) {
                table.getController().processCommand(new GlobalCommand(1752));
            }
            if (this.table.isOverFolder(this.dragLocation)) {
                acceptDrag = this.verifyDragOverFolderItem(dtde);
            } else if (this.isMultipleItemTransfer(dtde.getTransferable())) {
                if (this.transferFromDifferentFolder) {
                    acceptDrag = true;
                }
            } else if (this.transferFromDifferentFolder && this.isSingleFolderTransfer(dtde.getTransferable())) {
                acceptDrag = true;
            } else if (this.table.isOverChecklistItem(this.dragLocation)) {
                acceptDrag = this.verifyDragOverCheckListItem(dtde);
            } else if (this.table.isOverMessage(this.dragLocation)) {
                acceptDrag = this.verifyDragOverMessageItem(dtde);
            } else {
                int index = this.table.rowAtPoint(this.dragLocation);
                if (index != -1) {
                    IItem unexpectedItem = this.table.getItemList().getItemAt(index);
                    logger.warn((Object)("dragging over unexpected item of following class: " + unexpectedItem.getClass().getName()));
                }
            }
        }
        this.table.repaintArrow(this.dragLocation);
        this.table.repaintDragFolder(this.dragLocation);
        if (acceptDrag) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        this.dragLocation = dtde.getLocation();
        this.table.setPaintArrow(false);
        this.table.setPaintDropTargetCell(false);
        this.table.repaint();
        if (this.table.isOverFolder(this.dragLocation)) {
            logger.debug((Object)"target: folder item");
            this.processDropOnFolder(dtde);
        } else if (this.isMultipleItemTransfer(dtde.getTransferable())) {
            logger.debug((Object)"multiple item transfer");
            if (this.transferFromDifferentFolder) {
                logger.debug((Object)"transfer from different folder");
                this.processSimpleDrop(dtde);
            }
        } else if (this.transferFromDifferentFolder && this.isSingleFolderTransfer(dtde.getTransferable())) {
            logger.debug((Object)"single folder transfer");
            this.processSimpleDrop(dtde);
        } else if (this.table.isOverChecklistItem(this.dragLocation)) {
            logger.debug((Object)"target: check list item");
            this.processDropOnCheckList(dtde);
        } else if (this.table.isOverMessage(this.dragLocation)) {
            logger.debug((Object)"target: message item");
            this.processDropOnMessages(dtde);
        } else {
            IItem unexpectedItem = this.table.getItemList().getItemAt(this.table.rowAtPoint(this.dragLocation));
            logger.warn((Object)("drop on unexpected item of following class: " + unexpectedItem.getClass().getName()));
            dtde.dropComplete(false);
        }
    }

    public void dragExit(DropTargetEvent dte) {
        this.table.setPaintArrow(false);
        this.table.setPaintDropTargetCell(false);
        this.table.repaint();
    }

    private boolean verifyDragOverCheckListItem(DropTargetDragEvent dtde) {
        if (this.transferFromDifferentFolder) {
            this.table.setPaintArrow(true);
            return true;
        }
        if (this.table.getViewDisplaySettings().getViewMode() != 7) {
            logger.debug((Object)"wrong model");
            return false;
        }
        try {
            int[] indices = (int[])dtde.getTransferable().getTransferData(GWFlavors.indicesFlavor);
            IItem item = this.table.getItemList().getItemAt(indices[0]);
            if (item instanceof IMessage && !((IMessage)item).isCompleted()) {
                this.table.setPaintArrow(true);
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return false;
    }

    private boolean verifyDragOverFolderItem(DropTargetDragEvent dtde) {
        Point location = dtde.getLocation();
        int targetIndex = this.table.rowAtPoint(location);
        IItem folder = this.table.getItemList().getItemAt(targetIndex);
        AbstractFolder abstractFolder = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.table)).getGWFolder((IFolder)folder);
        if (!(this.table instanceof ItemListTable) || !DnDUtils.isDropOnFolderAllowed(abstractFolder, dtde.getTransferable(), ((ItemListTable)this.table).getController())) {
            return false;
        }
        if (this.transferFromDifferentFolder) {
            this.table.setPaintDropTargetCell(true);
            return true;
        }
        try {
            int[] indices;
            for (int index : indices = (int[])dtde.getTransferable().getTransferData(GWFlavors.indicesFlavor)) {
                IItem item = this.table.getItemList().getItemAt(index);
                if (item instanceof IMessage || item instanceof IFolder) continue;
                return false;
            }
            this.table.setPaintDropTargetCell(true);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return false;
    }

    private boolean verifyDragOverMessageItem(DropTargetDragEvent dtde) {
        if (this.transferFromDifferentFolder || this.transferFromDifferentView) {
            return true;
        }
        if (this.table.getViewDisplaySettings().getViewMode() != 7) {
            logger.debug((Object)"local transfer && wrong model");
            return false;
        }
        try {
            int[] indices = (int[])dtde.getTransferable().getTransferData(GWFlavors.indicesFlavor);
            IItem item = this.table.getItemList().getItemAt(indices[0]);
            if (item instanceof IMessage) {
                return ((IMessage)item).isInChecklist();
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return false;
    }

    private int getTargetIndex(Point point) {
        int index = this.table.rowAtPoint(point);
        this.table.getRowHeight(index);
        return index;
    }

    private boolean isDropBelow(Point point) {
        int index = this.table.rowAtPoint(point);
        this.table.getRowHeight(index);
        return this.dragLocation.y > this.table.getCellRect((int)index, (int)0, (boolean)true).getLocation().y + this.table.getRowHeight() / 3;
    }

    private void processDropOnCheckList(DropTargetDropEvent event) {
        try {
            if (!this.transferFromDifferentFolder) {
                int index = this.getTargetIndex(event.getLocation());
                TransferItems transferItems = (TransferItems)event.getTransferable().getTransferData(GWFlavors.transferItemsFlavor);
                boolean moveInto = this.table.isSubDrop(event.getLocation());
                logger.debug((Object)("moveInto: " + moveInto));
                this.table.getItemList().transferToTasklist(transferItems, index, this.isDropBelow(event.getLocation()), moveInto);
                event.dropComplete(true);
            } else {
                AbstractFolder targetFolder;
                boolean transferSucceeded;
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(GWFlavors.singleTableItemFlavor)) {
                    GWFlavors.SingleItem item = (GWFlavors.SingleItem)transferable.getTransferData(GWFlavors.singleTableItemFlavor);
                    this.table.getModel().getItemList().addItemListListener(this.itemListlistener);
                    this.itemListlistener.activate(false, item.getId());
                }
                if (!(transferSucceeded = this.performTransferToFolder(event, targetFolder = this.getParentFolder()))) {
                    event.dropComplete(false);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private void processDropOnFolder(DropTargetDropEvent event) {
        IFolder folder = (IFolder)this.table.getItemList().getItemAt(this.table.rowAtPoint(this.dragLocation));
        AbstractFolder targetFolder = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.table)).getGWFolder(folder);
        boolean transferSucceeded = this.performTransferToFolder(event, targetFolder);
        logger.debug((Object)("transferSucceeded: " + transferSucceeded));
        event.dropComplete(transferSucceeded);
    }

    private void processDropOnMessages(DropTargetDropEvent event) {
        try {
            if (!this.transferFromDifferentFolder) {
                int[] indices = (int[])event.getTransferable().getTransferData(GWFlavors.indicesFlavor);
                if (this.transferFromDifferentView) {
                    if (this.targetViewMode == 7) {
                        int index = this.getTargetIndex(event.getLocation());
                        TransferItems transferItems = (TransferItems)event.getTransferable().getTransferData(GWFlavors.transferItemsFlavor);
                        boolean result = this.table.getItemList().transferToTasklist(transferItems, index, false, false);
                        logger.debug((Object)("############################################## result: " + result));
                    }
                } else {
                    this.removeItemFromCheckList(indices[0]);
                }
                event.dropComplete(true);
            } else {
                AbstractFolder targetFolder;
                boolean transferSucceeded;
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(GWFlavors.singleTableItemFlavor)) {
                    GWFlavors.SingleItem item = (GWFlavors.SingleItem)transferable.getTransferData(GWFlavors.singleTableItemFlavor);
                    this.table.getModel().getItemList().addItemListListener(this.itemListlistener);
                    this.itemListlistener.activate(false, item.getId());
                }
                if (!(transferSucceeded = this.performTransferToFolder(event, targetFolder = this.getParentFolder()))) {
                    event.dropComplete(false);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private void processSimpleDrop(DropTargetDropEvent event) {
        AbstractFolder targetFolder = this.getParentFolder();
        boolean transferSucceeded = this.performTransferToFolder(event, targetFolder);
        logger.debug((Object)("transferSucceeded: " + transferSucceeded));
        event.dropComplete(transferSucceeded);
    }

    private AbstractFolder getParentFolder() {
        return EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.table)).getGWFolder(this.table.getFolder());
    }

    private boolean performTransferToFolder(DropTargetDropEvent event, AbstractFolder targetFolder) {
        return this.table instanceof ItemListTable && DnDUtils.performTransferToFolder(event, targetFolder, ((ItemListTable)this.table).getController());
    }

    private boolean isMultipleItemTransfer(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(GWFlavors.indicesFlavor)) {
            return false;
        }
        try {
            int[] indices = (int[])transferable.getTransferData(GWFlavors.indicesFlavor);
            return indices.length > 1;
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isSingleFolderTransfer(Transferable transferable) {
        try {
            if (!transferable.isDataFlavorSupported(GWFlavors.singleTableItemFlavor)) {
                return false;
            }
            GWFlavors.SingleItem item = (GWFlavors.SingleItem)transferable.getTransferData(GWFlavors.singleTableItemFlavor);
            return item != null && item.getType() == 1;
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void removeItemFromCheckList(int index) {
        IItem item = this.table.getItemList().getItemAt(index);
        if (item instanceof IMessage) {
            ((IMessage)item).showInChecklist(false);
        }
    }

    private void moveToCheckList(int fromIndex) {
        IItemList itemList;
        int maxIndex;
        int insertIndex = this.table.rowAtPoint(this.dragLocation);
        logger.debug((Object)("initial insertIndex: " + insertIndex));
        if (this.dragLocation.y > this.table.getCellRect((int)insertIndex, (int)0, (boolean)true).getLocation().y + this.table.getRowHeight() / 2) {
            ++insertIndex;
        }
        if (insertIndex > (maxIndex = (itemList = this.table.getModel().getItemList()).findLastUncompletedChecklistItemIndex() + 1)) {
            insertIndex = maxIndex;
        }
        logger.debug((Object)("corrected insertIndex: " + insertIndex));
        logger.debug((Object)("Inserting from " + fromIndex + " to " + insertIndex));
        if (itemList.isCollapsedAutoDateItemAt(fromIndex)) {
            IMessage nativeMessage = (IMessage)itemList.getItemAt(fromIndex);
            String itemType = "";
            if (nativeMessage.getItemType() == ItemType.APPT) {
                itemType = StringResources.APPOINTMENT;
            } else if (nativeMessage.getItemType() == ItemType.NOTE) {
                itemType = StringResources.NOTE;
            } else if (nativeMessage.getItemType() == ItemType.TODO) {
                itemType = StringResources.TASK;
            }
            int result = EngineCallBackListener.doPromptAutodate(StringResources.SUBJECT_C + " " + nativeMessage.getSubject(), StringResources.formatString(StringResources.MOVE_AUTO_DATE, itemType), false);
            if (result == 7) {
                itemList.checklistMoveTo(fromIndex, insertIndex, false);
            } else if (result == 6) {
                itemList.checklistMoveTo(fromIndex, insertIndex, true);
            }
        } else {
            logger.debug((Object)("fromIndex: " + fromIndex));
            logger.debug((Object)("insertIndex: " + insertIndex));
            itemList.checklistMoveTo(fromIndex, insertIndex);
        }
    }

    private class DropTargetItemListListener
    implements IItemListListener {
        private boolean active = false;
        private String itemId;
        private boolean removeFromCheckList = false;

        private DropTargetItemListListener() {
        }

        public void contentsChanged(ItemListEvent e) {
            if (!this.active) {
                return;
            }
            logger.debug((Object)("contentsChanged: " + e.getType() + ", " + e.getIndex()));
            if (e.getType() == 3) {
                int newItemIndex = -1;
                int size = ItemListTableDropTargetListener.this.table.getModel().getItemList().getSize();
                for (int i = 0; i < size; ++i) {
                    IItem item = ItemListTableDropTargetListener.this.table.getItemList().getItemAt(i);
                    if (!(item instanceof IMessage)) continue;
                    try {
                        AbstractItem abstractItem = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(ItemListTableDropTargetListener.this.table)).getItem(ItemListTableDropTargetListener.this.table.getItemList(), (IMessage)item);
                        if (!abstractItem.getID().equals(this.itemId)) continue;
                        newItemIndex = i;
                        break;
                    }
                    catch (GWCommandException e1) {
                        logger.error((Object)e1);
                    }
                }
                if (newItemIndex == -1) {
                    logger.warn((Object)"newly inserted element not found");
                    this.active = false;
                    return;
                }
                if (this.removeFromCheckList) {
                    IItem item = ItemListTableDropTargetListener.this.table.getItemList().getItemAt(newItemIndex);
                    if (item instanceof IMessage && ((IMessage)item).isInChecklist()) {
                        logger.debug((Object)("removing item #" + newItemIndex + " from check list"));
                        ItemListTableDropTargetListener.this.removeItemFromCheckList(newItemIndex);
                    }
                } else {
                    logger.debug((Object)("moving item #" + newItemIndex + " to its new position in check list"));
                    ItemListTableDropTargetListener.this.moveToCheckList(newItemIndex);
                }
                this.active = false;
            }
        }

        public void activate(boolean remove, String id) {
            this.removeFromCheckList = remove;
            this.itemId = id;
            this.active = true;
        }

        public void moreResultsAvailable(ItemListEvent e) {
        }

        public void queryResultsDone(ItemListEvent e) {
        }

        public void notifyEmptyList(ItemListEvent e) {
        }
    }
}

