/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level03;

import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.application.controls.itemlisttable.IconsFactory;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableDetailsColumn;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableHeaderRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class SortableHeaderRenderer
extends ItemListTableHeaderRenderer {
    private static final int ICON_TEXT_GAP = 10;

    public SortableHeaderRenderer() {
        this.setIcon(IconsFactory.getBlankSortIcon());
        this.setIconTextGap(10);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        if (tableColumn instanceof ItemListTableDetailsColumn) {
            IColumnFieldInfo fieldInfo = ((ItemListTableDetailsColumn)tableColumn).getColumnFieldInfo();
            if (fieldInfo.isSorted()) {
                if (fieldInfo.getSortOption() == 16) {
                    this.setIcon(IconsFactory.getAscendingSortIcon());
                } else {
                    this.setIcon(IconsFactory.getDescendingSortIcon());
                }
            } else {
                this.setIcon(IconsFactory.getBlankSortIcon());
            }
        }
        return this;
    }
}

