/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlistview;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.itemlisttable.level03.ItemListTable_Level03;
import com.novell.gw.jclient.application.controls.itemlisttable.level06.ItemListTable_Level06;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewCoolModel;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewPanel;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewPanelController;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class ItemListViewCoolPanel
extends OrientablePanel {
    private static final Logger logger = Logger.getLogger(ItemListViewPanel.class);
    private ItemListViewPanelController controller;
    private ItemListViewCoolModel itemListViewModel;
    private JComponent content;
    private Thread buildThread;

    public ItemListViewCoolPanel(IFolder folder, IViewDisplaySettings viewDisplaySettings, ItemListFilter filter, MVCController parentController) {
        this.setLayout(new BorderLayout());
        this.setMVCModel(new ItemListViewCoolModel(folder, viewDisplaySettings, filter));
    }

    public ItemListViewCoolPanel(ItemListViewPanelController controller) {
        this(null, null, null, controller);
    }

    public IFolder getFolder() {
        return this.getMVCModel().getFolder();
    }

    public IViewDisplaySettings getViewDisplaySettings() {
        return this.getMVCModel().getViewDisplaySettings();
    }

    public void setViewDisplaySettings(IViewDisplaySettings viewDisplaySettings) {
        this.getMVCModel().setViewDisplaySettings(viewDisplaySettings);
    }

    public void refresh() {
        if (this.getFolder() == null || this.getViewDisplaySettings() == null) {
            return;
        }
        this.getMVCModel().clear();
        if (this.buildThread != null && this.buildThread.isAlive()) {
            this.buildThread.interrupt();
        }
        if (this.content instanceof ItemListTable_Level03) {
            ((ItemListTable_Level03)this.content).dispose();
        }
        this.removeAll();
        this.add(new JLabel("LOADING...", 0));
        this.validateTree();
        IViewDisplaySettings displaySettings = this.getViewDisplaySettings();
        int viewMode = displaySettings.getViewMode();
        if (viewMode == 1 || viewMode == 7 || viewMode == 5) {
            this.buildThread = new Thread(){

                public void run() {
                    ItemListViewCoolPanel.this.content = new ItemListTable_Level06(ItemListViewCoolPanel.this.getFolder(), ItemListViewCoolPanel.this.getViewDisplaySettings(), ItemListViewCoolPanel.this.getItemList());
                    ItemListViewCoolPanel.this.removeAll();
                    ItemListViewCoolPanel.this.add(new JScrollPane(ItemListViewCoolPanel.this.content));
                    ItemListViewCoolPanel.this.validateTree();
                }
            };
            this.buildThread.start();
        } else {
            this.removeAll();
            this.add(new JLabel("COLUMN_EMPTY", 0));
            this.validateTree();
        }
    }

    public void setFilter(ItemListFilter filter) {
        this.getMVCModel().setFilter(filter);
    }

    public void setData(IFolder folder, IViewDisplaySettings displaySettings, ItemListFilter filter) {
        logger.debug((Object)("folder: " + folder.getName()));
        logger.debug((Object)("displaySettings: " + displaySettings));
        this.getMVCModel().setData(folder, displaySettings, filter);
    }

    public ItemListFilter getFilter() {
        return this.getMVCModel().getFilter();
    }

    public IItemList getItemList() {
        return this.getMVCModel().getItemList();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setController(ItemListViewPanelController controller) {
        this.controller = controller;
    }

    public ItemListViewPanelController getController() {
        return this.controller;
    }

    public void setMVCModel(ItemListViewCoolModel model) {
        this.itemListViewModel = model;
    }

    public ItemListViewCoolModel getMVCModel() {
        return this.itemListViewModel;
    }

    public void dispose() {
        if (this.content != null && this.content instanceof ItemListTable_Level03) {
            ((ItemListTable_Level03)this.content).dispose();
        }
    }
}

