/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlistview;

import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.itemlistview.IItemListViewModelListener;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import java.util.Collection;
import java.util.HashSet;

public class ItemListViewModel {
    private AbstractFolder folder;
    private AbstractFolder parentFolder;
    private IViewDisplaySettings viewDisplaySettings;
    private Filter filter;
    private IItemList itemList;
    private Collection<IItemListViewModelListener> modelListeners = new HashSet<IItemListViewModelListener>();
    private Collection<IItemListListener> attachedItemListListeners = new HashSet<IItemListListener>();
    private IItemListListener itemListChangeListener = new ItemListChangeListener();
    private IItemListListener itemListQueryListener = null;

    public ItemListViewModel(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, Filter filter) {
        this(folder, folder, viewDisplaySettings, filter);
    }

    public ItemListViewModel(AbstractFolder folder, AbstractFolder parentFolder, IViewDisplaySettings viewDisplaySettings, Filter filter) {
        this.setData(folder, parentFolder, viewDisplaySettings, filter);
    }

    public void setData(AbstractFolder folder, AbstractFolder parentFolder, IViewDisplaySettings viewDisplaySettings, Filter filter) {
        this.beforeFolderChange(this.folder);
        this.clear();
        this.folder = folder;
        this.parentFolder = parentFolder;
        this.viewDisplaySettings = viewDisplaySettings;
        this.filter = filter;
    }

    public void setData(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, Filter filter) {
        this.setData(folder, folder, viewDisplaySettings, filter);
    }

    private void beforeFolderChange(AbstractFolder currentFolder) {
        if (currentFolder != null && currentFolder.getNativeFolder().isInternetFolder()) {
            currentFolder.getNativeFolder().cancelExternalAccountSync();
        }
    }

    public synchronized IItemList getItemList() {
        if (this.itemList == null) {
            this.initItemList();
        }
        return this.itemList;
    }

    private void initItemList() {
        Filter filter = this.getFilter();
        this.itemList = this.getFolder().getContents(filter == null ? null : filter.getItemListFilter(), this.getViewDisplaySettings());
        this.afterItemListCreated();
        if (this.folder.getNativeFolder().getType() == FolderType.QUERY) {
            this.fireItemListQueryStarted();
        }
    }

    public void clear() {
        this.beforeItemListCleared();
        this.itemList = null;
    }

    public AbstractFolder getAbstractFolder() {
        return this.folder;
    }

    public IFolder getFolder() {
        return this.getAbstractFolder().getNativeFolder();
    }

    public IFolder getParentFolder() {
        return this.parentFolder.getNativeFolder();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public IViewDisplaySettings getViewDisplaySettings() {
        return this.viewDisplaySettings;
    }

    public void setViewDisplaySettings(IViewDisplaySettings viewDisplaySettings) {
        this.viewDisplaySettings = viewDisplaySettings;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        if (this.itemList != null) {
            this.itemList.setFilter(filter == null ? null : filter.getItemListFilter());
        }
    }

    void addItemListViewModelListener(IItemListViewModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.modelListeners.add(listener);
    }

    void removeItemListViewModelListener(IItemListViewModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.modelListeners.remove(listener);
    }

    private IItemListListener getItemListQueryListener() {
        if (this.itemListQueryListener == null) {
            this.itemListQueryListener = new ItemListQueryListener();
        }
        return this.itemListQueryListener;
    }

    private void afterItemListCreated() {
        if (this.itemList != null) {
            this.itemList.addItemListListener(this.itemListChangeListener);
            this.attachedItemListListeners.add(this.itemListChangeListener);
            if (this.folder instanceof QueryFolder) {
                this.itemList.addItemListListener(this.getItemListQueryListener());
                this.attachedItemListListeners.add(this.getItemListQueryListener());
            }
        }
    }

    private void beforeItemListCleared() {
        if (this.itemList != null) {
            if (this.folder instanceof QueryFolder) {
                this.itemList.queryStop();
            }
            for (IItemListListener listener : this.attachedItemListListeners) {
                this.itemList.removeItemListListener(listener);
            }
        }
    }

    private void fireNothingFound(ItemListEvent e) {
        for (IItemListViewModelListener listener : this.modelListeners) {
            listener.nothingFound(this, e);
        }
    }

    private void fireItemListChanged() {
        for (IItemListViewModelListener listener : this.modelListeners) {
            listener.itemListChanged(this);
        }
    }

    private void fireItemListQueryStarted() {
        for (IItemListViewModelListener listener : this.modelListeners) {
            listener.itemListQueryStarted(this);
        }
    }

    private void fireItemListQueryFinished() {
        for (IItemListViewModelListener listener : this.modelListeners) {
            listener.itemListQueryFinished(this);
        }
    }

    private class ItemListQueryListener
    implements IItemListListener {
        private ItemListQueryListener() {
        }

        public void contentsChanged(ItemListEvent e) {
        }

        public void moreResultsAvailable(ItemListEvent e) {
        }

        public void queryResultsDone(ItemListEvent e) {
            ItemListViewModel.this.fireItemListQueryFinished();
        }

        public void notifyEmptyList(ItemListEvent e) {
        }
    }

    private class ItemListChangeListener
    implements IItemListListener {
        private ItemListChangeListener() {
        }

        public void contentsChanged(ItemListEvent e) {
            ItemListViewModel.this.fireItemListChanged();
        }

        public void moreResultsAvailable(ItemListEvent e) {
            ItemListViewModel.this.fireItemListChanged();
        }

        public void queryResultsDone(ItemListEvent e) {
            ItemListViewModel.this.fireItemListChanged();
        }

        public void notifyEmptyList(ItemListEvent e) {
            ItemListViewModel.this.fireItemListChanged();
            ItemListViewModel.this.fireNothingFound(e);
        }
    }
}

