/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ApplicationFrame;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ExtraPopup;
import com.novell.gw.jclient.application.controls.ExtraPopupImpl;
import com.novell.gw.jclient.application.controls.addressbook.DistributionListRenderer;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.actions.AbstractRecipientAction;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionAddToFrequentContacts;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionCopyRecipient;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionEmailToUser;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionViewRecipientInfo;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RecipientsMenu
extends GWPopupMenu {
    private static Logger logger = Logger.getLogger(RecipientsMenu.class);
    private JList listRecipients = new JList();
    private ExtraPopup extendedPopup;
    private AbstractRecipientAction actionAddToFrequentContacts;
    private AbstractRecipientAction actionViewRecipientInfo;
    private AbstractRecipientAction actionCopyRecipient;
    private AbstractRecipientAction actionMailToUser;
    private JComponent parent;
    protected OrientableScrollPane scroll;

    public RecipientsMenu(JComponent parent) {
        this.parent = parent;
        this.setFocusable(false);
        this.listRecipients.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.listRecipients.setCellRenderer(new DistributionListRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent listCellRendererComponent = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                listCellRendererComponent.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
                return listCellRendererComponent;
            }
        });
        this.listRecipients.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int selectedIndex;
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                if (index != (selectedIndex = list.getSelectedIndex())) {
                    list.setSelectedIndex(index);
                    RecipientsMenu.this.getExtendedPopup().hide();
                }
            }
        });
        this.scroll = new OrientableScrollPane(this.listRecipients);
        this.scroll.setBorder(null);
        this.add(this.scroll);
        this.listRecipients.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                RecipientsMenu.this.doPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                RecipientsMenu.this.doPopup(e);
            }
        });
        this.listRecipients.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = ((JList)e.getSource()).getSelectedIndex();
                if (index != -1) {
                    IRecipient recipient = (IRecipient)RecipientsMenu.this.listRecipients.getModel().getElementAt(index);
                    RecipientsMenu.this.setData(recipient);
                }
            }
        });
    }

    private void setData(IRecipient theRecipient) {
        this.initActions();
        this.actionAddToFrequentContacts.setRecipient(theRecipient);
        this.actionViewRecipientInfo.setRecipient(theRecipient);
        this.actionCopyRecipient.setRecipient(theRecipient);
        this.actionMailToUser.setRecipient(theRecipient);
    }

    private void initActions() {
        ApplicationFrame af = (ApplicationFrame)ControlsUtils.getWindowForComponent(this.parent);
        if (this.actionMailToUser == null) {
            this.actionMailToUser = new ActionEmailToUser(af){

                public void actionPerformed(ActionEvent e) {
                    RecipientsMenu.this.setVisible(false);
                    super.actionPerformed(e);
                }
            };
        }
        if (this.actionAddToFrequentContacts == null) {
            this.actionAddToFrequentContacts = new ActionAddToFrequentContacts(af){

                public void actionPerformed(ActionEvent e) {
                    RecipientsMenu.this.setVisible(false);
                    super.actionPerformed(e);
                }
            };
        }
        if (this.actionViewRecipientInfo == null) {
            this.actionViewRecipientInfo = new ActionViewRecipientInfo(af){

                public void actionPerformed(ActionEvent e) {
                    RecipientsMenu.this.setVisible(false);
                    super.actionPerformed(e);
                }
            };
        }
        if (this.actionCopyRecipient == null) {
            this.actionCopyRecipient = new ActionCopyRecipient(){

                public void actionPerformed(ActionEvent e) {
                    RecipientsMenu.this.setVisible(false);
                    super.actionPerformed(e);
                }
            };
        }
    }

    private void refresh() {
    }

    private void doPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.listRecipients.getSelectedIndex() == -1) {
                int i = this.listRecipients.locationToIndex(e.getPoint());
                this.listRecipients.setSelectedIndex(i);
            }
            ExtraPopup popup = this.getExtendedPopup();
            int y = e.getY();
            if (this.listRecipients.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)this.listRecipients.getParent();
                y -= viewport.getViewPosition().y;
            }
            popup.show(e.getX(), y);
        }
    }

    private ExtraPopup getExtendedPopup() {
        if (this.extendedPopup == null) {
            this.extendedPopup = new ExtraPopupImpl(this);
            this.extendedPopup.add(this.actionAddToFrequentContacts);
            this.extendedPopup.add(this.actionViewRecipientInfo);
            this.extendedPopup.addSeparator();
            this.extendedPopup.add(this.actionCopyRecipient);
            this.extendedPopup.addSeparator();
            this.extendedPopup.add(this.actionMailToUser);
        }
        return this.extendedPopup;
    }

    public void clearRecipients() {
        this.listRecipients.setListData(new Object[0]);
    }

    public void setRecipients(List<IRecipient> theRecipientsList) {
        this.listRecipients.setListData(theRecipientsList.toArray());
        Dimension preferredSize = this.listRecipients.getPreferredSize();
        if (preferredSize.height >= 400) {
            preferredSize.height = 400;
        }
        this.scroll.setPreferredSize(preferredSize);
        this.pack();
    }
}

