/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ApplicationFrame;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.SensitiveLabel;
import com.novell.gw.jclient.application.controls.itemview.UneditableTextField;
import com.novell.gw.jclient.application.controls.itemview.actions.AbstractRecipientAction;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionAddToFrequentContacts;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionCopyRecipient;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionEmailToUser;
import com.novell.gw.jclient.application.controls.itemview.actions.ActionViewRecipientInfo;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenuItem;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientsTextField
extends UneditableTextField {
    private boolean manualSelected;
    private List<IRecipient> recipients;
    private static final char[] RECIPIENTS_DELIMITER = new char[]{';'};
    private AbstractRecipientAction actionAddToContacts;
    private AbstractRecipientAction actionViewRecipientInfo;
    private AbstractRecipientAction actionCopyRecipient;
    private AbstractRecipientAction actionSendEmail;

    public RecipientsTextField(List<IRecipient> theRecipients, SensitiveLabel theLabel) {
        super(theLabel);
        this.setRecipients(theRecipients);
        this.addMouseListener(new RecipientsTextFieldMouseListener());
    }

    public String getRecipientsText() {
        return ControlsUtils.recipientsToString(this.recipients);
    }

    public void setRecipients(List<IRecipient> theRecipients) {
        this.recipients = theRecipients;
        this.setText(this.getRecipientsText());
    }

    public boolean isAllTextVisible() {
        return ControlsUtils.isComponentTextVisible(this);
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            IRecipient recipient = this.getSelectedRecipient(e.getPoint());
            this.initActions();
            this.actionSendEmail.setRecipient(recipient);
            this.actionAddToContacts.setRecipient(recipient);
            this.actionViewRecipientInfo.setRecipient(recipient);
            this.actionCopyRecipient.setRecipient(recipient);
            GWPopupMenu popupMenu = new GWPopupMenu();
            GWMenu menuAddToAB = new GWMenu(StringResources.ADD_TO_ADDRESS_BOOK);
            for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
                ApplicationFrame appFrame = (ApplicationFrame)ControlsUtils.getWindowForComponent(this);
                if (addressBook instanceof GroupWiseAddressBook) continue;
                ((JMenu)menuAddToAB).add(new AddToABAction(appFrame, addressBook, recipient));
            }
            popupMenu.add(menuAddToAB);
            ((JPopupMenu)popupMenu).add(this.actionViewRecipientInfo);
            popupMenu.addSeparator();
            ((JPopupMenu)popupMenu).add(this.actionCopyRecipient);
            popupMenu.addSeparator();
            ((JPopupMenu)popupMenu).add(this.actionSendEmail);
            popupMenu.show(this, e.getX(), e.getY());
        }
    }

    private IRecipient getSelectedRecipient(Point thePoint) {
        String displayName = this.getSeletedDisplayName(thePoint);
        int nSize = this.recipients.size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = this.recipients.get(i);
            if (!recipient.getAddressable().getDisplayName().equals(displayName)) continue;
            return recipient;
        }
        return null;
    }

    private void selectWord(Point point) {
        this.setSelectedTextColor(Utils.invertColor(this.getForeground()));
        this.setSelectionStart(this.getNearestLeftDelimiterIndex(point));
        this.setSelectionEnd(this.getNearestRightDelimiterIndex(point));
        this.setManualSelected(true);
    }

    private int getNearestLeftDelimiterIndex(Point point) {
        String left = this.getText().substring(0, this.viewToModel(point));
        int delimIndex = 0;
        for (char delimiter : RECIPIENTS_DELIMITER) {
            int index = left.lastIndexOf(delimiter);
            if (index <= delimIndex) continue;
            delimIndex = index + 1;
        }
        return delimIndex;
    }

    private int getNearestRightDelimiterIndex(Point point) {
        String left = this.getText().substring(0, this.viewToModel(point));
        int indexFrom = left.length();
        int delimIndex = this.getText().length();
        for (char delimiter : RECIPIENTS_DELIMITER) {
            int index = this.getText().indexOf(delimiter, indexFrom);
            if (index == -1 || index >= delimIndex) continue;
            delimIndex = index;
        }
        return delimIndex;
    }

    private String getSeletedDisplayName(Point point) {
        int right = this.getNearestRightDelimiterIndex(point);
        int left = this.getNearestLeftDelimiterIndex(point);
        String result = "";
        result = left < 0 || left == 0 ? this.getText().substring(0, right) : this.getText().substring(left + 1, right);
        return result;
    }

    private void initActions() {
        ApplicationFrame af = (ApplicationFrame)ControlsUtils.getWindowForComponent(this);
        if (this.actionAddToContacts == null) {
            this.actionAddToContacts = new ActionAddToFrequentContacts(af);
        }
        if (this.actionViewRecipientInfo == null) {
            this.actionViewRecipientInfo = new ActionViewRecipientInfo(af);
        }
        if (this.actionCopyRecipient == null) {
            this.actionCopyRecipient = new ActionCopyRecipient();
        }
        if (this.actionSendEmail == null) {
            this.actionSendEmail = new ActionEmailToUser(af);
        }
    }

    @Override
    protected void handleFocus(boolean isGained) {
        super.handleFocus(isGained);
        if (isGained && this.manualSelected) {
            this.manualSelected = false;
        } else {
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
            this.manualSelected = false;
        }
    }

    public void setManualSelected(boolean b) {
        this.manualSelected = b;
    }

    private class AddToABAction
    extends AbstractAction {
        private AbstractAddressBook abstractAddressBook;
        IRecipient recipient;
        ApplicationFrame appFrame;

        public AddToABAction(ApplicationFrame theApplicationFrame, AbstractAddressBook theAbstractAddressBook, IRecipient recipient) {
            super(theAbstractAddressBook.getName());
            this.abstractAddressBook = theAbstractAddressBook;
            this.recipient = recipient;
            this.appFrame = theApplicationFrame;
        }

        public void actionPerformed(ActionEvent e) {
            IAddressable addressable = this.recipient.getAddressable();
            if (addressable instanceof IAddress) {
                IAddress contact = (IAddress)addressable;
                UserContactDetailsDialog dlg = new UserContactDetailsDialog((JFrame)this.appFrame, this.abstractAddressBook, null, contact);
                dlg.showMe();
            }
        }

        public OrientableMenuItem getMenuItem() {
            return new OrientableMenuItem(this);
        }
    }

    private class RecipientsTextFieldMouseListener
    extends MouseAdapter {
        private RecipientsTextFieldMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            RecipientsTextField.this.selectWord(e.getPoint());
            RecipientsTextField.this.requestFocus();
            RecipientsTextField.this.showPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
            RecipientsTextField.this.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent e) {
            RecipientsTextField.this.setCursor(new Cursor(0));
        }

        public void mouseReleased(MouseEvent e) {
            RecipientsTextField.this.showPopup(e);
        }
    }
}

