/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.contentviewer;

import com.appframework.utils.NetUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class HTMLHyperlinkListener {
    private static Logger logger = Logger.getLogger(HTMLHyperlinkListener.class);

    protected void processURL(final String theURL) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doProcessURL(theURL);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HTMLHyperlinkListener.this.doProcessURL(theURL);
                }
            });
        }
    }

    protected void doProcessURL(String newUrl) {
        URL url = null;
        try {
            url = new URL(newUrl);
        }
        catch (MalformedURLException e) {
            logger.error((Object)e, (Throwable)e);
        }
        if (url == null) {
            return;
        }
        if (url.getProtocol() == null) {
            return;
        }
        if (NetUtils.isMailtoUrl(newUrl)) {
            MessageUtils.composeMail(newUrl);
        } else {
            Utils.callExternal(url.toExternalForm());
        }
    }
}

