/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.folder.IContactsFolder;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionViewCalendar;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.menus.ApplicationFrameMenuBarController;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListener;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListenerForContacts;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.mnemonic.MnemonicMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenu;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendarActionList;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationFrameMenuBar
extends GWMenuBar
implements MVCView<ApplicationFrameMenuBarController, Object> {
    private static Logger logger = Logger.getLogger(ApplicationFrameMenuBar.class);
    public static final String MENU_WINDOW = "Menu Window";
    protected ApplicationFrameActionList appActionList;
    protected ApplicationFrameMenuBarController controller;
    protected GWMenu menuFile;
    protected GWMenu subMenuNew = new MnemonicMenu(StringResources.MENU_NEW);
    protected GWMenu menuEdit;
    protected GWMenu menuView;
    protected GWMenu menuActions;
    protected GWMenu menuTools;
    protected GWMenu menuAccounts;
    protected JMenuItem menuAccountsSendRetrieve;
    protected GWMenu menuWindow;
    protected GWMenu menuHelp;
    protected JMenuItem miExit;

    public ApplicationFrameMenuBar(ApplicationFrameActionList theAppActionList) {
        this.appActionList = theAppActionList;
        this.build();
        this.setBorderPainted(true);
        Level level = theAppActionList.getFrameLevel();
        this.appActionList.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, new FOLDER_SELECTED_Listener()));
        this.controller = new ApplicationFrameMenuBarController(this, (MVCController)this.appActionList);
    }

    private void build() {
        this.menuFile = new MnemonicMenu(StringResources.MENU_FILE);
        this.buildFile();
        this.add(this.menuFile);
        this.menuEdit = new MnemonicMenu(StringResources.MENU_EDIT);
        this.buildEdit(this.menuEdit);
        this.add(this.menuEdit);
        this.menuView = new MnemonicMenu(StringResources.MENU_VIEW);
        this.buildView();
        this.add(this.menuView);
        this.menuActions = new MnemonicMenu(StringResources.MENU_ACTIONS);
        this.add(this.menuActions);
        this.menuTools = new MnemonicMenu(StringResources.MENU_TOOLS);
        this.buildTools();
        this.add(this.menuTools);
        String userGuid = ((ApplicationFrame)this.appActionList.getOwnerComponent()).getUserGuid();
        IDataStore dataStore = GWCommandManager.getInstance(userGuid).getCurrentDataStore();
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING || dataStore.canDoPopAndImapAccounts() || dataStore.canDoNntpAccounts()) {
            this.menuAccounts = new MnemonicMenu(StringResources.MENU_ACCOUNTS);
            this.buildAccounts();
            this.add(this.menuAccounts);
        }
        this.menuWindow = new MnemonicMenu(StringResources.MENU_WINDOW){

            public JMenuItem add(JMenuItem menuItem) {
                logger.debug((Object)("action + " + menuItem.getText()));
                return super.add(menuItem);
            }
        };
        this.menuWindow.setName(MENU_WINDOW);
        this.buildWindow();
        this.add(this.menuWindow);
        this.menuHelp = new MnemonicMenu(StringResources.MENU_HELP);
        this.buildHelp();
        this.add(this.menuHelp);
    }

    private void buildAccounts() {
        this.menuAccountsSendRetrieve = this.appActionList.getAction(ActionKey.SEND_RETRIVE).getMenuItem();
        if (OS.isMacOS()) {
            this.menuAccountsSendRetrieve.setIcon(null);
        }
        this.menuAccounts.add(this.menuAccountsSendRetrieve);
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            this.menuAccounts.add(this.appActionList.getAction(ActionKey.RETRIEVE_CONTACTS).getMenuItem());
        }
        this.menuAccounts.addSeparator();
        JMenuItem item = this.appActionList.getAction(ActionKey.SHOW_STATUS_WINDOW).getMenuItem();
        this.menuAccounts.add(item);
        this.menuAccounts.addSeparator();
        item = this.appActionList.getAction(ActionKey.AUTO_SEND_RETRIVE).getMenuItem();
        this.menuAccounts.add(item);
        item = this.appActionList.getAction(ActionKey.ACCOUNT_OPTIONS).getMenuItem();
        this.menuAccounts.add(item);
    }

    private void buildView() {
        JMenuItem item = this.appActionList.getAction(ActionKey.REFRESH).getMenuItem();
        this.menuView.add(item);
    }

    private void buildEdit(GWMenu menuEdit) {
        JMenuItem item = this.appActionList.getAction(ActionKey.CUT).getMenuItem();
        menuEdit.add(item);
        item = this.appActionList.getAction(ActionKey.COPY).getMenuItem();
        menuEdit.add(item);
        item = this.appActionList.getAction(ActionKey.PASTE).getMenuItem();
        menuEdit.add(item);
        item = this.appActionList.getAction(ActionKey.SELECT_ALL).getMenuItem();
        menuEdit.add(item);
    }

    public void rebuildEdit(GWMenu menuEdit) {
        this.buildEdit(menuEdit);
    }

    public static void rebuildFileNew(GWMenu menuNew, ApplicationFrameActionList actionList) {
        ApplicationFrameMenuBar.doRebuildFileNew(menuNew, actionList, false, null);
    }

    public static void rebuildFileNewWithFolder(GWMenu menuNew, ApplicationFrameActionList actionList, boolean needAddContact) {
        ApplicationFrameMenuBar.doRebuildFileNew(menuNew, actionList, true, null, needAddContact);
    }

    public static void rebuildFileNewWithFolder(GWMenu menuNew, ApplicationFrameActionList actionList) {
        ApplicationFrameMenuBar.doRebuildFileNew(menuNew, actionList, true, null);
    }

    private static void doRebuildFileNew(GWMenu theMenuNew, ApplicationFrameActionList theActionList, boolean withFolder, AbstractFolder folder) {
        boolean needAddContact = true;
        if (folder != null && folder.getNativeFolder() instanceof IContactsFolder) {
            PersonalAddressBook addressBook = ((IContactsFolder)folder.getNativeFolder()).getAddressBook(EngineCommandManager.getAddressBookManager());
            needAddContact = addressBook != null && !addressBook.isReadOnly();
        }
        ApplicationFrameMenuBar.doRebuildFileNew(theMenuNew, theActionList, withFolder, folder, needAddContact);
    }

    private static void doRebuildFileNew(GWMenu theMenuNew, ApplicationFrameActionList theActionList, boolean withFolder, AbstractFolder folder, boolean needAddContact) {
        theMenuNew.removeAll();
        JMenuItem item = theActionList.getActionList().getAction(ActionKey.NEW_MAIL).getMenuItem();
        theMenuNew.add(item);
        item = theActionList.getActionList().getAction(ActionKey.NEW_APPOINTMENT).getMenuItem();
        theMenuNew.add(item);
        item = theActionList.getActionList().getAction(ActionKey.NEW_TASK).getMenuItem();
        theMenuNew.add(item);
        item = theActionList.getActionList().getAction(ActionKey.NEW_REMINDERNOTE).getMenuItem();
        theMenuNew.add(item);
        if (folder != null && folder instanceof NntpSubFolder) {
            AppAction a = theActionList.getActionList().getAction(ActionKey.NEW_DISCUSSION);
            a.setMVCModel(folder);
            theMenuNew.add(a.getMenuItem());
        } else {
            item = theActionList.getActionList().getAction(ActionKey.NEW_DISCUSSION_NOTE).getMenuItem();
            theMenuNew.add(item);
        }
        item = theActionList.getActionList().getAction(ActionKey.NEW_PHONEMESSAGE).getMenuItem();
        theMenuNew.add(item);
        item = theActionList.getActionList().getAction(ActionKey.NEW_TASKLIST_ITEM).getMenuItem();
        theMenuNew.add(item);
        AppAction newCalendarAction = theActionList.getActionList().getAction(ActionKey.NEW_CALENDAR);
        if (withFolder && theActionList.getActionList().getAction(ActionKey.NEW_FOLDER) != null) {
            theMenuNew.addSeparator();
            item = theActionList.getActionList().getAction(ActionKey.NEW_FOLDER).getMenuItem();
            item.setText(StringResources.FOLDER_D);
            UIUtils.setMnemonic(item, 0);
            theMenuNew.add(item);
            if (newCalendarAction.getMVCModel() instanceof CalendarFolder) {
                item = newCalendarAction.getMenuItem();
                item.setText(StringResources.CALENDAR_D);
                UIUtils.setMnemonic(item, 0);
                theMenuNew.add(item);
            }
        }
        if ((theActionList instanceof GWMainAppFrameActionList || theActionList instanceof FrameItemSearchActionList || theActionList instanceof FrameCalendarActionList || newCalendarAction == null) && (newCalendarAction == null || !(newCalendarAction.getMVCModel() instanceof CalendarFolder))) {
            if (!withFolder || theActionList.getActionList().getAction(ActionKey.NEW_FOLDER) == null) {
                theMenuNew.addSeparator();
            }
            theMenuNew.add(theActionList.getAction(ActionKey.NEW_CALENDAR_IN_DIALOG).getMenuItem());
        }
        if (needAddContact) {
            theMenuNew.addSeparator();
            item = theActionList.getActionList().getAction(ActionKey.NEW_CONTACT).getMenuItem();
            item.setText(StringResources.CONTACT);
            UIUtils.setMnemonic(item, 0);
            theMenuNew.add(item);
            item = theActionList.getActionList().getAction(ActionKey.NEW_RESOURCE).getMenuItem();
            item.setText(StringResources.RESOURCE);
            UIUtils.setMnemonic(item, 1);
            theMenuNew.add(item);
            item = theActionList.getActionList().getAction(ActionKey.NEW_ORGANIZATION).getMenuItem();
            item.setText(StringResources.ORGANIZATION);
            UIUtils.setMnemonic(item, 0);
            theMenuNew.add(item);
            item = theActionList.getActionList().getAction(ActionKey.NEW_GROUP).getMenuItem();
            item.setText(StringResources.GROUP);
            UIUtils.setMnemonic(item, 0);
            theMenuNew.add(item);
        }
    }

    private void buildFile() {
        ApplicationFrameMenuBar.rebuildFileNew(this.subMenuNew, this.appActionList);
        this.menuFile.add(this.subMenuNew);
    }

    private void buildTools() {
        JMenuItem item = this.appActionList.getAction(ActionKey.VIEW_ADDRESS_BOOK).getMenuItem();
        this.menuTools.add(item);
        GWMenu subMenu = new GWMenu(StringResources.NOTIFY);
        item = this.appActionList.getAction(ActionKey.ENABLE_NOTIFICATIONS).getMenuItem();
        subMenu.add(item);
        item = this.appActionList.getAction(ActionKey.DISPLAY_NOTIFICATION_LIST).getMenuItem();
        subMenu.add(item);
        item = this.appActionList.getAction(ActionKey.DISPLAY_NOTIFY_OPTIONS).getMenuItem();
        subMenu.add(item);
        subMenu.addSeparator();
        item = this.appActionList.getAction(ActionKey.SHOW_IN_TRAY).getMenuItem();
        subMenu.add(item);
        this.menuTools.add(subMenu);
        this.menuTools.addSeparator();
        String userGuid = ControlsUtils.getUserGuid(this.appActionList);
        if (GWCommandManager.getInstance(userGuid).isJunkMailMasterEnabled()) {
            item = this.appActionList.getAction(ActionKey.JUNK_MAIL_HANDLING).getMenuItem();
            this.menuTools.add(item);
        }
        item = this.appActionList.getAction(ActionKey.RULES).getMenuItem();
        this.menuTools.add(item);
        item = this.appActionList.getAction(ActionKey.FIND).getMenuItem();
        this.menuTools.add(item);
        this.addBusySearchItem();
        item = this.appActionList.getAction(ActionKey.TIMEDIFFERENCE).getMenuItem();
        this.menuTools.add(item);
        item = this.appActionList.getAction(ActionKey.DATEDIFFERENCE).getMenuItem();
        this.menuTools.add(item);
        if (EngineCommandManager.getCurrentMode() != EngineMode.ONLINE) {
            this.menuTools.addSeparator();
            item = this.appActionList.getAction(ActionKey.BACKUP_MAILBOX).getMenuItem();
            this.menuTools.add(item);
            item = this.appActionList.getAction(ActionKey.RETRIEVE_ENTIRE_MAILBOX).getMenuItem();
            this.menuTools.add(item);
        }
        if (!OS.isMacOS()) {
            this.menuTools.addSeparator();
            item = this.appActionList.getAction(ActionKey.OPTIONS).getMenuItem();
            this.menuTools.add(item);
        }
    }

    protected void addBusySearchItem() {
        JMenuItem item = this.appActionList.getAction(ActionKey.BUSYSEARCH).getMenuItem();
        this.menuTools.add(item);
    }

    private void buildWindow() {
        JMenuItem item = this.appActionList.getActionList().getAction(ActionKey.VIEW_MAIN_WINDOW).getMenuItem();
        this.menuWindow.add(item);
        GWMenu menuCalendars = new GWMenu(StringResources.NEW_CALENDAR_WINDOW);
        menuCalendars.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
        if (OS.isMacOS()) {
            menuCalendars.setIcon(null);
        }
        int nSize = PropertiesViewList.getItemTypesList().size();
        for (int i = 0; i < nSize; ++i) {
            menuCalendars.add(new CalendarTypeSelectAction(PropertiesViewList.getItemTypesList().get(i)).getMenuItem());
        }
        this.menuWindow.add(menuCalendars);
    }

    private void buildHelp() {
        JMenuItem item = this.appActionList.getAction(ActionKey.HELPTOPICS).getMenuItem();
        this.menuHelp.add(item);
        item = this.appActionList.getAction(ActionKey.WHATS_NEW).getMenuItem();
        this.menuHelp.add(item);
        this.menuHelp.addSeparator();
        item = this.appActionList.getAction(ActionKey.USER_GUIDE).getMenuItem();
        this.menuHelp.add(item);
        item = this.appActionList.getAction(ActionKey.COOL_SOLUTIONS_WEB_COMUNITY).getMenuItem();
        this.menuHelp.add(item);
        item = this.appActionList.getAction(ActionKey.HOMEPAGE).getMenuItem();
        this.menuHelp.add(item);
        if (!OS.isMacOS()) {
            this.menuHelp.addSeparator();
            item = this.appActionList.getAction(ActionKey.ABOUT).getMenuItem();
            this.menuHelp.add(item);
        }
    }

    public static GWMenu rebuildItemActionsMenu(GWMenu actionsMenu, ApplicationFrameActionList actionList, boolean putDeleteActions, boolean isContactSelection) {
        JMenu menuCategories;
        actionsMenu.removeAll();
        JMenuItem item = actionList.getAction(ActionKey.OPEN_ITEM).getMenuItem();
        actionsMenu.add(item);
        actionsMenu.addSeparator();
        item = actionList.getAction(ActionKey.ACCEPT).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.ACCEPT_WITH_OPTIONS).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.DECLINE).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.DECLINE_WITH_OPTIONS).getMenuItem();
        actionsMenu.add(item);
        actionsMenu.addSeparator();
        item = actionList.getAction(ActionKey.REPLY).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.FORWARD).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.FORWARD_AS_ATTACHMENT).getMenuItem();
        actionsMenu.add(item);
        if (putDeleteActions) {
            item = actionList.getAction(ActionKey.DELETE_OPEN_ITEM).getMenuItem();
            actionsMenu.add(item);
            item = actionList.getAction(ActionKey.DELETE_AND_EMPTY_ITEM).getMenuItem();
            actionsMenu.add(item);
        }
        item = actionList.getAction(ActionKey.MARK_READ_LATER).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.MARK_READ).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.DELEGATE).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.RESEND).getMenuItem();
        actionsMenu.add(item);
        if (isContactSelection) {
            menuCategories = (JMenu)actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU_CONTACTS).getMenuItem();
            menuCategories.addMenuListener(new CategoriesMenuListenerForContacts(actionList));
        } else {
            menuCategories = (JMenu)actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU).getMenuItem();
            menuCategories.addMenuListener(new CategoriesMenuListener(actionList));
        }
        actionsMenu.add(menuCategories);
        JMenu subMenu = (JMenu)actionList.getAction(ActionKey.SHOW_APPOINTMENT_AS_FOR_GWMENU).getMenuItem();
        ButtonGroup bg = new ButtonGroup();
        item = actionList.getAction(ActionKey.SHOW_AS_FREE).getMenuItem();
        bg.add(item);
        subMenu.add(item);
        item = actionList.getAction(ActionKey.SHOW_AS_TENTATIVE).getMenuItem();
        bg.add(item);
        subMenu.add(item);
        item = actionList.getAction(ActionKey.SHOW_AS_BUSY).getMenuItem();
        bg.add(item);
        subMenu.add(item);
        item = actionList.getAction(ActionKey.SHOW_AS_OUT_OF_OFFICE).getMenuItem();
        bg.add(item);
        subMenu.add(item);
        actionsMenu.add(subMenu);
        actionsMenu.addSeparator();
        item = actionList.getAction(ActionKey.ALARM).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.MARK_PRIVATE).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.COMPLETE).getMenuItem();
        actionsMenu.add(item);
        actionsMenu.addSeparator();
        item = actionList.getAction(ActionKey.MOVE_TO_ARCHIVE).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.RESTORE).getMenuItem();
        actionsMenu.add(item);
        actionsMenu.addSeparator();
        item = actionList.getAction(ActionKey.MOVE_TO_TASKLIST).getMenuItem();
        actionsMenu.add(item);
        item = actionList.getAction(ActionKey.SHOW_IN_CHECKLIST).getMenuItem();
        actionsMenu.add(item);
        if (actionList instanceof GWMainAppFrameActionList) {
            OrientableMenu menu = new OrientableMenu(StringResources.TASKLIST_ACTIONS);
            menu.add(actionList.getAction(ActionKey.NEW_TASKLIST_ITEM).getMenuItem());
            menu.add(actionList.getAction(ActionKey.NEW_TASKLIST_SUBITEM).getMenuItem());
            menu.add(actionList.getAction(ActionKey.HIDE_ITEMS_NOT_IN_TASKLIST).getMenuItem());
            menu.add(actionList.getAction(ActionKey.HIDE_COMPLETED_ITEMS_IMMEDIATELY).getMenuItem());
            menu.add(actionList.getAction(ActionKey.HIDE_COMPLETED_ITEMS_AFTER_A_DAY).getMenuItem());
            menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_TOP).getMenuItem());
            menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_BOTTOM).getMenuItem());
            menu.add(actionList.getAction(ActionKey.MOVE_TASK_RIGHT).getMenuItem());
            menu.add(actionList.getAction(ActionKey.MOVE_TASK_LEFT).getMenuItem());
            menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_UP).getMenuItem());
            menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_DOWN).getMenuItem());
            actionsMenu.add(menu);
        }
        return actionsMenu;
    }

    @Override
    public ApplicationFrameMenuBarController getController() {
        return this.controller;
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    @Override
    public void setController(ApplicationFrameMenuBarController theController) {
        this.controller = theController;
    }

    @Override
    public void setMVCModel(Object theModel) {
    }

    private class CalendarTypeSelectAction
    extends AbstractAction {
        private PropertiesViewListItem calendarType;
        private JMenuItem menuItem;

        public CalendarTypeSelectAction(PropertiesViewListItem calendarType) {
            this.calendarType = calendarType;
            this.menuItem = MenuItemFactory.createMenuItem(this);
            this.menuItem.setText(calendarType.getName());
        }

        public void actionPerformed(ActionEvent e) {
            ActionViewCalendar actionViewCalendar = (ActionViewCalendar)ApplicationFrameMenuBar.this.appActionList.getAction(ActionKey.VIEW_CALENDAR);
            actionViewCalendar.setCalendarType(this.calendarType);
            actionViewCalendar.actionPerformed(null);
        }

        public JMenuItem getMenuItem() {
            return this.menuItem;
        }
    }

    protected class FOLDER_SELECTED_Listener
    extends AppEventListener {
        protected FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ApplicationFrameMenuBar.doRebuildFileNew(ApplicationFrameMenuBar.this.subMenuNew, ApplicationFrameMenuBar.this.appActionList, true, (AbstractFolder)theEvent.getData());
        }
    }
}

