/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionSwitchMainToolBar;
import com.novell.gw.jclient.application.actions.ActionSwitchQVToolbar;
import com.novell.gw.jclient.application.controls.menus.ApplicationFrameMenuBar;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListener;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.mnemonic.MnemonicMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenu;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class GWApplicationFrameMenuBar
extends ApplicationFrameMenuBar {
    private int currentState = 1;

    public GWApplicationFrameMenuBar(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList);
        this.build();
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    private void build() {
        this.buildActions();
        this.buildFile();
        this.buildEdit(this.menuEdit);
        this.buildTools();
        this.buildView();
    }

    private void buildEdit(GWMenu editMenu) {
        editMenu.addSeparator();
        AppAction deleteContactAction = this.appActionList.getAction(ActionKey.DELETE_CONTACT);
        AppAction deleteItemAction = this.appActionList.getAction(ActionKey.DELETE_ITEM);
        JMenuItem item = deleteContactAction.isEnabled() ? deleteContactAction.getMenuItem() : deleteItemAction.getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.DELETE_AND_EMPTY_ITEM).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.RETRACT).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.RETRACT_AND_DELETE).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.DELETE_SENT_ITEM).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.EMPTY_ITEM).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.UNDELETE_ITEM).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.EMPTY_TRASH).getMenuItem();
        editMenu.add(item);
        MnemonicMenu subMenuChangeTo = new MnemonicMenu(StringResources.CHANGE_ITEM_TO);
        subMenuChangeTo.setIcon(ImageResources.ACT_CHANGETO);
        if (OS.isMacOS()) {
            subMenuChangeTo.setIcon(null);
        }
        item = this.appActionList.getAction(ActionKey.CHANGE_ITEM_TO_MAIL).getMenuItem();
        subMenuChangeTo.add(item);
        item = this.appActionList.getAction(ActionKey.CHANGE_ITEM_TO_APPOINTMENT).getMenuItem();
        subMenuChangeTo.add(item);
        item = this.appActionList.getAction(ActionKey.CHANGE_ITEM_TO_TASK).getMenuItem();
        subMenuChangeTo.add(item);
        item = this.appActionList.getAction(ActionKey.CHANGE_ITEM_TO_REMINDER).getMenuItem();
        subMenuChangeTo.add(item);
        item = this.appActionList.getAction(ActionKey.CHANGE_ITEM_TO_MESSAGE).getMenuItem();
        subMenuChangeTo.add(item);
        subMenuChangeTo.addSeparator();
        item = this.appActionList.getAction(ActionKey.CHANGE_ITEM_TO).getMenuItem();
        item.setText(StringResources.MORE_D);
        item.setIcon(null);
        subMenuChangeTo.add(item);
        editMenu.add(subMenuChangeTo);
        editMenu.addSeparator();
        item = this.appActionList.getAction(ActionKey.EDIT_FOLDERS).getMenuItem();
        editMenu.add(item);
        item = this.appActionList.getAction(ActionKey.EDIT_CALENDARS).getMenuItem();
        editMenu.add(item);
        editMenu.addSeparator();
        editMenu.add(this.appActionList.getAction(ActionKey.FIND_TEXT).getMenuItem());
        editMenu.add(this.appActionList.getAction(ActionKey.FIND_NEXT).getMenuItem());
        editMenu.add(this.appActionList.getAction(ActionKey.FIND_PREVIOUS).getMenuItem());
    }

    private void buildView() {
        MnemonicMenu toolBarSubMenu = new MnemonicMenu(StringResources.TOOLBAR);
        ActionSwitchMainToolBar actionToolBar = (ActionSwitchMainToolBar)this.appActionList.getAction(ActionKey.SWITCH_MAIN_TOOLBAR);
        actionToolBar.setToolBarName("MAIN_TOOLBAR_VISIBLE");
        actionToolBar.putValue("Name", StringResources.MAIN);
        toolBarSubMenu.add(actionToolBar.getMenuItem());
        ActionSwitchQVToolbar actionSwitchQVToolbar = (ActionSwitchQVToolbar)this.appActionList.getAction(ActionKey.SWITCH_QV_TOOLBAR);
        toolBarSubMenu.add(actionSwitchQVToolbar.getMenuItemContextItem());
        toolBarSubMenu.add(this.appActionList.getAction(ActionKey.SWITCH_FOLDER_CONTEXT_TOOLBAR).getMenuItem());
        MnemonicMenu quickViewSubMenu = new MnemonicMenu(StringResources.MENU_QUICKVIEW);
        JMenuItem item = actionSwitchQVToolbar.getMenuItem();
        quickViewSubMenu.add(item);
        item = this.appActionList.getAction(ActionKey.SWITCH_ATTACHMENT_WINDOW).getMenuItem();
        quickViewSubMenu.add(item);
        item = this.appActionList.getAction(ActionKey.LONG_FOLDER_TREE).getMenuItem();
        quickViewSubMenu.add(item);
        quickViewSubMenu.addSeparator();
        item = this.appActionList.getAction(ActionKey.QUICKVIEWER_AT_BOTTOM).getMenuItem();
        quickViewSubMenu.add(item);
        item = this.appActionList.getAction(ActionKey.QUICKVIEWER_AT_RIGHT).getMenuItem();
        quickViewSubMenu.add(item);
        this.menuView.insert(toolBarSubMenu, 0);
        item = this.appActionList.getAction(ActionKey.SHOW_HIDE_FOLDER_LIST).getMenuItem();
        this.menuView.insert(item, 1);
        item = this.appActionList.getAction(ActionKey.QUICKVIEWER).getMenuItem();
        this.menuView.insert(item, 2);
        item = this.appActionList.getAction(ActionKey.SHOW_HIDE_NAV_BAR).getMenuItem();
        this.menuView.insert(item, 3);
        this.menuView.insertSeparator(4);
        this.menuView.insert(quickViewSubMenu, 5);
        this.menuView.insertSeparator(6);
        item = this.appActionList.getAction(ActionKey.PREV_UNREAD_ITEM).getMenuItem();
        this.menuView.insert(item, 7);
        item = this.appActionList.getAction(ActionKey.NEXT_UNREAD_ITEM).getMenuItem();
        this.menuView.insert(item, 8);
        this.menuView.insertSeparator(9);
        item = this.appActionList.getAction(ActionKey.GO_TO_TODAY).getMenuItem();
        this.menuView.insert(item, 10);
        this.menuView.insertSeparator(11);
    }

    private void buildActions() {
        ApplicationFrameMenuBar.rebuildItemActionsMenu(this.menuActions, this.appActionList, false, this.currentState == 3);
    }

    private void buildFile() {
        GWApplicationFrameMenuBar.rebuildFileNewWithFolder(this.subMenuNew, this.appActionList);
        JMenuItem item = this.appActionList.getAction(ActionKey.OPEN_MAIL).getMenuItem();
        this.menuFile.add(item);
        item = this.appActionList.getAction(ActionKey.OPEN_ARCHIVE).getMenuItem();
        this.menuFile.add(item);
        item = this.appActionList.getAction(ActionKey.OPEN_BACKUP).getMenuItem();
        this.menuFile.add(item);
        item = this.appActionList.getAction(ActionKey.SAVE_GWITEM).getMenuItem();
        this.menuFile.add(item);
        item = this.appActionList.getAction(ActionKey.PROXY).getMenuItem();
        this.menuFile.add(item);
        item = this.appActionList.getAction(ActionKey.ITEM_PROPERTIES).getMenuItem();
        this.menuFile.add(item);
        this.menuFile.addSeparator();
        item = this.appActionList.getAction(ActionKey.PRINT).getMenuItem();
        this.menuFile.add(item);
        item = this.appActionList.getAction(ActionKey.PRINT_CALENDAR).getMenuItem();
        this.menuFile.add(item);
        this.menuFile.addSeparator();
        item = this.appActionList.getAction(ActionKey.IMPORT_CALENDAR).getMenuItem();
        this.menuFile.add(item);
        this.menuFile.addSeparator();
        MnemonicMenu subMenuMode = new MnemonicMenu(StringResources.MENU_MODE);
        ButtonGroup bg = new ButtonGroup();
        item = this.appActionList.getAction(ActionKey.SWITCH_ONLINE).getMenuItem();
        bg.add(item);
        subMenuMode.add(item);
        item = this.appActionList.getAction(ActionKey.SWITCH_CACHING).getMenuItem();
        bg.add(item);
        subMenuMode.add(item);
        this.menuFile.add(subMenuMode);
        this.menuFile.addSeparator();
        this.miExit = OS.isMacOS() ? this.appActionList.getAction(ActionKey.CLOSE_FRAME).getMenuItem() : GWClient.getGwClientActionList().getAction(ActionKey.EXIT).getMenuItem();
        this.menuFile.add(this.miExit);
    }

    private void buildTools() {
        JMenuItem item = this.appActionList.getAction(ActionKey.VACATION_RULE).getMenuItem();
        this.menuTools.insert(item, 5);
    }

    private static void rebuildFolderActionsMenu(GWMenu actionsMenu, ApplicationFrameActionList actionList, int calendarState) {
        JMenuItem menuItem;
        actionsMenu.removeAll();
        if (calendarState == 4) {
            menuItem = actionList.getAction(ActionKey.NEW_CALENDAR).getMenuItem();
            actionsMenu.add(menuItem);
        }
        menuItem = actionList.getAction(ActionKey.NEW_FOLDER).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.RENAME_FOLDER).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.FOLDER_SHARING).getMenuItem();
        actionsMenu.add(menuItem);
    }

    private static void rebuildMultipleItemsActionsMenu(GWMenu actionsMenu, ApplicationFrameActionList actionList) {
        actionsMenu.removeAll();
        JMenu menuCategories = (JMenu)actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU).getMenuItem();
        menuCategories.addMenuListener(new CategoriesMenuListener(actionList));
        actionsMenu.add(menuCategories);
        JMenuItem menuItem = actionList.getAction(ActionKey.FORWARD_AS_ATTACHMENT).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.RESTORE).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.MOVE_TO_ARCHIVE).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.MARK_READ_LATER).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.MARK_READ).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.MARK_PRIVATE).getMenuItem();
        actionsMenu.add(menuItem);
        menuItem = actionList.getAction(ActionKey.COMPLETE).getMenuItem();
        actionsMenu.add(menuItem);
        actionsMenu.addSeparator();
        actionsMenu.add(actionList.getAction(ActionKey.MOVE_TO_TASKLIST).getMenuItem());
        actionsMenu.add(actionList.getAction(ActionKey.SHOW_IN_CHECKLIST).getMenuItem());
        OrientableMenu menu = new OrientableMenu(StringResources.TASKLIST_ACTIONS);
        menu.add(actionList.getAction(ActionKey.NEW_TASKLIST_ITEM).getMenuItem());
        menu.add(actionList.getAction(ActionKey.NEW_TASKLIST_SUBITEM).getMenuItem());
        menu.add(actionList.getAction(ActionKey.HIDE_ITEMS_NOT_IN_TASKLIST).getMenuItem());
        menu.add(actionList.getAction(ActionKey.HIDE_COMPLETED_ITEMS_IMMEDIATELY).getMenuItem());
        menu.add(actionList.getAction(ActionKey.HIDE_COMPLETED_ITEMS_AFTER_A_DAY).getMenuItem());
        menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_TOP).getMenuItem());
        menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_BOTTOM).getMenuItem());
        menu.add(actionList.getAction(ActionKey.MOVE_TASK_RIGHT).getMenuItem());
        menu.add(actionList.getAction(ActionKey.MOVE_TASK_LEFT).getMenuItem());
        menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_UP).getMenuItem());
        menu.add(actionList.getAction(ActionKey.MOVE_CHECKLIST_ITEMS_DOWN).getMenuItem());
        actionsMenu.add(menu);
    }

    private void rebuildEditMenu(GWMenu editMenu) {
        editMenu.removeAll();
        super.rebuildEdit(editMenu);
        this.buildEdit(editMenu);
    }

    public void setState(int theState) {
        if (this.currentState != theState) {
            this.currentState = theState;
            switch (theState) {
                case 0: {
                    this.setItemState();
                    this.setFolderState(theState);
                    break;
                }
                case 4: {
                    this.setFolderState(theState);
                    break;
                }
                case 5: {
                    this.setFolderState(theState);
                    break;
                }
                case 2: {
                    this.setMultipleItemsState();
                    break;
                }
                case 3: {
                    this.setItemState();
                    this.setContactState();
                    break;
                }
                default: {
                    this.setItemState();
                }
            }
        }
    }

    public int getState() {
        return this.currentState;
    }

    private void setFolderState(int calendarState) {
        GWApplicationFrameMenuBar.rebuildFolderActionsMenu(this.menuActions, this.appActionList, calendarState);
        this.menuEdit.remove(5);
        this.menuEdit.insert(this.appActionList.getAction(ActionKey.DELETE_FOLDER).getMenuItem(), 5);
    }

    private void setItemState() {
        this.buildActions();
        this.menuEdit.remove(5);
        this.menuEdit.insert(this.appActionList.getAction(ActionKey.DELETE_ITEM).getMenuItem(), 5);
    }

    private void setMultipleItemsState() {
        GWApplicationFrameMenuBar.rebuildMultipleItemsActionsMenu(this.menuActions, this.appActionList);
        this.menuEdit.remove(5);
        this.menuEdit.insert(this.appActionList.getAction(ActionKey.DELETE_ITEM).getMenuItem(), 5);
    }

    private void setContactState() {
        this.rebuildEditMenu(this.menuEdit);
        this.menuEdit.remove(5);
        this.menuEdit.insert(this.appActionList.getAction(ActionKey.DELETE_CONTACT).getMenuItem(), 5);
    }
}

