/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.menus.AbstractGWItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListener;
import com.novell.gw.jclient.application.controls.mnemonic.MnemonicMenu;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class GWItemPopupMenu
extends AbstractGWItemPopupMenu {
    public GWItemPopupMenu(ActionList actionList, AbstractFolder folder, IItemList itemList, AbstractItem item, String columnName) {
        super(actionList, folder, itemList, item, columnName);
        this.build();
    }

    private void build() {
        this.addAction(ActionKey.OPEN_ITEM);
        this.addAction(ActionKey.SAVE_GWITEM);
        if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
            if (!this.isFolderInDocuments(this.folder)) {
                this.addAction(ActionKey.PRINT);
            }
            this.buildFindMenuItem();
        }
        this.addSeparator();
        if (this.actionList.getAction(ActionKey.MOVE_TASK_LEFT).isEnabled() || this.actionList.getAction(ActionKey.MOVE_TASK_RIGHT).isEnabled() || this.actionList.getAction(ActionKey.NEW_TASKLIST_SUBITEM).isEnabled()) {
            this.addAction(ActionKey.NEW_TASKLIST_SUBITEM);
            this.addAction(ActionKey.MOVE_TASK_LEFT);
            this.addAction(ActionKey.MOVE_TASK_RIGHT);
            this.addSeparator();
        }
        if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
            this.addAction(ActionKey.REPLY);
            this.addAction(ActionKey.FORWARD);
            this.addAction(ActionKey.FORWARD_AS_ATTACHMENT);
            this.addAction(ActionKey.RESEND);
        }
        if (this.item.isDeleted() || this.item.isIMAPDeleted()) {
            this.addAction(ActionKey.EMPTY_ITEM);
            this.addAction(ActionKey.UNDELETE_ITEM);
        } else {
            this.addAction(ActionKey.DELETE_ITEM);
            if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
                this.addAction(ActionKey.DELETE_AND_EMPTY_ITEM);
            }
        }
        if (this.item.getFolder().isImapSubFolder()) {
            this.addAction(ActionKey.EMPTY_DELETED_ITEMS);
        }
        this.addAction(ActionKey.MOVE_TO_ARCHIVE);
        if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
            this.addAction(ActionKey.RESTORE);
        }
        if (this.item.getNativeItem().canChangeTo(ItemType.APPT) || this.item.getNativeItem().canChangeTo(ItemType.NOTE) || this.item.getNativeItem().canChangeTo(ItemType.TODO) || this.item.getNativeItem().canChangeTo(ItemType.MAIL) || this.item.getNativeItem().canChangeTo(ItemType.PHONE)) {
            this.add(this.buildChangeToMenu());
        }
        if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
            this.buildJunkMailMenu();
            this.addSeparator();
            this.addAction(ActionKey.MARK_READ);
            this.addAction(ActionKey.MARK_READ_LATER);
        }
        if (!this.item.getNativeItem().isNNTPHeader() && !this.item.getNativeItem().isIMAPHeader() && this.actionList.getAction(ActionKey.MARK_PRIVATE) != null) {
            this.addAction(ActionKey.MARK_PRIVATE);
        }
        if (this.actionList.getAction(ActionKey.SHOW_IN_CHECKLIST) != null) {
            this.addAction(ActionKey.SHOW_IN_CHECKLIST);
        }
        JMenu menuCategories = (JMenu)this.actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU).getMenuItem();
        menuCategories.addMenuListener(new CategoriesMenuListener(this.actionList));
        this.add(menuCategories);
        if (this.folder.getType().compareTo(StringResources.CALENDAR_FOLDER) != 0) {
            this.buildNavigationMenu();
            this.buildMarkThread();
            if (this.item.canDoInfo()) {
                this.addSeparator();
                this.addAction(ActionKey.ITEM_PROPERTIES);
            }
        }
    }

    private JMenu buildChangeToMenu() {
        MnemonicMenu subMenuChangeTo = new MnemonicMenu(StringResources.CHANGE_ITEM_TO);
        subMenuChangeTo.setIcon(ImageResources.ACT_CHANGETO);
        if (OS.isMacOS()) {
            subMenuChangeTo.setIcon(null);
        }
        subMenuChangeTo.add(this.actionList.getAction(ActionKey.CHANGE_ITEM_TO_MAIL).getMenuItem());
        subMenuChangeTo.add(this.actionList.getAction(ActionKey.CHANGE_ITEM_TO_APPOINTMENT).getMenuItem());
        subMenuChangeTo.add(this.actionList.getAction(ActionKey.CHANGE_ITEM_TO_TASK).getMenuItem());
        subMenuChangeTo.add(this.actionList.getAction(ActionKey.CHANGE_ITEM_TO_REMINDER).getMenuItem());
        subMenuChangeTo.add(this.actionList.getAction(ActionKey.CHANGE_ITEM_TO_MESSAGE).getMenuItem());
        subMenuChangeTo.addSeparator();
        JMenuItem changeToMenuItem = this.actionList.getAction(ActionKey.CHANGE_ITEM_TO).getMenuItem();
        changeToMenuItem.setText(StringResources.MORE_D);
        changeToMenuItem.setIcon(null);
        subMenuChangeTo.add(changeToMenuItem);
        return subMenuChangeTo;
    }

    private boolean isFolderInDocuments(AbstractFolder folder) {
        do {
            if (!folder.getType().equals("Documents")) continue;
            return true;
        } while ((folder = folder.getParent()) != null && !folder.getType().equals("UserFolder"));
        return false;
    }
}

