/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionItemNotEligible;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListener;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class MultipleItemsPopupMenu
extends AbstractActionsPopupMenu {
    private static Logger logger = Logger.getLogger(MultipleItemsPopupMenu.class);
    private IItemList itemList;

    public MultipleItemsPopupMenu(AbstractFolder theFolder, ActionList theActionList, IItemList itemList) {
        super(theActionList, theFolder);
        this.itemList = itemList;
        this.build();
    }

    private void build() {
        this.buildFindMenuItem();
        this.addSeparator();
        this.addAction(ActionKey.FORWARD_AS_ATTACHMENT);
        if (this.itemList.canDeleteSelectedItems()) {
            this.addAction(ActionKey.DELETE_ITEM);
        }
        if (this.itemList.canDeleteAndEmptySelectedItems()) {
            this.addAction(ActionKey.DELETE_AND_EMPTY_ITEM);
        }
        if (this.itemList.canUndeleteSelectedItems()) {
            this.addAction(ActionKey.UNDELETE_ITEM);
        }
        if (this.itemList.canPurgeSelectedItems()) {
            this.addAction(ActionKey.EMPTY_ITEM);
        }
        this.addAction(ActionKey.MOVE_TO_ARCHIVE);
        this.addAction(ActionKey.RESTORE);
        this.buildJunkMailMenu();
        this.addSeparator();
        if (this.itemList.canMarkSelectedItemsRead()) {
            this.addAction(ActionKey.MARK_READ);
        }
        if (this.itemList.canMarkSelectedItemsReadLater()) {
            this.addAction(ActionKey.MARK_READ_LATER);
        }
        if (this.itemList.canMarkSelectedItemsPrivate()) {
            this.addAction(ActionKey.MARK_PRIVATE);
        }
        if (this.itemList.canShowSelectionInChecklist()) {
            this.addAction(ActionKey.SHOW_IN_CHECKLIST);
        }
        JMenu menuCategories = (JMenu)this.actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU).getMenuItem();
        menuCategories.addMenuListener(new CategoriesMenuListener(this.actionList));
        this.add(menuCategories);
        Component lastComponent = this.getComponent(this.getComponentCount() - 1);
        if (lastComponent instanceof JSeparator) {
            this.remove(lastComponent);
        }
    }

    protected void buildJunkMailMenu() {
        int stringId;
        GWMenu menuJunkMail = new GWMenu(StringResources.JUNK_MAIL);
        boolean isEligible = false;
        if (this.itemList.canHandleJunkMailSelectedItems(1)) {
            menuJunkMail.add(this.actionList.getAction(ActionKey.TRUST_SENDER).getMenuItem());
            isEligible = true;
        }
        if (this.itemList.canHandleJunkMailSelectedItems(3)) {
            menuJunkMail.add(this.actionList.getAction(ActionKey.JUNK_SENDER).getMenuItem());
            isEligible = true;
        }
        if (this.itemList.canHandleJunkMailSelectedItems(2)) {
            menuJunkMail.add(this.actionList.getAction(ActionKey.BLOCK_SENDER).getMenuItem());
            isEligible = true;
        }
        if ((stringId = this.itemList.canHandleJunkMailSelectedItems()) != 0) {
            if (isEligible) {
                menuJunkMail.addSeparator();
            }
            ActionItemNotEligible action = (ActionItemNotEligible)this.actionList.getAction(ActionKey.ITEM_NOT_ELIGIBLE);
            action.setMultipleItems(true);
            JMenuItem menuItem1 = menuJunkMail.add(action.getMenuItem());
            menuItem1.setText(EngineCommandManager.getResourceString(stringId));
        }
        menuJunkMail.addSeparator();
        menuJunkMail.add(this.actionList.getAction(ActionKey.JUNK_MAIL_HANDLING).getMenuItem());
        this.add(menuJunkMail);
    }
}

