/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.popedit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParser {
    private static Logger logger = Logger.getLogger(StringParser.class);

    public static List getTokens(String theSource, String theDelim) {
        int index;
        if (theSource == null) {
            throw new NullPointerException();
        }
        ArrayList<String> result = new ArrayList<String>();
        String source = theSource;
        do {
            if ((index = source.indexOf(theDelim)) != -1) {
                result.add(source.substring(0, index));
                source = source.substring(index + theDelim.length(), source.length());
                continue;
            }
            result.add(source);
        } while (index != -1);
        return result;
    }

    public static List<String> getAllTokens(String source, char[] theDelim) {
        ArrayList<String> result = new ArrayList<String>();
        String token = "";
        int beginIndex = 0;
        if (source.length() == 0) {
            return result;
        }
        for (int i = 1; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (Arrays.binarySearch(theDelim, c) < 0) continue;
            token = source.substring(beginIndex, i);
            beginIndex = i + 1;
            if (token.length() == 0) continue;
            result.add(token.trim());
        }
        if (beginIndex < source.length()) {
            token = source.substring(beginIndex, source.length());
            result.add(token);
        }
        return result;
    }

    public static List getTokens(String theSource, char[] theDelim) {
        List<String> allTokens = StringParser.getAllTokens(theSource, theDelim);
        for (int i = 0; i < allTokens.size(); ++i) {
            String token = allTokens.get(i);
            if (token.trim().length() != 0) continue;
            allTokens.remove(token);
            --i;
        }
        return allTokens;
    }
}

