/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.propertymanager;

import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyManager;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.ColorChooserButtonPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.ComboBoxPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.ContactSearchComboFieldPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.FormattedTextFieldPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.ListPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.SpinnerPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.TextComponentPropertyWrapper;
import com.novell.gw.jclient.application.controls.propertymanager.propertywrappers.ToogleButtonPropertyWrapper;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import java.awt.Component;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyWrapper<T extends JComponent, P> {
    private final T propertyView;
    private final PropertyManager propertyManager;
    public P initialProperty;
    public final List<GWPropertyChangeListener> propertyChangeListeners = new LinkedList<GWPropertyChangeListener>();

    public PropertyWrapper(T propertyView, PropertyManager propertyManager) {
        this.propertyView = propertyView;
        this.propertyManager = propertyManager;
    }

    public abstract P getProperty();

    public P getInitialProperty() {
        return this.initialProperty;
    }

    public void setInitialProperty(P initialProperty) {
        this.initialProperty = initialProperty;
    }

    public T getPropertyView() {
        return this.propertyView;
    }

    protected abstract void attachListeners();

    protected abstract void releaseListeners();

    public void addGWPropertyChangeListener(GWPropertyChangeListener changeListener) {
        if (this.propertyChangeListeners.isEmpty()) {
            this.attachListeners();
        }
        if (!this.propertyChangeListeners.contains(changeListener)) {
            this.propertyChangeListeners.add(changeListener);
        }
    }

    public void removeGWPropertyChangeListener(GWPropertyChangeListener changeListener) {
        this.propertyChangeListeners.remove(changeListener);
        if (this.propertyChangeListeners.isEmpty()) {
            this.releaseListeners();
        }
    }

    public GWPropertyChangeListener[] getGWPropertyChangeListeners() {
        return this.propertyChangeListeners.toArray(new GWPropertyChangeListener[this.propertyChangeListeners.size()]);
    }

    public static PropertyWrapper createPropertyWrapper(JComponent propertyView, PropertyManager propertyManager) throws IllegalArgumentException {
        if (propertyManager == null) {
            throw new IllegalArgumentException("PropertyManager = null");
        }
        if (propertyView instanceof ContactSearchComboField) {
            return new ContactSearchComboFieldPropertyWrapper((ContactSearchComboField)propertyView, propertyManager);
        }
        if (propertyView instanceof JFormattedTextField) {
            return new FormattedTextFieldPropertyWrapper((JFormattedTextField)propertyView, propertyManager);
        }
        if (propertyView instanceof JTextComponent) {
            return new TextComponentPropertyWrapper((JTextComponent)propertyView, propertyManager);
        }
        if (propertyView instanceof JToggleButton) {
            return new ToogleButtonPropertyWrapper((JToggleButton)propertyView, propertyManager);
        }
        if (propertyView instanceof JSpinner) {
            return new SpinnerPropertyWrapper((JSpinner)propertyView, propertyManager);
        }
        if (propertyView instanceof JComboBox) {
            return new ComboBoxPropertyWrapper((JComboBox)propertyView, propertyManager);
        }
        if (propertyView instanceof JList) {
            return new ListPropertyWrapper((JList)propertyView, propertyManager);
        }
        if (propertyView instanceof ColorChooserButton) {
            return new ColorChooserButtonPropertyWrapper((ColorChooserButton)propertyView, propertyManager);
        }
        throw new IllegalArgumentException("Unsupported propertyView: " + propertyView);
    }

    public boolean hasChangedProperty() {
        P property;
        P initialProperty = this.getInitialProperty();
        return !PropertyWrapper.propertyEquals(initialProperty, property = this.getProperty());
    }

    protected void firePropertyChanged() {
        GWPropertyChangeEvent event = new GWPropertyChangeEvent(this, this.propertyManager);
        for (GWPropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
            propertyChangeListener.propertyChanged(event);
        }
    }

    public void readInitialProperty() {
        this.setInitialProperty(this.getProperty());
    }

    public String toString() {
        return ((Component)this.getPropertyView()).toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    public static boolean propertyEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o2, (Object[])o1);
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null || o2.equals(o1);
    }
}

