/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CardPanels<T> {
    private Map<T, CardPanel> map = new HashMap<T, CardPanel>();

    CardPanels() {
    }

    void addComponent(String cardName, T key, JComponent component) {
        CardPanel cardPanel = this.map.get(key);
        if (cardPanel == null) {
            cardPanel = new CardPanel();
            this.map.put(key, cardPanel);
        }
        cardPanel.addCard(cardName, component);
    }

    CardPanel getCardPanel(T key) {
        return this.map.get(key);
    }

    public Collection<CardPanel> getCardPanels() {
        return this.map.values();
    }

    void switchCard(String cardName) {
        for (CardPanel cardPanel : this.map.values()) {
            cardPanel.show(cardName);
        }
    }

    private class CardPanel
    extends OrientablePanel {
        private Map<String, Component> cards;

        public CardPanel() {
            super(new CardLayout());
            this.cards = new HashMap<String, Component>();
        }

        public void show(String name) {
            this.getLayout().show(this, name);
        }

        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public Component addCard(String name, Component comp) {
            this.cards.put(name, comp);
            return super.add(name, comp);
        }

        Component getCard(String name) {
            return this.cards.get(name);
        }
    }
}

