/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

class DragableJComponentListener
implements Transferable,
DragGestureListener,
DragSourceListener {
    private static final Logger logger = Logger.getLogger(DragableJComponentListener.class);
    private JComponent associatedComponent;
    private DataFlavor objectReferenceDataFlavor;
    private DataFlavor[] dragSourceSupportedDataFlavors;

    public DragableJComponentListener(JComponent associatedComponent) {
        this(associatedComponent, associatedComponent);
    }

    public DragableJComponentListener(JComponent associatedComponent, JComponent dragableComponent) {
        this.associatedComponent = associatedComponent;
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(dragableComponent, 3, this);
        try {
            this.objectReferenceDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
            this.dragSourceSupportedDataFlavors = new DataFlavor[1];
            this.dragSourceSupportedDataFlavors[0] = this.objectReferenceDataFlavor;
        }
        catch (ClassNotFoundException e) {
            this.dragSourceSupportedDataFlavors = new DataFlavor[0];
        }
    }

    public JComponent getAssociatedComponent() {
        return this.associatedComponent;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.dragSourceSupportedDataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(this.objectReferenceDataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(this.objectReferenceDataFlavor)) {
            return this.associatedComponent;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        this.objectReferenceDataFlavor.setHumanPresentableName(this.associatedComponent.getClass().getName());
        if ((dge.getTriggerEvent().getModifiers() & 4) == 0) {
            dge.startDrag(Cursor.getPredefinedCursor(13), this, this);
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dragGestureChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }
}

