/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class DropablePanel
extends OrientablePanel
implements DropTargetListener {
    private static final Logger logger = Logger.getLogger(DropablePanel.class);
    private DataFlavor objectReferenceDataFlavor;
    protected Point lastMouseLocation;

    public DropablePanel() {
        this((Color)null);
    }

    public DropablePanel(Color background) {
        this.setBackground(background);
        this.setDropTarget(new DropTarget(this, this));
        try {
            this.objectReferenceDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e) {
            this.objectReferenceDataFlavor = null;
        }
    }

    protected boolean isDragAcceptable(DataFlavor[] supportedDataFlavors, Transferable transferable) {
        for (int i = 0; i < supportedDataFlavors.length; ++i) {
            String className;
            if (this.objectReferenceDataFlavor == null || !this.objectReferenceDataFlavor.equals(supportedDataFlavors[i]) || (className = supportedDataFlavors[i].getHumanPresentableName()) == null) continue;
            try {
                Class<?> classClass = Class.forName(className);
                if (!JComponent.class.isAssignableFrom(classClass)) continue;
                return true;
            }
            catch (ClassNotFoundException exc) {
                // empty catch block
            }
        }
        return false;
    }

    protected void processComponentDragOver(JComponent theComponent, Point theOldMouseLocation, Point theNewMouseLocation) {
    }

    protected void processComponentDrop(JComponent theComponent, Point theLocation) {
    }

    private void processComponentDragExit(JComponent theComponent, Point theLastMouseLocation) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        DataFlavor[] supportedDataFlavors = e.getCurrentDataFlavors();
        if (this.isDragAcceptable(supportedDataFlavors, e.getTransferable())) {
            e.acceptDrag(3);
            this.lastMouseLocation = e.getLocation();
        } else {
            e.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        DataFlavor[] supportedDataFlavors = dtde.getCurrentDataFlavors();
        if (!this.isDragAcceptable(supportedDataFlavors, dtde.getTransferable())) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(3);
        Object transferData = this.getTransferData(dtde.getCurrentDataFlavors(), dtde.getTransferable());
        if (transferData instanceof JComponent) {
            JComponent theComponent = (JComponent)transferData;
            this.processComponentDragOver(theComponent, this.lastMouseLocation, dtde.getLocation());
            this.lastMouseLocation = dtde.getLocation();
        }
    }

    public void dragExit(DropTargetEvent e) {
        logger.debug((Object)("drag exit. component: [" + e.getDropTargetContext().getComponent() + ']'));
        logger.debug((Object)("drag exit. source: [" + e.getSource() + ']'));
        logger.debug((Object)("drag exit. drop target: [" + e.getDropTargetContext().getDropTarget() + ']'));
    }

    public void drop(DropTargetDropEvent dtde) {
        if ((dtde.getSourceActions() & 1) == 0) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(3);
        boolean outcome = false;
        Object transferData = this.getTransferData(dtde.getCurrentDataFlavors(), dtde.getTransferable());
        if (transferData instanceof JComponent) {
            this.processComponentDrop((JComponent)transferData, dtde.getLocation());
            outcome = true;
        }
        dtde.getDropTargetContext().dropComplete(outcome);
    }

    protected Object getTransferData(DataFlavor[] supportedDataFlavors, Transferable theTransferable) {
        Object transferData = null;
        for (int i = 0; i < supportedDataFlavors.length; ++i) {
            if (this.objectReferenceDataFlavor == null || !this.objectReferenceDataFlavor.equals(supportedDataFlavors[i])) continue;
            try {
                transferData = theTransferable.getTransferData(supportedDataFlavors[i]);
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            break;
        }
        return transferData;
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

