/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.appframework.AppAction;
import com.appframework.CustomizableToolBarComponent;
import com.appframework.CustomizableToolBarSeparator;
import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.AbstractPopupPane;
import com.appframework.components.customizedbutton.ActionWithSepName;
import com.appframework.components.customizedbutton.ToolBarSeparator;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.components.multyactionlabel.CombinedCheckedIcon;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.toolbars.ext.StoredComponent;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperButton
extends JButton {
    private static Logger logger = Logger.getLogger(AbstractPopupPane.class);
    public static final int STATE_UP = 1;
    public static final int STATE_NORMAL = 4;
    public static final int STATE_DOWN = 8;
    protected static final int BUTTON_LEFT_CLICKED = 12;
    protected static final int BUTTON_LEFT_PRESSED = 16;
    protected static final int BUTTON_RIGHT_PRESSED = 20;
    protected JPopupMenu popup = null;
    protected boolean isUnderMouse;
    protected boolean isPopupShowed;
    protected boolean isEnabled = true;
    protected DefaultActionPropertyListener propertyListener = new DefaultActionPropertyListener();
    private volatile ArrayList<StoredComponent> componentsList = new ArrayList();
    private static final Dimension SUPER_BUTTON_SIZE = new Dimension(14, 28);
    private static final int MENU_ITEM_HEIGHT = 22;

    public SuperButton() {
        this.popup = new GWPopupMenu();
        this.setOpaque(false);
        this.build();
    }

    protected void build() {
        this.setIcon(ImageResources.ARROW_MORE);
        this.setBorder(null);
        this.setFocusable(false);
        this.getModel().setArmed(false);
        this.setPreferredSize(SUPER_BUTTON_SIZE);
        this.setMinimumSize(SUPER_BUTTON_SIZE);
        this.setMaximumSize(SUPER_BUTTON_SIZE);
        this.addMouseListener(new RightButtonMouseListener());
    }

    protected void mouseEntered() {
        this.isUnderMouse = true;
        this.changeState(1);
    }

    protected void mouseExited() {
        this.isUnderMouse = false;
        this.changeState(4);
    }

    protected void changeState(int state) {
        if (!this.isPopupShowed && this.isEnabled) {
            if (state == 1 || state == 8) {
                this.updateBorder(state);
            } else if (state == 4) {
                this.updateBorder(state);
            }
        }
    }

    protected void restoreState() {
        if (this.isUnderMouse) {
            this.changeState(1);
        } else {
            this.changeState(4);
        }
    }

    public void addStored(StoredComponent theComponent) {
        if (!this.containsStored(theComponent.getComponent())) {
            this.componentsList.add(0, theComponent);
        }
    }

    private ArrayList<StoredComponent> sortStoredByIndex() {
        StoredComponent[] sortArray = new StoredComponent[this.componentsList.size()];
        this.componentsList.toArray(sortArray);
        ArrayList<StoredComponent> result = new ArrayList<StoredComponent>();
        for (int j = 0; j < sortArray.length; ++j) {
            int maxIndex = -1;
            int max = -1;
            for (int i = 0; i < sortArray.length; ++i) {
                StoredComponent storedComponent = sortArray[i];
                if (storedComponent == null || storedComponent.getIndex() <= max) continue;
                max = storedComponent.getIndex();
                maxIndex = i;
            }
            if (maxIndex < 0) continue;
            result.add(0, sortArray[maxIndex]);
            sortArray[maxIndex] = null;
        }
        return result;
    }

    protected void processEvent(int buttonID) {
        if (this.isEnabled && buttonID == 20) {
            logger.debug((Object)"process BUTTON_RIGHT_PRESSED");
            if (!this.isPopupShowed) {
                this.setBorder(GWBorder.LOWERED_BORDER);
                this.chooseAction();
            }
        }
    }

    private void chooseAction() {
        ArrayList<StoredComponent> sortedList = this.sortStoredByIndex();
        if (!sortedList.isEmpty()) {
            try {
                ToolBarUtils.doDisposeButtons(this.popup);
                this.popup.removeAll();
                this.popup.setBorderPainted(true);
                this.popup.setBorder(GWBorder.RAISED_BORDER);
                this.popup.addPopupMenuListener(new ActionsPopupListener());
                int nSize = sortedList.size();
                for (int i = 0; i < nSize; ++i) {
                    JMenuItem mi;
                    Action action;
                    AbstractButton btnNext;
                    StoredComponent nextStored = sortedList.get(i);
                    Component next = nextStored.getComponent();
                    if (next instanceof CustomizableToolBarSeparator) {
                        this.popup.addSeparator();
                        continue;
                    }
                    if (next instanceof ToolBarSeparator || next instanceof JSeparator || next instanceof JToolBar.Separator) {
                        this.popup.addSeparator();
                        continue;
                    }
                    if (next instanceof AbstractPopupPane) {
                        AbstractPopupPane popPane = (AbstractPopupPane)next;
                        List actions = popPane.getActionsList();
                        if (actions.isEmpty()) continue;
                        GWMenu menu = new GWMenu(popPane.getDisplayText());
                        menu.setComponentOrientation(UIUtils.getComponentOrientation());
                        int nActSize = actions.size();
                        for (int j = 0; j < nActSize; ++j) {
                            ActionWithSepName actionWithSepName = (ActionWithSepName)actions.get(j);
                            Action action2 = actionWithSepName.getAction();
                            if (action2 == null) {
                                menu.addSeparator();
                                continue;
                            }
                            JMenuItem mi2 = OS.createMenuItemForAction(action2);
                            mi2.setAccelerator(null);
                            this.defineSize(mi2);
                            menu.add(mi2);
                        }
                        this.defineSize(menu);
                        this.popup.add(menu);
                        continue;
                    }
                    if (next instanceof JButton) {
                        btnNext = (JButton)next;
                        action = btnNext.getAction();
                        if (action == null) {
                            throw new IllegalArgumentException("ExToolBar can not contain such component");
                        }
                        mi = OS.createMenuItemForAction(action);
                        mi.setAccelerator(null);
                        this.defineSize(mi);
                        this.popup.add(mi);
                        continue;
                    }
                    if (next instanceof ToolBarToggleButton) {
                        btnNext = (ToolBarToggleButton)next;
                        action = btnNext.getAction();
                        if (action == null) {
                            throw new IllegalArgumentException("ExToolBar can not contain such component");
                        }
                        if (action instanceof AppAction) {
                            mi = OS.createMenuItem((AppAction)action);
                        } else {
                            mi = OS.createMenuItemForAction(action);
                            mi.setIcon(new CombinedCheckedIcon());
                        }
                        ButtonGroup group = ((ToolBarToggleButton)btnNext).getGroup();
                        if (group != null) {
                            group.add(mi);
                        }
                        mi.setAccelerator(null);
                        this.defineSize(mi);
                        this.popup.add(mi);
                        continue;
                    }
                    throw new IllegalArgumentException("ExToolBar can not contain such component : " + next.getClass().getName());
                }
                this.popup.show(this, 0, this.getHeight());
                this.isPopupShowed = true;
            }
            catch (Exception e) {
                logger.debug((Object)e, (Throwable)e);
                logger.error((Object)e);
            }
        }
    }

    private void defineSize(JMenuItem item) {
        Dimension defSize = new Dimension(item.getPreferredSize().width, Math.max(item.getPreferredSize().height, 22));
        item.setMinimumSize(defSize);
        item.setPreferredSize(defSize);
    }

    protected void updateBorder(int state) {
        switch (state) {
            case 1: {
                this.setBorder(GWBorder.RAISED_BORDER);
                break;
            }
            case 8: {
                this.setBorder(GWBorder.LOWERED_BORDER);
                break;
            }
            case 4: {
                this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    public StoredComponent getLastStored() {
        if (!this.componentsList.isEmpty()) {
            return this.componentsList.get(0);
        }
        return null;
    }

    public void removeLastStored() {
        if (!this.componentsList.isEmpty()) {
            this.componentsList.remove(0);
        }
    }

    public int getStoredCount() {
        return this.componentsList.size();
    }

    public boolean containsStored(Component theComponent) {
        int nSize = this.componentsList.size();
        for (int i = 0; i < nSize; ++i) {
            StoredComponent storedComponent = this.componentsList.get(i);
            if (!theComponent.equals(storedComponent.getComponent())) continue;
            return true;
        }
        return false;
    }

    public CustomizableToolBarComponent getButton(ActionKey actionKey) {
        int nSize = this.componentsList.size();
        for (int i = 0; i < nSize; ++i) {
            ActionKey defaultActionName;
            StoredComponent storedComponent = this.componentsList.get(i);
            if (!(storedComponent.getComponent() instanceof CustomizableToolBarComponent) || (defaultActionName = ((CustomizableToolBarComponent)((Object)storedComponent.getComponent())).getDefaultActionName()) != actionKey) continue;
            return (CustomizableToolBarComponent)((Object)storedComponent.getComponent());
        }
        return null;
    }

    public boolean containsAction(ActionKey actionKey) {
        int nSize = this.componentsList.size();
        for (int i = 0; i < nSize; ++i) {
            ActionKey defaultActionName;
            StoredComponent storedComponent = this.componentsList.get(i);
            if (!(storedComponent.getComponent() instanceof CustomizableToolBarComponent) || (defaultActionName = ((CustomizableToolBarComponent)((Object)storedComponent.getComponent())).getDefaultActionName()) != actionKey) continue;
            return true;
        }
        return false;
    }

    public boolean removeButton(ActionKey actionName) {
        int nSize = this.componentsList.size();
        for (int i = 0; i < nSize; ++i) {
            ActionKey defaultActionName;
            StoredComponent storedComponent = this.componentsList.get(i);
            if (!(storedComponent.getComponent() instanceof CustomizableToolBarComponent) || !(defaultActionName = ((CustomizableToolBarComponent)((Object)storedComponent.getComponent())).getDefaultActionName()).equals((Object)actionName)) continue;
            return this.componentsList.remove(storedComponent);
        }
        return false;
    }

    protected class ActionsPopupListener
    implements PopupMenuListener {
        protected ActionsPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SuperButton.this.isPopupShowed = false;
            SuperButton.this.isUnderMouse = false;
            SuperButton.this.restoreState();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    protected class RightButtonMouseListener
    implements MouseListener {
        protected RightButtonMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            SuperButton.this.mouseEntered();
        }

        public void mouseExited(MouseEvent e) {
            SuperButton.this.mouseExited();
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                SuperButton.this.getModel().setArmed(false);
                SuperButton.this.processEvent(20);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                SuperButton.this.changeState(1);
            }
        }
    }

    protected class DefaultActionPropertyListener
    implements PropertyChangeListener {
        protected DefaultActionPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                SuperButton.this.setEnabled(true);
                SuperButton.this.isPopupShowed = false;
                SuperButton.this.restoreState();
                SuperButton.this.isEnabled = true;
            }
        }
    }
}

