/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarComponentTransferData;
import com.novell.gw.jclient.application.controls.toolbars.ext.TransferableToolBarComponent;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ToolBarComponentDragListener
implements DragGestureListener,
DragSourceListener {
    private static Logger logger = Logger.getLogger(ToolBarComponentDragListener.class);
    private JComponent dragSource;
    private int sourceDndActions;
    private Transferable transferable;
    private List<DragGestureRecognizer> dragGestureRecognizerList = new ArrayList<DragGestureRecognizer>();
    public static final Cursor THROW_OUT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(ImageResources.CURSOR_MOVE_ITEM_TO_TRASH.getImage(), new Point(0, 0), "THROW_OUT_CURSOR");
    public static final String STR_THROW_OUT_CURSOR_NAME = "THROW_OUT_CURSOR";

    public ToolBarComponentDragListener(JComponent dragSource, int sourceDndActions, Transferable transferable) {
        this.dragSource = dragSource;
        this.sourceDndActions = sourceDndActions;
        this.transferable = transferable;
        this.init();
    }

    private void init() {
        this.createDefaultDragGestureRecognizer(this.dragSource);
    }

    private void createDefaultDragGestureRecognizer(Component component) {
        DragGestureRecognizer recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, this.sourceDndActions, this);
        this.dragGestureRecognizerList.add(recognizer);
        if (component instanceof JPanel) {
            Component[] components;
            for (Component child : components = ((JPanel)component).getComponents()) {
                this.createDefaultDragGestureRecognizer(child);
            }
        }
    }

    private static Object getTransferData(Transferable transferable) {
        Object transferData = null;
        if (transferable.isDataFlavorSupported(TransferableToolBarComponent.componentFlavor)) {
            try {
                transferData = transferable.getTransferData(TransferableToolBarComponent.componentFlavor);
            }
            catch (Exception ex) {
                logger.warn((Object)("Exception: " + ex));
            }
        }
        return transferData;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        if ((dge.getDragAction() & this.sourceDndActions) != 0) {
            dge.startDrag(null, this.transferable, this);
            logger.debug((Object)"drug started...........");
        }
    }

    public void dragOver(DragSourceDragEvent event) {
        if ((event.getDropAction() & 2) != 0) {
            event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else if ((event.getDropAction() & 1) != 0) {
            event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        }
    }

    public void dragEnter(DragSourceDragEvent event) {
        if ((event.getDropAction() & 2) != 0) {
            event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else if ((event.getDropAction() & 1) != 0) {
            event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        }
    }

    public void dragExit(DragSourceEvent event) {
        if ((event.getDragSourceContext().getSourceActions() & 2) != 0) {
            event.getDragSourceContext().setCursor(THROW_OUT_CURSOR);
        } else if ((event.getDragSourceContext().getSourceActions() & 1) != 0) {
            event.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.processDropEvent(dsde);
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        logger.warn((Object)"drop action changed");
    }

    private void processDropEvent(DragSourceDropEvent event) {
        if (!event.getDropSuccess() && (this.sourceDndActions & 2) != 0) {
            logger.debug((Object)"removind component from drag source");
            logger.debug((Object)("drop succeeded: " + event.getDropSuccess()));
            Object transferData = ToolBarComponentDragListener.getTransferData(this.transferable);
            ToolBarComponentTransferData componentTransferData = (ToolBarComponentTransferData)transferData;
            Container container = componentTransferData.getComponent().getParent();
            ApplicationFrameToolBar toolbar = (ApplicationFrameToolBar)container;
            logger.debug((Object)("drag source: " + toolbar.getName()));
            toolbar.removeToolBarComponent(componentTransferData.getComponent());
            toolbar.validate();
            ((JComponent)toolbar.getParent()).updateUI();
        }
        this.dragSource.updateUI();
    }

    public void clear() {
        for (DragGestureRecognizer recognizer : this.dragGestureRecognizerList) {
            recognizer.setComponent(null);
        }
        this.dragGestureRecognizerList.clear();
    }
}

