/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.ApplicationFrame;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.toolbars.ext.ChevronPopupMenu;
import com.novell.gw.jclient.application.controls.toolbars.navigation.CustomFolderAction;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPopupRadioMenuItem;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class NavBarChevronPopupMenu
extends ChevronPopupMenu {
    public NavBarChevronPopupMenu(NavBarPanel masterPanel) {
        this.addPopupMenuListener(new FixItemsPopupMenuListener());
    }

    protected void rebuildMenuItems(Set theComponents) {
        this.removeAll();
        if (theComponents == null || theComponents.isEmpty()) {
            return;
        }
        ButtonGroup bg = new ButtonGroup();
        for (Object component : theComponents) {
            NavBarPopupRadioMenuItem menuItem;
            if (!(component instanceof NavBarButton) || (menuItem = NavBarChevronPopupMenu.getMenuItemForNavBarButton((NavBarButton)component)) == null) continue;
            this.add(menuItem);
            bg.add(menuItem);
        }
    }

    protected static NavBarPopupRadioMenuItem getMenuItemForNavBarButton(NavBarButton btn) {
        Action action;
        if (btn != null && (action = btn.getAction()) instanceof CustomFolderAction) {
            CustomFolderAction a = (CustomFolderAction)action;
            NavBarPopupRadioMenuItem menuItem = new NavBarPopupRadioMenuItem(new CustomFolderAction(a.getFolder()));
            menuItem.setSelected(btn.isSelected());
            return menuItem;
        }
        return null;
    }

    protected void rebuildMenuItems() {
        super.rebuildMenuItems();
        ApplicationFrame appFrame = GWClient.getActiveFrame();
        if (appFrame instanceof GWMainAppFrame) {
            GWMainAppFrame frame = (GWMainAppFrame)appFrame;
            AbstractFolder selectedFolder = frame.getFolder();
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof NavBarPopupRadioMenuItem)) continue;
                NavBarPopupRadioMenuItem item = (NavBarPopupRadioMenuItem)c;
                CustomFolderAction action = (CustomFolderAction)item.getAction();
                AbstractFolder currFolder = action.getFolder();
                boolean selected = selectedFolder != null && currFolder != null && selectedFolder.getID().equals(currFolder.getID());
                item.setSelected(selected);
                action.setSelected(selected);
            }
        }
    }

    private class FixItemsPopupMenuListener
    implements PopupMenuListener {
        private FixItemsPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            NavBarChevronPopupMenu.this.rebuildMenuItems();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

