/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavBarModel {
    private static Logger logger = Logger.getLogger(NavBarModel.class);
    private static final Integer INVISIBLE_FOLDER_SEQ_NUMBER = -1;
    private List<AbstractFolder> folderList;
    private NavBarPanel panel;

    public NavBarModel(NavBarPanel panel) {
        this.panel = panel;
    }

    public List<AbstractFolder> getFolderList() {
        return this.folderList;
    }

    public void setFolderList(List<AbstractFolder> folderList) {
        this.folderList = folderList;
        SortedMap sortedMap = this.getVisibleFolderMap();
        if (sortedMap.size() == 0) {
            sortedMap = this.initDefaultVisibleFolders(sortedMap);
        }
    }

    public List<AbstractFolder> getVisibleFolderList() {
        ArrayList<AbstractFolder> visibleFolders = new ArrayList<AbstractFolder>();
        SortedMap sortedMap = this.getVisibleFolderMap();
        for (Integer id : sortedMap.keySet()) {
            AbstractFolder f = (AbstractFolder)sortedMap.get(id);
            if (f == null) continue;
            visibleFolders.add(f);
        }
        return visibleFolders;
    }

    private SortedMap getVisibleFolderMap() {
        int n;
        TreeMap<Integer, AbstractFolder> sortedMap = new TreeMap<Integer, AbstractFolder>();
        int n2 = n = this.folderList == null ? -1 : this.folderList.size();
        for (int i = 0; i < n; ++i) {
            AbstractFolder folder = this.folderList.get(i);
            Integer id = folder.getNativeFolder().getNavBarSequenceNumber();
            if (id == null || id <= -1) continue;
            sortedMap.put(id, folder);
        }
        return sortedMap;
    }

    private SortedMap initDefaultVisibleFolders(SortedMap sortedMap) {
        GWCommandManager manager = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.panel.getController()));
        try {
            AbstractFolder homeFolder = manager.getRootFolder();
            this.setFolderVisible(homeFolder, true);
            AbstractFolder mailboxFolder = manager.getMailboxFolder();
            this.setFolderVisible(mailboxFolder, true);
            CalendarFolder calendarFolder = manager.getCalendarFolder();
            this.setFolderVisible(calendarFolder, true);
            SentItemsFolder sentItemsFolder = manager.getSentItemsFolder();
            this.setFolderVisible(sentItemsFolder, true);
            ContactsFolder contactsFolder = EngineCommandManager.getContactsFolder();
            this.setFolderVisible(contactsFolder, true);
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return sortedMap;
    }

    public List<AbstractFolder> getInvisibleFolderList() {
        int n;
        ArrayList<AbstractFolder> invisibleFolders = new ArrayList<AbstractFolder>();
        int n2 = n = this.folderList == null ? -1 : this.folderList.size();
        for (int i = 0; i < n; ++i) {
            Integer id;
            AbstractFolder folder = this.folderList.get(i);
            if (folder == null || (id = folder.getNativeFolder().getNavBarSequenceNumber()) != null && !id.equals(INVISIBLE_FOLDER_SEQ_NUMBER)) continue;
            invisibleFolders.add(folder);
        }
        return invisibleFolders;
    }

    public boolean isFolderVisible(AbstractFolder folder) {
        if (folder != null) {
            Integer id = folder.getNativeFolder().getNavBarSequenceNumber();
            if (!this.folderList.contains(folder)) {
                this.folderList.add(folder);
            }
            return id != null && id > -1;
        }
        return false;
    }

    public void setFolderVisible(AbstractFolder folder, boolean visible) {
        logger.debug((Object)("folder [" + folder + "] > " + visible));
        if (folder != null) {
            if (!visible) {
                folder.getNativeFolder().setNavBarSequenceNumber(INVISIBLE_FOLDER_SEQ_NUMBER);
            } else if (this.folderList.contains(folder)) {
                List<AbstractFolder> visibles = this.getVisibleFolderList();
                if (!visibles.isEmpty()) {
                    AbstractFolder lastVisible = visibles.get(visibles.size() - 1);
                    folder.getNativeFolder().setNavBarSequenceNumber(lastVisible.getNativeFolder().getNavBarSequenceNumber() + 1);
                } else {
                    folder.getNativeFolder().setNavBarSequenceNumber(1);
                }
            } else {
                this.folderList.add(folder);
                folder.getNativeFolder().setNavBarSequenceNumber(this.folderList.size());
            }
        }
    }

    public int getVisibleFolderCount() {
        int n;
        int res = 0;
        int n2 = n = this.folderList == null ? -1 : this.folderList.size();
        for (int i = 0; i < n; ++i) {
            Integer id;
            AbstractFolder folder = this.folderList.get(i);
            if (folder == null || (id = folder.getNativeFolder().getNavBarSequenceNumber()) == null || id <= -1) continue;
            ++res;
        }
        return res;
    }

    public int getInvisibleFolderCount() {
        return this.folderList == null ? 0 : this.folderList.size() - this.getVisibleFolderCount();
    }

    public List getInvisibleFolderIDs() {
        List<AbstractFolder> folders = this.getInvisibleFolderList();
        return NavBarModel.retrieveFolderIDs(folders);
    }

    public List getVisibleFolderIDs() {
        List<AbstractFolder> folders = this.getVisibleFolderList();
        return NavBarModel.retrieveFolderIDs(folders);
    }

    private static List retrieveFolderIDs(List folders) {
        ArrayList<String> res = new ArrayList<String>(folders.size());
        int n = folders.size();
        for (int i = 0; i < n; ++i) {
            AbstractFolder folder = (AbstractFolder)folders.get(i);
            String folderID = folder.getID();
            if (folderID == null) continue;
            res.add(folderID);
        }
        return res;
    }

    private AbstractFolder getFolder(String folderId) {
        AbstractFolder folder = null;
        if (folderId != null) {
            for (AbstractFolder currentFolder : this.folderList) {
                if (!folderId.equals(currentFolder.getID())) continue;
                folder = currentFolder;
                break;
            }
        }
        if (folder == null) {
            logger.warn((Object)("folder for id [" + folderId + "] not found"));
        }
        return folder;
    }

    public boolean moveFolder(String folderId, int toPosition) {
        boolean removeResult;
        if (folderId == null) {
            throw new IllegalArgumentException("folderId is null");
        }
        if (toPosition < 0) {
            throw new IllegalArgumentException("toPosition (" + toPosition + ") is less than 0");
        }
        logger.debug((Object)("folderId: " + folderId + ", toPosition: " + toPosition));
        AbstractFolder movingFolder = this.getFolder(folderId);
        if (movingFolder == null) {
            logger.debug((Object)"movingFolder is null");
            return false;
        }
        List<AbstractFolder> visibleFolders = this.getVisibleFolderList();
        int fromPosition = visibleFolders.indexOf(movingFolder);
        if (!visibleFolders.contains(movingFolder)) {
            logger.debug((Object)"movingFolder is not in visible list");
            return false;
        }
        if (visibleFolders.indexOf(movingFolder) < toPosition) {
            --toPosition;
        }
        if (!(removeResult = visibleFolders.remove(movingFolder))) {
            logger.debug((Object)"movingFolder is not removed from visible list");
            return false;
        }
        visibleFolders.add(toPosition, movingFolder);
        for (int i = Math.min(toPosition, fromPosition); i <= Math.max(toPosition, fromPosition); ++i) {
            AbstractFolder folder = visibleFolders.get(i);
            folder.getNativeFolder().setNavBarSequenceNumber(i + 1);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NavBarModel)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NavBarModel model = (NavBarModel)obj;
        return this.folderList == null ? model.folderList == null : ((Object)this.folderList).equals(model.folderList);
    }

    public int hashCode() {
        int result = 0;
        if (this.folderList != null) {
            result += ((Object)this.folderList).hashCode();
        }
        return result;
    }

    public void updateFolderList(List<AbstractFolder> newList) {
        List<AbstractFolder> oldList = this.getVisibleFolderList();
        if (newList == null || ((Object)oldList).equals(newList)) {
            return;
        }
        int nonMatchingIndex = -1;
        int nSize = oldList.size();
        for (int i = 0; i < nSize; ++i) {
            if (!(nonMatchingIndex != -1 || i != newList.size() && oldList.get(i).equals(newList.get(i)))) {
                nonMatchingIndex = i;
                logger.debug((Object)("nonMatchingIndex: " + nonMatchingIndex));
            }
            if (nonMatchingIndex <= -1) continue;
            this.setFolderVisible(oldList.get(i), false);
        }
        if (nonMatchingIndex > -1 || oldList.size() < newList.size()) {
            int startIndex = nonMatchingIndex > -1 ? nonMatchingIndex : oldList.size();
            logger.debug((Object)("startIndex: " + startIndex));
            nSize = newList.size();
            for (int i = startIndex; i < nSize; ++i) {
                this.setFolderVisible(newList.get(i), true);
            }
        }
    }
}

