/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class AutoSaveDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(AutoSaveDialog.class);
    private OrientableRadioButton rbRetrieve;
    private OrientableRadioButton rbDelete;
    private IDataStore dataStore;
    private GWMainAppFrameActionList actionList;

    public AutoSaveDialog(GWMainAppFrameActionList actionList) {
        this.actionList = actionList;
        this.dataStore = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.GROUPWISE_AUTO_SAVE);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 1;
        contentPane.add((Component)new OrientableLabel(StringResources.formatString(StringResources.GROUPWISE_HAS_FOUND_SAVED_MESSAGES, String.valueOf(this.dataStore.getAutoSavedMessagesCount()))), c);
        c.gridy = 1;
        contentPane.add((Component)new OrientableLabel(StringResources.WHAT_WOULD_YOU_LIKE_TO_DO), c);
        c.insets = new Insets(5, 20, 0, 0);
        c.gridy = 2;
        this.rbRetrieve = new OrientableRadioButton(StringResources.RETRIEVE_ALL_SAVED_MESSAGES);
        contentPane.add((Component)this.rbRetrieve, c);
        c.gridy = 3;
        this.rbDelete = new OrientableRadioButton(StringResources.DELETE_ALL_SAVED_MESSAGES);
        contentPane.add((Component)this.rbDelete, c);
        c.gridy = 4;
        OrientableRadioButton rbAskAgain = new OrientableRadioButton(StringResources.ASK_AGAIN_NEXT_TIME);
        contentPane.add((Component)rbAskAgain, c);
        ButtonGroup rbGroup = new ButtonGroup();
        rbGroup.add(this.rbRetrieve);
        rbGroup.add(this.rbDelete);
        rbGroup.add(rbAskAgain);
        this.rbRetrieve.setSelected(true);
        c.insets = new Insets(15, 0, 5, 0);
        c.gridy = 5;
        c.anchor = 10;
        c.fill = 0;
        contentPane.add((Component)this.btnOK, c);
        this.btnOK.addActionListener(new OKListener());
    }

    private class OKListener
    implements ActionListener {
        private OKListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AutoSaveDialog.this.rbDelete.isSelected()) {
                AutoSaveDialog.this.dataStore.clearAllAutoSavedMessages();
            } else if (AutoSaveDialog.this.rbRetrieve.isSelected()) {
                IItem[] retrievedItems;
                for (IItem item : retrievedItems = AutoSaveDialog.this.dataStore.restoreAllAutoSavedMessages()) {
                    try {
                        AbstractItem abstractItem = GWItemFactory.gwObjectToItem((IMessage)item);
                        MessageUtils.doOpenItem(null, abstractItem, true, ControlsUtils.getUserGuid(AutoSaveDialog.this.actionList));
                    }
                    catch (GWCommandException e1) {
                        logger.error((Object)"Could not open saved item: not a Message!");
                    }
                }
            }
        }
    }
}

