/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.novell.gw.account.AccountFolderList;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.application.dialogs.NewsgroupMessageMode;
import com.novell.gw.jclient.application.dialogs.SelectNewsgroupDialog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectNewsgroupDialogModel {
    private SelectNewsgroupDialog dialog;
    private List<String> followupList;
    private List<String> newsgroupList;
    private List<String> allList;
    private List<String> availableList;
    private NewsgroupMessageMode mode = null;
    private NntpAccount account = null;
    private boolean showSubscribedOnly = false;
    private AccountFolderList accountFolderList;

    SelectNewsgroupDialogModel(SelectNewsgroupDialog dialog, NewsgroupMessageMode mode, boolean showSubscribedOnly, NntpAccount account, List<String> followupList, List<String> newsgroupList) {
        if (dialog == null) {
            throw new IllegalArgumentException("dialog is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.mode = mode;
        this.dialog = dialog;
        this.account = account;
        this.showSubscribedOnly = showSubscribedOnly;
        this.followupList = new ArrayList<String>();
        if (followupList != null && !followupList.isEmpty()) {
            this.followupList.addAll(followupList);
        }
        this.newsgroupList = new ArrayList<String>();
        if (newsgroupList != null && !newsgroupList.isEmpty()) {
            this.newsgroupList.addAll(newsgroupList);
        }
        this.initAllList();
        this.initAvailableList();
    }

    private void initAllList() {
        this.accountFolderList = this.showSubscribedOnly ? this.account.getSubscribedNNTPFolders() : this.account.getAllNNTPFolders();
        int foldersCount = this.accountFolderList.getNumFolders();
        this.allList = new ArrayList<String>(foldersCount);
        for (int i = 0; i < foldersCount; ++i) {
            this.allList.add(i, this.accountFolderList.getFolderName(i));
        }
    }

    private void initAvailableList() {
        if (this.allList == null) {
            throw new IllegalStateException("allList not initialized");
        }
        this.availableList = new ArrayList<String>(this.allList.size());
        this.availableList.addAll(this.allList);
        this.availableList.removeAll(this.followupList);
        this.availableList.removeAll(this.newsgroupList);
    }

    boolean isFolderSubscribed(String folderName) {
        return this.accountFolderList.isSubscribed(this.allList.indexOf(folderName));
    }

    List<String> getFollowupList() {
        return this.followupList;
    }

    List<String> getNewsgroupList() {
        return this.newsgroupList;
    }

    List<String> getAllList() {
        return this.allList;
    }

    List<String> getAvailableList() {
        return this.availableList;
    }

    List<String> getSelectedList() {
        switch (this.mode) {
            case NEWSGROUP: {
                return this.newsgroupList;
            }
            case FOLLOWUP: {
                return this.followupList;
            }
        }
        throw new IllegalStateException("unsupported mode: " + (Object)((Object)this.mode));
    }

    void setShowSubscribedOnly(boolean showSubscribedOnly) {
        if (this.showSubscribedOnly == showSubscribedOnly) {
            return;
        }
        this.showSubscribedOnly = showSubscribedOnly;
        this.initAllList();
        this.initAvailableList();
        this.dialog.handleAvailableListChanged();
    }

    void setMode(NewsgroupMessageMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (this.mode.equals((Object)mode)) {
            return;
        }
        this.mode = mode;
        this.dialog.handleSelectedListChanged();
    }

    void addAvailableFolders(int[] folderIndices) {
        if (folderIndices.length == 0) {
            return;
        }
        List<String> selectedFolders = this.getSelectedList();
        for (int index = folderIndices.length - 1; index >= 0; --index) {
            selectedFolders.add(this.availableList.remove(folderIndices[index]));
        }
        this.dialog.handleAvailableListChanged();
        this.dialog.handleSelectedListChanged();
    }

    void removeSelectedFolders(int[] folderIndices) {
        if (folderIndices.length == 0) {
            return;
        }
        List<String> selectedFolders = this.getSelectedList();
        for (int index = folderIndices.length - 1; index >= 0; --index) {
            selectedFolders.remove(index);
        }
        this.initAvailableList();
        this.dialog.handleAvailableListChanged();
        this.dialog.handleSelectedListChanged();
    }
}

