/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.backup;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BackupMailBoxDialog
extends GWDialog {
    private JTextField tfFilePath = new GWTextField();
    private JCheckBox cbPrompt = new JMnemonicCheckBox(StringResources.DO_NOT_PROMPT_BEFORE_PERFORMING_BACKUP);

    public BackupMailBoxDialog(JFrame theFrame, String theDefaultPath) {
        super(theFrame);
        this.setModal(true);
        this.setTitle(StringResources.GROUPWISE_MAILBOX_BACKUP);
        this.buildUI();
        this.tfFilePath.setText(theDefaultPath);
        this.tfFilePath.getDocument().addDocumentListener(new CurrentDocumentListener());
        this.checkFilePath();
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.insets.bottom = 5;
        pnlContent.add((Component)new JMnemonicLabel(StringResources.DIRECTORY, this.tfFilePath), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        pnlContent.add((Component)this.tfFilePath, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.anchor = 22;
        constraints.fill = 0;
        constraints.insets.left = 0;
        ToolBarButton btnSelectFolder = new ToolBarButton(new SelectFolderAction());
        btnSelectFolder.setPreferredSize(new Dimension(btnSelectFolder.getPreferredSize().width, this.tfFilePath.getPreferredSize().height));
        GWToolBar toolBar = new GWToolBar();
        toolBar.add(btnSelectFolder);
        toolBar.setBorder(null);
        pnlContent.add((Component)toolBar, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        pnlContent.add((Component)this.cbPrompt, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 24;
        constraints.gridwidth = 3;
        constraints.insets.right = 0;
        pnlContent.add((Component)this.buildButtonsPane(), constraints);
        pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public String getBackupToPath() {
        return this.tfFilePath.getText();
    }

    public boolean doNotPrompt() {
        return this.cbPrompt.isSelected();
    }

    private Container buildButtonsPane() {
        OrientablePanel pnlResult = new OrientablePanel();
        OS.addButtons(pnlResult, this.btnOK, this.btnCancel);
        return pnlResult;
    }

    private void checkFilePath() {
        String path = this.tfFilePath.getText();
        this.btnOK.setEnabled(path != null && !path.equals(""));
    }

    protected void performOkAction() {
        String path = this.tfFilePath.getText();
        File file = new File(path);
        if (!file.exists()) {
            int res = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.DOES_NOT_EXIST_CREATE_DIRECTORY_Q, path), StringResources.GROUPWISE_CLIENT, 0, 3);
            if (res == 0) {
                if (file.mkdirs()) {
                    this.tfFilePath.setText(file.getAbsolutePath());
                    super.performOkAction();
                } else {
                    JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.FAILED_TO_CREATE_DIRECTORY, path), StringResources.GROUPWISE_CLIENT, 0);
                }
            }
        } else {
            super.performOkAction();
        }
    }

    private class CurrentDocumentListener
    implements DocumentListener {
        private CurrentDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            BackupMailBoxDialog.this.checkFilePath();
        }

        public void removeUpdate(DocumentEvent e) {
            BackupMailBoxDialog.this.checkFilePath();
        }

        public void changedUpdate(DocumentEvent e) {
            BackupMailBoxDialog.this.checkFilePath();
        }
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent e) {
            if (OS.isMacOS()) {
                File f;
                boolean isOK;
                String dialogCaption = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(BackupMailBoxDialog.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, dialogCaption, null, 0);
                fileChoser.setVisible(true);
                String selectedFile = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFile != null && (isOK = (f = new File(selecteddirectory + selectedFile)).isDirectory())) {
                    BackupMailBoxDialog.this.tfFilePath.setText(f.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser fileChooser = new GWFileChooser(BackupMailBoxDialog.this, StringResources.OPEN, null, 1, 0, false);
                fileChooser.setVisible(true);
                String[] fileNames = fileChooser.getResult();
                if (fileNames != null) {
                    File selectedFile = fileChooser.getChooser().getSelectedFile();
                    BackupMailBoxDialog.this.tfFilePath.setText(selectedFile.getPath());
                }
            }
        }
    }
}

