/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.backup;

import com.novell.gw.jclient.application.controls.IconedDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class BackupProgressDialog
extends IconedDialog {
    private JLabel lbProgress = new OrientableLabel(" ");
    private JProgressBar pbBackup = new JProgressBar();
    private JButton btnCancel = new OrientableButton(new CancelAction());
    private boolean cancelPressed = false;
    private Object syncObject = new Object();

    public BackupProgressDialog() {
        this.setTitle(StringResources.GROUPWISE_MAILBOX_BACKUP);
        this.buildUI();
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        pnlContent.add((Component)new OrientableLabel(StringResources.MAILBOX_BACKUP_IN_PROGRESS_D), constraints);
        constraints.gridy = 1;
        pnlContent.add((Component)this.lbProgress, constraints);
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        pnlContent.add((Component)this.pbBackup, constraints);
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 11;
        pnlContent.add((Component)this.btnCancel, constraints);
        this.pack();
        this.setDefaultCloseOperation(0);
    }

    public void setProgressString(final String theProgressString) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetProgressString(theProgressString);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.doSetProgressString(theProgressString);
                }
            });
        }
    }

    private void doSetProgressString(String theProgressString) {
        this.lbProgress.setText(theProgressString);
    }

    public void setProgress(final int theProgress) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetProgress(theProgress);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.doSetProgress(theProgress);
                }
            });
        }
    }

    private void doSetProgress(int theProgress) {
        this.pbBackup.setValue(theProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancelPressed(boolean isCancelPressed) {
        Object object = this.syncObject;
        synchronized (object) {
            this.cancelPressed = isCancelPressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelPressed() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.cancelPressed;
        }
    }

    public void showMe() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShowMe();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.doShowMe();
                }
            });
        }
    }

    private void doShowMe() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void hideMe() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.setVisible(false);
                }
            });
        }
    }

    public static void main(String[] args) {
        StringResources.initTestStringResources();
        BackupProgressDialog backupProgressDialog = new BackupProgressDialog();
        backupProgressDialog.setDefaultCloseOperation(3);
        backupProgressDialog.showMe();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            BackupProgressDialog.this.setCancelPressed(true);
            BackupProgressDialog.this.setVisible(false);
        }
    }
}

