/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.calendars;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class CalendarsManageDialog
extends OkCancelDialog {
    private static Logger logger = Logger.getLogger(CalendarsManageDialog.class);
    private ExtendedGWTable calendarsTable;
    private CalendarFolderTableItems tableItems;
    private OrientableButton btnMoveUp;
    private OrientableButton btnMoveDown;
    private OrientableButton btnDelete;
    private OrientableButton btnEdit;
    private OrientableButton btnColor;
    private OrientableButton btnNoColor;

    public CalendarsManageDialog(JFrame theFrame) {
        super(theFrame);
        String userGuid = GWDialog.getUserGuidFromParentFrame(this);
        this.tableItems = new CalendarFolderTableItems(EngineCommandManager.getInstance(userGuid).getCurrentDataStore().getCalendarFolders());
        this.buildUI();
    }

    public static void show(Window window) {
        CalendarsManageDialog dialog = new CalendarsManageDialog((JFrame)window);
        dialog.pack();
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    private void buildUI() {
        this.setTitle(StringResources.MANAGE_CALENDARS);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 1;
        contentPane.add((Component)this.buildCalendarsPanel(), c);
        c.anchor = 11;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        contentPane.add((Component)this.buildButtonPanel(), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.anchor = 20;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        if (OS.isMacOS()) {
            contentPane.add((Component)this.getBtnOk(), c);
        } else {
            contentPane.add((Component)this.getBtnCancel(), c);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.anchor = 22;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        if (OS.isMacOS()) {
            contentPane.add((Component)this.getBtnCancel(), c);
        } else {
            contentPane.add((Component)this.getBtnOk(), c);
        }
    }

    private JPanel buildCalendarsPanel() {
        OrientablePanel calendarsPanel = new OrientablePanel(new BorderLayout());
        calendarsPanel.add((Component)new OrientableLabel(StringResources.CALENDARS), "North");
        this.calendarsTable = new ExtendedGWTable(new CalendarsTableModel());
        this.calendarsTable.setTableHeader(null);
        this.calendarsTable.setDefaultRenderer(Color.class, new CalendarColorRenderer());
        this.calendarsTable.setDefaultEditor(Color.class, new CalendarColorEditor());
        this.calendarsTable.setDefaultRenderer(Boolean.class, new CalendarCheckBoxRenderer());
        TableColumn column = this.calendarsTable.getColumnModel().getColumn(0);
        column.setResizable(false);
        column.setMaxWidth(16);
        column.setMinWidth(16);
        column = this.calendarsTable.getColumnModel().getColumn(1);
        column.setResizable(false);
        column.setMaxWidth(16);
        column.setMinWidth(16);
        this.calendarsTable.setShowGrid(false);
        this.calendarsTable.setSelectionMode(0);
        OrientableTextField tfForCellEditor = new OrientableTextField();
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            tfForCellEditor.setBorder(BorderFactory.createEmptyBorder());
        } else if (OS.isNimbusLAF()) {
            tfForCellEditor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
        this.calendarsTable.getColumnModel().getColumn(2).setCellEditor(new MyTableCellEditor(tfForCellEditor));
        this.calendarsTable.addKeyListener(new OKCancelKeyAdapter());
        SelectionListener listener = new SelectionListener();
        if (this.calendarsTable.getModel().getRowCount() > 0) {
            this.calendarsTable.setRowSelectionInterval(0, 0);
        }
        this.calendarsTable.getSelectionModel().addListSelectionListener(listener);
        ColoredScrollPane scrollPane = new ColoredScrollPane(this.calendarsTable);
        scrollPane.setPreferredSize(new Dimension(200, this.calendarsTable.getPreferredSize().height));
        calendarsPanel.add((Component)scrollPane, "Center");
        return calendarsPanel;
    }

    private OrientablePanel buildButtonPanel() {
        OrientablePanel buttonPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.insets = new Insets(0, 0, 5, 0);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        this.btnMoveUp = new OrientableButton(StringResources.MOVE_UP);
        this.btnMoveUp.addActionListener(new MoveUpButtonListener());
        buttonPanel.add((Component)this.btnMoveUp, c);
        c.gridy = 1;
        this.btnMoveDown = new OrientableButton(StringResources.MOVE_DOWN);
        this.btnMoveDown.addActionListener(new MoveDownButtonListener());
        buttonPanel.add((Component)this.btnMoveDown, c);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        c.gridy = 2;
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMinimumSize(new Dimension(0, 25));
        buttonPanel.add((Component)emptyPanel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.gridy = 3;
        OrientableButton btnNew = new OrientableButton(StringResources.NEW);
        btnNew.addActionListener(new NewButtonListener());
        buttonPanel.add((Component)btnNew, c);
        c.gridy = 4;
        this.btnDelete = new OrientableButton(StringResources.DELETE);
        this.btnDelete.addActionListener(new DeleteButtonListener());
        buttonPanel.add((Component)this.btnDelete, c);
        c.gridy = 5;
        JPanel emptyPanel2 = new JPanel();
        emptyPanel.setMinimumSize(new Dimension(0, 25));
        buttonPanel.add((Component)emptyPanel2, c);
        c.gridy = 6;
        this.btnEdit = new OrientableButton(StringResources.EDIT_D);
        this.btnEdit.addActionListener(new EditButtonListener());
        buttonPanel.add((Component)this.btnEdit, c);
        c.gridy = 7;
        this.btnColor = new OrientableButton(StringResources.COLOR_D);
        this.btnColor.addActionListener(new ColorButtonListener());
        buttonPanel.add((Component)this.btnColor, c);
        c.gridy = 8;
        this.btnNoColor = new OrientableButton(StringResources.NO_COLOR);
        this.btnNoColor.addActionListener(new NoColorButtonListener());
        buttonPanel.add((Component)this.btnNoColor, c);
        return buttonPanel;
    }

    private void enableDisableActions() {
        int row = this.calendarsTable.getSelectedRow();
        if (row < 1) {
            this.btnDelete.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnDelete.setEnabled(true);
            this.btnEdit.setEnabled(true);
        }
        if (row == -1) {
            this.btnColor.setEnabled(false);
            this.btnNoColor.setEnabled(false);
        } else {
            this.btnColor.setEnabled(true);
            this.btnNoColor.setEnabled(true);
        }
        this.btnMoveUp.setEnabled(row != 0 && row != 1 && row != -1);
        this.btnMoveDown.setEnabled(row != 0 && row != this.calendarsTable.getRowCount() - 1 && row != -1);
    }

    public void createNewCalendarFolder() {
        this.tableItems.createNewItem();
        ((CalendarsTableModel)this.calendarsTable.getModel()).fireTableRowsInserted(this.calendarsTable.getRowCount(), this.calendarsTable.getRowCount());
        ((CalendarsTableModel)this.calendarsTable.getModel()).setIsEdited(true);
        MyTableCellEditor cellEditor = (MyTableCellEditor)this.calendarsTable.getColumnModel().getColumn(2).getCellEditor();
        cellEditor.setCellEditable(true);
        this.calendarsTable.editCellAt(this.calendarsTable.getRowCount() - 1, 2);
        cellEditor.tf.requestFocus();
        ((CalendarsTableModel)this.calendarsTable.getModel()).setIsEdited(false);
        this.enableDisableActions();
    }

    protected void processOkAction(ActionEvent event) {
        String userGuid = GWDialog.getUserGuidFromParentFrame(this);
        GWCommandManager manager = EngineCommandManager.getInstance(userGuid);
        List<IFolder> deletedFolders = this.tableItems.getDeletedFolders();
        if (deletedFolders != null) {
            for (IFolder deletedFolder : deletedFolders) {
                if (deletedFolder == null) continue;
                EngineCommandManager.deleteFolder(manager.getGWFolder(deletedFolder), EngineCommandManager.getUserGuid());
            }
        }
        CalendarFolderTableItem mainCalendarItem = this.tableItems.getItem(0);
        CalendarFolder mainCalendarFolder = null;
        try {
            mainCalendarFolder = manager.getCalendarFolder();
            mainCalendarFolder.getNativeFolder().setCalendarColor(mainCalendarItem.color);
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1);
        }
        int nSize = this.tableItems.size();
        for (int i = 1; i < nSize; ++i) {
            SubCalendarFolder calendarFolder;
            CalendarFolderTableItem item = this.tableItems.getItem(i);
            if (item.folder == null) {
                calendarFolder = (SubCalendarFolder)manager.createCalendarFolder(item.name, mainCalendarFolder.getNativeFolder());
                if (calendarFolder == null) {
                    continue;
                }
            } else {
                calendarFolder = (SubCalendarFolder)manager.getGWFolder(item.folder);
            }
            calendarFolder.getNativeFolder().setCalendarListSequenceNumber(i);
            calendarFolder.getNativeFolder().setSubCalendarShown(item.checked);
            calendarFolder.setColor(item.color);
            calendarFolder.getNativeFolder().setName(item.name);
        }
        GWClient.getApplication().processCommand(new GlobalCommand(200));
        super.processOkAction(event);
    }

    public class SelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            CalendarsManageDialog.this.enableDisableActions();
        }
    }

    private class NoColorButtonListener
    extends AbstractAction {
        private NoColorButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)((CalendarsManageDialog)CalendarsManageDialog.this).calendarsTable.getSelectedRow()).color = null;
            ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).fireTableDataChanged();
        }
    }

    private class ColorButtonListener
    extends AbstractAction {
        private ColorButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CalendarsManageDialog.this.calendarsTable.getSelectedRow() == -1) {
                return;
            }
            Color color = JColorChooser.showDialog(CalendarsManageDialog.this, StringResources.COLOR, ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)((CalendarsManageDialog)CalendarsManageDialog.this).calendarsTable.getSelectedRow()).color);
            if (color != null) {
                ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)((CalendarsManageDialog)CalendarsManageDialog.this).calendarsTable.getSelectedRow()).color = color;
                ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).fireTableDataChanged();
            }
        }
    }

    private class OKCancelKeyAdapter
    extends KeyAdapter {
        private OKCancelKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (CalendarsManageDialog.this.calendarsTable.isEditing()) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    CalendarsManageDialog.this.calendarsTable.getCellEditor().stopCellEditing();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    CalendarsManageDialog.this.calendarsTable.getCellEditor().cancelCellEditing();
                }
            }
        }
    }

    private static class MyTableCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        JTextField tf;
        private boolean isCellEditable;

        public boolean isCellEditable(EventObject anEvent) {
            return this.isCellEditable;
        }

        public void setCellEditable(boolean cellEditable) {
            this.isCellEditable = cellEditable;
        }

        public MyTableCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            this.tf.setComponentOrientation(UIUtils.getComponentOrientation());
            tf.addFocusListener(this);
            this.addCellEditorListener(new CellEditorListener(){

                public void editingStopped(ChangeEvent e) {
                    MyTableCellEditor.this.isCellEditable = false;
                }

                public void editingCanceled(ChangeEvent e) {
                    MyTableCellEditor.this.isCellEditable = false;
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.setCaretPosition(0);
            this.tf.selectAll();
            return this.tf;
        }

        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        public void focusLost(FocusEvent e) {
            this.stopCellEditing();
        }
    }

    private class EditButtonListener
    extends AbstractAction {
        private EditButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = CalendarsManageDialog.this.calendarsTable.getSelectedRow();
            if (selectedRow > 0) {
                ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).setIsEdited(true);
                MyTableCellEditor cellEditor = (MyTableCellEditor)CalendarsManageDialog.this.calendarsTable.getColumnModel().getColumn(2).getCellEditor();
                cellEditor.setCellEditable(true);
                CalendarsManageDialog.this.calendarsTable.editCellAt(selectedRow, 2);
                cellEditor.tf.requestFocus();
                ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).setIsEdited(false);
            }
        }
    }

    private class DeleteButtonListener
    extends AbstractAction {
        private DeleteButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = CalendarsManageDialog.this.calendarsTable.getSelectedRow();
            if (selectedRow > 0) {
                CalendarsManageDialog.this.tableItems.deleteItem(selectedRow);
                ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).fireTableRowsDeleted(selectedRow, selectedRow);
                CalendarsManageDialog.this.enableDisableActions();
            }
        }
    }

    private class NewButtonListener
    extends AbstractAction {
        private NewButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CalendarsManageDialog.this.createNewCalendarFolder();
        }
    }

    private class MoveDownButtonListener
    extends AbstractAction {
        private MoveDownButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CalendarsManageDialog.this.calendarsTable.getSelectedRow() < CalendarsManageDialog.this.calendarsTable.getRowCount() && CalendarsManageDialog.this.calendarsTable.getSelectedRow() != 0) {
                int selectedRow = CalendarsManageDialog.this.calendarsTable.getSelectedRow();
                CalendarsManageDialog.this.tableItems.moveItemDown(selectedRow);
                ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).fireTableDataChanged();
                CalendarsManageDialog.this.calendarsTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
            }
        }
    }

    private class MoveUpButtonListener
    extends AbstractAction {
        private MoveUpButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CalendarsManageDialog.this.calendarsTable.getSelectedRow() > 1) {
                int selectedRow = CalendarsManageDialog.this.calendarsTable.getSelectedRow();
                CalendarsManageDialog.this.tableItems.moveItemUp(selectedRow);
                ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).fireTableDataChanged();
                CalendarsManageDialog.this.calendarsTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            }
        }
    }

    private class CalendarColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JDialog dialog;
        protected static final String EDIT = "Edit Calendar Color";

        public CalendarColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.fireEditingStopped();
                if (CalendarsManageDialog.this.calendarsTable.getSelectedRow() == -1) {
                    return;
                }
                ColorChooserButton btn = new ColorChooserButton(((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)((CalendarsManageDialog)CalendarsManageDialog.this).calendarsTable.getSelectedRow()).color);
                btn.addPropertyChangeListener(new PropertyColorChangeAction());
                btn.getColorMenu().pack();
                btn.getColorMenu().show(CalendarsManageDialog.this.calendarsTable, (int)CalendarsManageDialog.this.calendarsTable.getMousePosition().getX(), (int)CalendarsManageDialog.this.calendarsTable.getMousePosition().getY());
            }
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            return this.button;
        }

        private class PropertyColorChangeAction
        implements PropertyChangeListener {
            private PropertyColorChangeAction() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(ColorChooserButton.COLOR_CHANGE_PROPERTY_NAME)) {
                    CalendarColorEditor.this.currentColor = (Color)evt.getNewValue();
                    if (CalendarColorEditor.this.currentColor == null) {
                        CalendarColorEditor.this.currentColor = Color.lightGray;
                    }
                    CalendarsManageDialog.this.calendarsTable.getModel().setValueAt(CalendarColorEditor.this.currentColor, CalendarsManageDialog.this.calendarsTable.getSelectedRow(), 1);
                    ((CalendarsTableModel)CalendarsManageDialog.this.calendarsTable.getModel()).fireTableDataChanged();
                }
            }
        }
    }

    private static class CalendarCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CalendarCheckBoxRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row == 0) {
                this.getModel().setPressed(true);
                this.getModel().setArmed(true);
                this.getModel().setSelected(true);
            } else {
                this.getModel().setPressed(false);
                this.getModel().setArmed(false);
                this.getModel().setSelected(value != null && (Boolean)value != false);
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    private static class CalendarColorRenderer
    extends OrientableTableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;

        public CalendarColorRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = (Color)value;
            this.setBackground(color);
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 1, 2, 1, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 1, 2, 1, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CalendarFolderTableItems {
        List<CalendarFolderTableItem> items;
        List<IFolder> deletedFolders;

        public CalendarFolderTableItems(IFolder[] folders) {
            this.items = new ArrayList<CalendarFolderTableItem>(folders.length);
            this.deletedFolders = new ArrayList<IFolder>();
            for (IFolder folder : folders) {
                CalendarFolderTableItem item = new CalendarFolderTableItem();
                item.name = folder.getName();
                item.color = folder.getCalendarColor();
                item.checked = folder.isSubCalendarShown();
                item.folder = folder;
                this.items.add(item);
            }
        }

        public int size() {
            return this.items.size();
        }

        public CalendarFolderTableItem getItem(int i) {
            return this.items.get(i);
        }

        public void moveItemUp(int i) {
            if (i <= 1) {
                return;
            }
            CalendarFolderTableItem item = this.items.get(i);
            this.items.remove(i);
            this.items.add(i - 1, item);
        }

        public void moveItemDown(int i) {
            if (i >= this.items.size() - 1 || i == 0) {
                return;
            }
            CalendarFolderTableItem item = this.items.get(i);
            this.items.remove(i);
            this.items.add(i + 1, item);
        }

        public void createNewItem() {
            String name = StringResources.NEW_CALENDAR;
            if (this.folderExists(name)) {
                int i = 1;
                while (this.folderExists(name = StringResources.NEW_CALENDAR + '(' + i + ')')) {
                    ++i;
                }
            }
            CalendarFolderTableItem item = new CalendarFolderTableItem();
            item.name = name;
            item.color = null;
            item.checked = true;
            item.folder = null;
            this.items.add(item);
        }

        public boolean folderExists(String name) {
            for (CalendarFolderTableItem item : this.items) {
                if (!item.name.equals(name)) continue;
                return true;
            }
            return false;
        }

        public void deleteItem(int i) {
            this.deletedFolders.add(this.items.get((int)i).folder);
            this.items.remove(i);
        }

        public List<IFolder> getDeletedFolders() {
            return this.deletedFolders;
        }
    }

    private static class CalendarFolderTableItem {
        public String name;
        public Color color;
        public boolean checked;
        public IFolder folder;

        private CalendarFolderTableItem() {
        }
    }

    private class CalendarsTableModel
    extends AbstractTableModel {
        boolean isEdited = false;

        private CalendarsTableModel() {
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (rowIndex != 0) {
                return columnIndex != 2 || this.isEdited;
            }
            return columnIndex == 1;
        }

        public int getRowCount() {
            return CalendarsManageDialog.this.tableItems.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).checked = (Boolean)aValue;
            } else if (columnIndex == 1) {
                ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).color = (Color)aValue;
            } else {
                String name = (String)aValue;
                String oldName = ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).name;
                ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).name = !name.equals(oldName) && CalendarsManageDialog.this.tableItems.folderExists(name) ? oldName : (name.length() != 0 ? name : oldName);
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return Color.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).checked;
            }
            if (columnIndex == 1) {
                Color color = ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).color;
                if (color != null) {
                    return color;
                }
                return AppointmentAcceptLevel.BUSY.getColor();
            }
            return ((CalendarsManageDialog)CalendarsManageDialog.this).tableItems.getItem((int)rowIndex).name;
        }

        public void setIsEdited(boolean b) {
            this.isEdited = b;
        }
    }
}

