/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.categories;

import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

class CategoriesTextCellRenderer
extends OrientableTableCellRenderer {
    private ICategoryList categories;

    public CategoriesTextCellRenderer(ICategoryList categories) {
        this.categories = categories;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background;
        Color foreground;
        ICategory category = (ICategory)value;
        Component component = super.getTableCellRendererComponent(table, CategoryUtils.getCategoryTableName(this.categories, category), isSelected, hasFocus, row, column);
        if (isSelected) {
            foreground = category.getBackgroundColor();
            background = category.getTextColor();
        } else {
            foreground = category.getTextColor();
            background = category.getBackgroundColor();
        }
        if (foreground == null) {
            Color color = foreground = isSelected ? table.getSelectionForeground() : TableRendererUtils.ITEM_LIST_TABLE_FOREGROUND;
        }
        if (background == null) {
            background = isSelected ? table.getSelectionBackground() : TableRendererUtils.ITEM_LIST_TABLE_BACKGROUND;
        }
        this.setForeground(foreground);
        this.setBackground(background);
        this.setBorder(null);
        return component;
    }
}

