/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.datedifference;

import com.appframework.components.DigitDocument;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class DateDifferenceDialog
extends GWDialog
implements DateValueChangeListener {
    private static Logger logger = Logger.getLogger(DateDifferenceDialog.class);
    private Dimension dimDialogSize = new Dimension(460, 400);
    private JTextField tfDaysDifferent;
    private int daysDifferent = 0;
    private Dimension dimDays = new Dimension(60, 20);
    private MonthlyCalendar startDayCalendar;
    private Calendar gcStartDate;
    private DateTextField dtfEndDate;
    private JButton btnStartToday;
    private JButton btnCalculateStart;
    private MonthlyCalendar endDayCalendar;
    private DateTextField dtfStartDate;
    private Calendar gcEndDate;
    private JButton btnEndToday;
    private JButton btnCalculateEnd;
    private JButton btnClose;

    public DateDifferenceDialog(JFrame theParent) {
        super(theParent);
        this.buildUI();
        this.refreshUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DATE_DIFFERENCE);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridBagLayout());
        this.btnClose = new OrientableButton(new BtnCloseAction(StringResources.CLOSE));
        GridBagConstraints c = new GridBagConstraints();
        OrientablePanel pnl = new OrientablePanel(new FlowLayout(3));
        OrientableLabel lblDays = new OrientableLabel(StringResources.NUMBER_OF_DAYS_DIFFERENT_C);
        pnl.add(lblDays);
        this.tfDaysDifferent = new GWTextField();
        this.tfDaysDifferent.setDocument(new DigitDocument());
        this.tfDaysDifferent.getDocument().addDocumentListener(new TfDaysDifferent());
        this.tfDaysDifferent.setColumns(3);
        pnl.add(this.tfDaysDifferent);
        pnl.add(new OrientableLabel(StringResources.L_DAY_S));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)pnl, c);
        c.anchor = 21;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.buildStartDayPanel(), c);
        c.anchor = 22;
        c.gridx = 1;
        this.getContentPane().add((Component)this.buildEndDayPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 10;
        c.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.btnClose, c);
        this.setDefaultButton(this.btnClose);
        this.setCancelButton(this.btnClose);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private DateFormat getDateFormat() {
        String format = OptionManager.getInstance().getDateTimeOptions().getDateFormat();
        return DateAndTimeFormattingUtils.getDateFormat(format);
    }

    private JPanel buildStartDayPanel() {
        this.startDayCalendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, false);
        this.startDayCalendar.addValueChangeListener(this);
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(0);
        pnl.setBorder(BorderFactory.createTitledBorder(border, StringResources.START_DATE));
        GridBagConstraints c = new GridBagConstraints();
        this.dtfStartDate = new DateTextField(this.getDateFormat(), new DateDocumentHandler()){

            public void valueChanged(DateChangeEvent e) {
                super.valueChanged(e);
                DateDifferenceDialog.this.startDayCalendar.setDate(this.getDate());
            }
        };
        this.gcStartDate = this.startDayCalendar.getDate();
        this.dtfStartDate.setDate(this.startDayCalendar.getDate());
        c.insets = new Insets(5, 10, 10, 10);
        c.fill = 2;
        c.weightx = 1.0;
        pnl.add((Component)this.dtfStartDate, c);
        c.gridx = 0;
        c.insets = new Insets(0, 10, 0, 10);
        pnl.add((Component)this.startDayCalendar, c);
        this.btnStartToday = new JButton(StringResources.GO_TO_TODAY);
        this.btnStartToday.addActionListener(new BtnStartTodayAction());
        c.gridy = 2;
        c.insets = new Insets(10, 10, 0, 10);
        pnl.add((Component)this.btnStartToday, c);
        this.btnCalculateStart = new JButton(StringResources.CALCULATE_START_DATE);
        this.btnCalculateStart.addActionListener(new BtnCalculateStart());
        c.gridy = 3;
        c.insets = new Insets(10, 10, 10, 10);
        pnl.add((Component)this.btnCalculateStart, c);
        return pnl;
    }

    private JPanel buildEndDayPanel() {
        this.endDayCalendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, false);
        this.endDayCalendar.addValueChangeListener(this);
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(0);
        pnl.setBorder(BorderFactory.createTitledBorder(border, StringResources.END_DATE));
        GridBagConstraints c = new GridBagConstraints();
        this.dtfEndDate = new DateTextField(this.getDateFormat(), new DateDocumentHandler()){

            public void valueChanged(DateChangeEvent e) {
                super.valueChanged(e);
                DateDifferenceDialog.this.endDayCalendar.setDate(this.getDate());
            }
        };
        this.gcEndDate = this.endDayCalendar.getDate();
        c.insets = new Insets(5, 10, 10, 10);
        c.fill = 2;
        c.weightx = 1.0;
        pnl.add((Component)this.dtfEndDate, c);
        c.gridx = 0;
        c.insets = new Insets(0, 10, 0, 10);
        pnl.add((Component)this.endDayCalendar, c);
        this.btnEndToday = new JButton(StringResources.GO_TO_TODAY);
        this.btnEndToday.addActionListener(new BtnEndTodayAction());
        c.gridy = 2;
        c.insets = new Insets(10, 10, 0, 10);
        pnl.add((Component)this.btnEndToday, c);
        this.btnCalculateEnd = new JButton(StringResources.CALCULATE_END_DATE);
        this.btnCalculateEnd.addActionListener(new BtnCalculateEnd());
        c.gridy = 3;
        c.insets = new Insets(10, 10, 10, 10);
        pnl.add((Component)this.btnCalculateEnd, c);
        return pnl;
    }

    private void refreshUI() {
        this.dtfStartDate.setDate(this.gcStartDate);
        this.dtfEndDate.setDate(this.gcEndDate);
        long endDay = this.gcEndDate.getTimeInMillis() / 86400000L;
        long startDay = this.gcStartDate.getTimeInMillis() / 86400000L;
        this.daysDifferent = (int)Math.abs(endDay - startDay);
        this.tfDaysDifferent.setText(Integer.toString(this.daysDifferent));
    }

    public void valueChanged(DateChangeEvent e) {
        Calendar newDate = e.getDate();
        Object source = e.getSource();
        if (this.gcStartDate != null && this.gcEndDate != null) {
            if (source == this.startDayCalendar) {
                this.gcStartDate.set(1, newDate.get(1));
                this.gcStartDate.set(2, newDate.get(2));
                this.gcStartDate.set(5, newDate.get(5));
            } else {
                this.gcEndDate.set(1, newDate.get(1));
                this.gcEndDate.set(2, newDate.get(2));
                this.gcEndDate.set(5, newDate.get(5));
            }
            this.refreshUI();
        }
    }

    private class TfDaysDifferent
    implements DocumentListener {
        private TfDaysDifferent() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.parseDoc();
        }

        public void removeUpdate(DocumentEvent e) {
            this.parseDoc();
        }

        public void changedUpdate(DocumentEvent e) {
            this.parseDoc();
        }

        private void parseDoc() {
            if (DateDifferenceDialog.this.tfDaysDifferent.getText().length() == 0) {
                DateDifferenceDialog.this.daysDifferent = 0;
                return;
            }
            int x = 0;
            try {
                x = Integer.parseInt(DateDifferenceDialog.this.tfDaysDifferent.getText());
                DateDifferenceDialog.this.daysDifferent = x;
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Please, insert an integer value!");
            }
        }
    }

    private class BtnCalculateEnd
    extends AbstractAction {
        private BtnCalculateEnd() {
        }

        public void actionPerformed(ActionEvent e) {
            DateDifferenceDialog dlg = DateDifferenceDialog.this;
            dlg.gcEndDate = (Calendar)dlg.gcStartDate.clone();
            dlg.gcEndDate.add(5, dlg.daysDifferent);
            dlg.endDayCalendar.setDate(dlg.gcEndDate);
            dlg.refreshUI();
        }
    }

    private class BtnCalculateStart
    extends AbstractAction {
        private BtnCalculateStart() {
        }

        public void actionPerformed(ActionEvent e) {
            DateDifferenceDialog dlg = DateDifferenceDialog.this;
            dlg.gcStartDate = (Calendar)dlg.gcEndDate.clone();
            dlg.gcStartDate.add(5, -dlg.daysDifferent);
            dlg.startDayCalendar.setDate(dlg.gcStartDate);
            dlg.refreshUI();
        }
    }

    private class BtnEndTodayAction
    extends AbstractAction {
        private BtnEndTodayAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DateDifferenceDialog dlg = DateDifferenceDialog.this;
            dlg.endDayCalendar.gotoToday();
            dlg.gcEndDate = dlg.endDayCalendar.getDate();
            dlg.refreshUI();
        }
    }

    private class BtnStartTodayAction
    extends AbstractAction {
        private BtnStartTodayAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DateDifferenceDialog dlg = DateDifferenceDialog.this;
            dlg.startDayCalendar.gotoToday();
            dlg.gcStartDate = dlg.startDayCalendar.getDate();
            dlg.refreshUI();
        }
    }

    private class BtnCloseAction
    extends AbstractAction {
        public BtnCloseAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            DateDifferenceDialog.this.dispose();
        }
    }
}

