/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.error;

import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.orientable.OrientableDialog;
import com.novell.gw.jclient.application.dialogs.error.ExErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ErrorDialog {
    private static Logger logger = Logger.getLogger(ErrorDialog.class);
    private static boolean testMode = false;

    public static void processGWException(GWException theException) {
        ErrorDialog.processGWException(theException, null);
    }

    private static Window getTopParentForComponent(Component theComponent) {
        if (theComponent != null) {
            if (theComponent instanceof Dialog || theComponent instanceof Frame) {
                return (Window)theComponent;
            }
            return ErrorDialog.getTopParentForComponent(theComponent.getParent());
        }
        return null;
    }

    public static void processEngineException(EngineException theException, Component parentComponent) {
        if (testMode) {
            return;
        }
        int errorCode = theException.getErrorCode();
        String title = StringResources.GROUPWISE_ERROR + " [" + Integer.toHexString(theException.getErrorCode()).toUpperCase() + ']';
        String errorMsg = EngineException.getErrorString((int)errorCode);
        String trace = ErrorDialog.getStackTrace(theException);
        if (errorMsg.length() == 0) {
            errorMsg = StringResources.UNEXPECTED_EXCEPTION;
        }
        OrientableDialog dialog = null;
        if ((parentComponent = ErrorDialog.getTopParentForComponent(parentComponent)) != null) {
            if (parentComponent instanceof Frame) {
                dialog = new ExErrorDialog(title, errorMsg, trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Frame)parentComponent);
            } else if (parentComponent instanceof Dialog) {
                dialog = new ExErrorDialog(title, errorMsg, trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Dialog)parentComponent);
            }
        }
        if (dialog == null) {
            dialog = new ExErrorDialog(title, errorMsg, trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"));
        }
        UIUtils.centerWindow(dialog, parentComponent);
        dialog.setVisible(true);
    }

    public static void processGWException(GWException theException, Component parentComponent) {
        if (testMode) {
            return;
        }
        String trace = ErrorDialog.getStackTrace(theException);
        OrientableDialog dialog = null;
        if ((parentComponent = ErrorDialog.getTopParentForComponent(parentComponent)) != null) {
            if (parentComponent instanceof Frame) {
                dialog = new ExErrorDialog(StringResources.ERROR + " ...", theException.getExplanation(), trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Frame)parentComponent);
            } else if (parentComponent instanceof Dialog) {
                dialog = new ExErrorDialog(StringResources.ERROR + " ...", theException.getExplanation(), trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Dialog)parentComponent);
            }
        }
        if (dialog == null) {
            dialog = new ExErrorDialog(StringResources.ERROR + " ...", theException.getExplanation(), trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"));
        }
        UIUtils.centerWindow(dialog, parentComponent);
        dialog.setVisible(true);
    }

    public static void processThrowable(Throwable theThrowable) {
        ErrorDialog.processThrowable(theThrowable, null);
    }

    public static void processThrowable(Throwable theThrowable, Component parentComponent) {
        if (testMode) {
            return;
        }
        if (theThrowable instanceof GWException) {
            ErrorDialog.processGWException((GWException)theThrowable, parentComponent);
        } else if (theThrowable instanceof EngineException) {
            ErrorDialog.processEngineException((EngineException)theThrowable, parentComponent);
        } else {
            String trace = ErrorDialog.getStackTrace(theThrowable);
            OrientableDialog dialog = null;
            if ((parentComponent = ErrorDialog.getTopParentForComponent(parentComponent)) != null) {
                if (parentComponent instanceof Frame) {
                    dialog = new ExErrorDialog(StringResources.ERROR + " ...", StringResources.UNEXPECTED_EXCEPTION, trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Frame)parentComponent);
                } else if (parentComponent instanceof Dialog) {
                    dialog = new ExErrorDialog(StringResources.ERROR + " ...", StringResources.UNEXPECTED_EXCEPTION, trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Dialog)parentComponent);
                }
            }
            if (dialog == null) {
                dialog = new ExErrorDialog(StringResources.ERROR + " ...", StringResources.UNEXPECTED_EXCEPTION, trace, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"));
            }
            UIUtils.centerWindow(dialog, parentComponent);
            dialog.setVisible(true);
        }
    }

    private static String getStackTrace(Throwable theThrowable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        theThrowable.printStackTrace(printStream);
        printStream.flush();
        String trace = new String(byteArrayOutputStream.toByteArray());
        return trace;
    }

    public static void setTestMode(boolean theTestMode) {
        testMode = theTestMode;
    }
}

