/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.FoldersDialog;
import com.novell.gw.jclient.application.controls.MinimumSizeKeepingPanel;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.filter.FilterPanel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.AddPanelDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.CreatePanelTemplateDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.CustomizePanelsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsMode;
import com.novell.gw.jclient.application.dialogs.folderproperties.MoreDisplaySettingsPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditPanelDialog
extends ApplicationDialog<ApplicationDialogController> {
    private static Logger logger = Logger.getLogger(AbstractEditPanelDialog.class);
    protected static Insets DEFAULT_INSETS = new Insets(4, 4, 4, 4);
    protected static int DEFAULT_GAP = 10;
    public static int UNSET_REFRESH_INTERVAL = 0;
    protected IPanelDisplaySettings displaySettings;
    protected DisplaySettingsMode mode;
    protected MinimumSizeKeepingPanel pnlGeneral;
    protected OrientablePanel pnlDisplay = new OrientablePanel();
    protected OrientablePanel pnlFilterTab;
    protected OrientablePanel pnlFilter;
    protected GWTextField txtPanelName;
    protected OrientableLabel lbSelectedFolder;
    private GWTextField txtWebPage;
    private OrientableCheckBox cbRefreshWebPage;
    private JSpinner spnWebPageRefreshSpinner;
    protected String initialWebPage;
    protected int initialRefreshInterwal;
    protected AbstractFolder selectedFolder;
    protected Filter filter = null;
    protected List<Integer> viewModesList;
    private OrientableTabbedPane tabs;

    public AbstractEditPanelDialog(JDialog dialog, MVCController parentController, IPanelDisplaySettings displaySettings) {
        super((Dialog)dialog, parentController);
        this.init(displaySettings);
    }

    public AbstractEditPanelDialog(JFrame frame, MVCController parentController, IPanelDisplaySettings displaySettings) {
        super((Frame)frame, parentController);
        this.init(displaySettings);
    }

    private void init(IPanelDisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        this.setTitle(displaySettings.getName() + ' ' + StringResources.SETTINGS);
        this.init();
        this.buildUI();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<AbstractEditPanelDialog>(this, parentController);
    }

    private void init() {
        String webPage = this.displaySettings.getPanelWebPage();
        this.mode = !Utils.isNullOrEmpty(webPage) ? DisplaySettingsMode.WEB_PAGE : DisplaySettingsMode.FOLDER;
        logger.debug((Object)("mode: " + (Object)((Object)this.mode)));
        IFolder nativeFolder = this.displaySettings.getPanelFolder(this.getDataStore());
        logger.debug((Object)("nativeFolder: " + (nativeFolder == null ? "null" : nativeFolder.getName())));
        if (nativeFolder == null) {
            if (this.getOwner() instanceof GWMainAppFrame) {
                this.selectedFolder = ((GWMainAppFrame)this.getOwner()).getFolder();
            } else if (this.getOwner() instanceof CustomizePanelsDialog) {
                AbstractFolder abstractFolder;
                IFolder folder = ((CustomizePanelsDialog)this.getOwner()).getFolder();
                this.selectedFolder = abstractFolder = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getGWFolder(folder);
            } else if (this.getOwner() instanceof AddPanelDialog) {
                this.selectedFolder = ((AddPanelDialog)this.getOwner()).getFolder();
            }
        } else {
            this.selectedFolder = EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(this)).getGWFolder(nativeFolder);
        }
        switch (this.mode) {
            case FOLDER: {
                this.viewModesList = this.getViewModesList(this.selectedFolder);
                break;
            }
        }
        if (this.mode == DisplaySettingsMode.FOLDER) {
            ItemListFilter itemListFilter = this.displaySettings.getPanelFilter();
            this.filter = GWEngineUtils.createFilter(itemListFilter, this.getDataStore());
            boolean isContact = this.selectedFolder.isContactsFolder();
            if (isContact) {
                if (this.filter instanceof AdvancedFilter) {
                    ((AdvancedFilter)this.filter).setContactType(true);
                }
                if (this.filter instanceof CustomFilter) {
                    boolean isSystem = ABUtils.isSystemABAbstractFolder(((ApplicationDialogController)this.getController()).getActionList());
                    if (this.filter.isEmpty()) {
                        this.filter = new ContactFilter(new AddressBookItemListFilter(isSystem), isSystem);
                    } else {
                        this.filter = new ContactFilter(new AddressBookItemListFilter(isSystem), isSystem);
                        ((ContactFilter)this.filter).setCategories(APIWrapperManager.getCategoryList(itemListFilter.getCategories(this.getDataStore().getNativeDataStore())));
                    }
                }
            }
        }
        if (this.mode == DisplaySettingsMode.WEB_PAGE) {
            this.initialWebPage = this.displaySettings.getPanelWebPage();
            this.initialRefreshInterwal = this.displaySettings.getPanelRefreshInterval();
        }
    }

    private void buildUI() {
        this.buildGeneralPanel();
        this.tabs = new OrientableTabbedPane();
        this.tabs.add(StringResources.GENERAL, this.pnlGeneral);
        switch (this.mode) {
            case FOLDER: {
                this.buildDisplayPanel();
                this.buildFilterPanel(this.selectedFolder);
                this.tabs.add(StringResources.DISPLAY, this.pnlDisplay);
                this.tabs.add(StringResources.FILTER, this.pnlFilterTab);
                break;
            }
            case WEB_PAGE: {
                this.buildDisplayPanel();
                this.pnlGeneral.setMinimalHeight(this.pnlDisplay.getPreferredSize().height);
                break;
            }
        }
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(1, 2, DEFAULT_GAP, 0));
        OS.addButtons(pnlButtons, this.getBtnOk(), this.getBtnCancel());
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(DEFAULT_GAP, 0, 0, 0));
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        ((JPanel)contentPane).setBorder(BorderFactory.createEmptyBorder(DEFAULT_GAP, DEFAULT_GAP, DEFAULT_GAP, DEFAULT_GAP));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        contentPane.add((Component)this.tabs, c);
        c.gridy = 1;
        c.fill = 0;
        c.anchor = 22;
        c.weightx = 0.0;
        c.weighty = 0.0;
        contentPane.add((Component)pnlButtons, c);
    }

    private void buildGeneralPanel() {
        this.pnlGeneral = new MinimumSizeKeepingPanel();
        logger.debug((Object)("name: " + this.displaySettings.getName()));
        logger.debug((Object)("panel name: " + this.displaySettings.getPanelName()));
        this.txtPanelName = new GWTextField();
        this.txtPanelName.setText(this.displaySettings.getPanelName());
        OrientableLabel lbPanelName = new OrientableLabel(StringResources.PANEL_NAME_C);
        OrientablePanel pnlSelection = new OrientablePanel();
        switch (this.mode) {
            case FOLDER: {
                OrientableLabel lbFolder = new OrientableLabel(StringResources.SELECTED_FOLDER_C);
                this.lbSelectedFolder = new OrientableLabel(this.selectedFolder.getName());
                OrientableButton btnChangeFolder = new OrientableButton(new ActionChangeFolder());
                pnlSelection.setLayout(new BoxLayout(pnlSelection, 2));
                pnlSelection.add(lbFolder);
                pnlSelection.add(Box.createRigidArea(new Dimension(DEFAULT_GAP, 0)));
                pnlSelection.add(this.lbSelectedFolder);
                pnlSelection.add(Box.createRigidArea(new Dimension(DEFAULT_GAP, 0)));
                pnlSelection.add(Box.createHorizontalGlue());
                pnlSelection.add(btnChangeFolder);
                break;
            }
            case WEB_PAGE: {
                OrientableLabel lbWebPage = new OrientableLabel(StringResources.SELECTED_WEB_PAGE_C);
                this.txtWebPage = new GWTextField(this.initialWebPage);
                OrientablePanel pnlTop = new OrientablePanel();
                pnlTop.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.insets = DEFAULT_INSETS;
                c.gridx = 0;
                c.gridy = 0;
                pnlTop.add((Component)lbWebPage, c);
                c.gridx = 1;
                c.weightx = 1.0;
                c.fill = 2;
                pnlTop.add((Component)this.txtWebPage, c);
                this.cbRefreshWebPage = new OrientableCheckBox(StringResources.AUTOMATICALLY_REFRESH_WEB_PAGE_EVERY);
                this.cbRefreshWebPage.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        AbstractEditPanelDialog.this.spnWebPageRefreshSpinner.setEnabled(e.getStateChange() == 1);
                    }
                });
                OrientableLabel lbMinutes = new OrientableLabel(StringResources.MINUTE_S);
                boolean initialValueSet = this.initialRefreshInterwal != UNSET_REFRESH_INTERVAL;
                int initialValue = initialValueSet ? this.initialRefreshInterwal : CreatePanelTemplateDialog.INITIAL_WEB_PAGE_REFRESH_INTERVAL;
                SpinnerNumberModel minutesModel = new SpinnerNumberModel(initialValue, 1, 1440, 1);
                this.spnWebPageRefreshSpinner = new OrientableSpinner(minutesModel);
                this.spnWebPageRefreshSpinner.setEnabled(initialValueSet);
                this.cbRefreshWebPage.setSelected(initialValueSet);
                OrientablePanel pnlBottom = new OrientablePanel();
                pnlBottom.setLayout(new GridBagLayout());
                c = new GridBagConstraints();
                c.anchor = 23;
                c.gridx = 0;
                pnlBottom.add((Component)this.cbRefreshWebPage, c);
                c.insets = DEFAULT_INSETS;
                ++c.gridx;
                pnlBottom.add((Component)this.spnWebPageRefreshSpinner, c);
                ++c.gridx;
                c.weightx = 1.0;
                pnlBottom.add((Component)lbMinutes, c);
                pnlSelection.setLayout(new GridBagLayout());
                c = new GridBagConstraints();
                c.anchor = 23;
                c.fill = 2;
                c.weightx = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                pnlSelection.add((Component)pnlTop, c);
                c.gridy = 1;
                c.weighty = 1.0;
                pnlSelection.add((Component)pnlBottom, c);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected value: " + (Object)((Object)this.mode)));
            }
        }
        this.pnlGeneral.setLayout(new GridBagLayout());
        this.pnlGeneral.setBorder(BorderFactory.createEmptyBorder(DEFAULT_GAP, DEFAULT_GAP, DEFAULT_GAP, DEFAULT_GAP));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = DEFAULT_INSETS;
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlGeneral.add((Component)lbPanelName, c);
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.pnlGeneral.add((Component)this.txtPanelName, c);
        c.gridy = 2;
        c.weighty = 1.0;
        c.anchor = 23;
        this.pnlGeneral.add((Component)pnlSelection, c);
    }

    private void buildDisplayPanel() {
        this.pnlDisplay.removeAll();
        this.pnlDisplay.add(new MoreDisplaySettingsPanel((IFolderDisplaySettings)((Object)this.displaySettings), ControlsUtils.getUserGuid(this.getController()), this.selectedFolder.getNativeFolder()));
    }

    private void buildFilterPanel(AbstractFolder folder) {
        this.pnlFilterTab = new OrientablePanel();
        this.pnlFilterTab.setBorder(BorderFactory.createEmptyBorder(DEFAULT_GAP, DEFAULT_GAP, DEFAULT_GAP, DEFAULT_GAP));
        if (this.mode != DisplaySettingsMode.FOLDER) {
            throw new IllegalStateException("unexpected mode: " + (Object)((Object)this.mode));
        }
        this.pnlFilter = new FilterPanel(this, (MVCController)this.getController(), this.filter, folder.isContactsFolder());
        OrientableButton btnAdvancedFilter = new OrientableButton((FilterPanel)this.pnlFilter.new FilterPanel.ActionAdvanced());
        OrientableButton btnReset = new OrientableButton((FilterPanel)this.pnlFilter.new FilterPanel.ActionReset());
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        pnlButtons.add(btnAdvancedFilter);
        pnlButtons.add(btnReset);
        this.pnlFilterTab.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 19;
        this.pnlFilterTab.add((Component)this.pnlFilter, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.pnlFilterTab.add((Component)pnlButtons, c);
    }

    public IPanelDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    protected IDataStore getDataStore() {
        return EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(this)).getCurrentDataStore();
    }

    protected void writeDisplayOptions() {
        MoreDisplaySettingsPanel pane;
        logger.debug((Object)("writing display options: " + this.txtPanelName.getText()));
        this.displaySettings.setPanelName(this.txtPanelName.getText());
        switch (this.mode) {
            case FOLDER: {
                logger.debug((Object)("set panel folder to " + this.selectedFolder.getNativeFolder()));
                boolean result = this.displaySettings.setPanelFolder(this.selectedFolder.getNativeFolder());
                logger.debug((Object)("result: " + result));
                break;
            }
            case WEB_PAGE: {
                logger.debug((Object)("set panel web page to " + this.txtWebPage.getText()));
                this.displaySettings.setPanelWebPage(this.txtWebPage.getText());
                int interval = this.cbRefreshWebPage.isSelected() ? (Integer)this.spnWebPageRefreshSpinner.getModel().getValue() : UNSET_REFRESH_INTERVAL;
                this.displaySettings.setPanelRefreshInterval(interval);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected value: " + (Object)((Object)this.mode)));
            }
        }
        if (this.mode == DisplaySettingsMode.FOLDER && (pane = (MoreDisplaySettingsPanel)this.pnlDisplay.getComponent(0)).isChangedProperties()) {
            pane.saveProperties();
        }
        if (this.mode == DisplaySettingsMode.FOLDER) {
            this.filter = ((FilterPanel)this.pnlFilter).getFilter();
            this.displaySettings.setPanelFilter(this.filter.getItemListFilter());
        }
        this.displaySettings.writeDisplaySettings();
    }

    private void handleSelectedFolderChange(AbstractFolder folder) {
        if (this.selectedFolder.isContactsFolder() != folder.isContactsFolder()) {
            this.changeFilterType(folder);
            IDataStore currentDataStore = EngineCommandManager.getInstance(GWDialog.getUserGuidFromParentFrame(this)).getCurrentDataStore();
            this.displaySettings = APIWrapperManager.createPanelDisplaySettings(currentDataStore, folder.isContactsFolder());
            this.displaySettings.setPanelFolder(folder.getNativeFolder());
            this.displaySettings.setViewMode(1);
        }
        this.selectedFolder = folder;
        this.displaySettings.setPanelFolder(folder.getNativeFolder());
        this.lbSelectedFolder.setText(folder.getName());
        List<Integer> newList = this.getViewModesList(this.selectedFolder);
        if (!((Object)newList).equals(this.viewModesList)) {
            logger.debug((Object)"updating display tab");
            this.viewModesList = newList;
            this.buildDisplayPanel();
        }
    }

    private void changeFilterType(AbstractFolder folder) {
        if (folder.isContactsFolder()) {
            boolean isSystem = ABUtils.isSystemABAbstractFolder(folder);
            this.filter = new ContactFilter(isSystem);
        } else {
            this.filter = new CustomFilter();
        }
        this.tabs.remove(this.pnlFilterTab);
        this.buildFilterPanel(folder);
        this.tabs.add(StringResources.FILTER, this.pnlFilterTab);
    }

    private List<Integer> getViewModesList(AbstractFolder folder) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (ControlsUtils.isViewByCalendarSupported(folder, true)) {
            results.add(6);
        }
        if (ControlsUtils.isViewByCheckListSupported(folder, true)) {
            results.add(7);
        }
        if (ControlsUtils.isViewByConversationSupported(folder, true)) {
            results.add(5);
        }
        if (ControlsUtils.isViewByDetailsSupported(folder, true) || ControlsUtils.isViewByContactDetailsSupported(folder, true)) {
            results.add(1);
        }
        return results;
    }

    protected abstract void saveChanges();

    protected boolean checkSettings() {
        String templateName = this.txtPanelName.getText().trim();
        if (templateName.length() == 0) {
            JOptionPane.showMessageDialog(this, StringResources.PLEASE_ENTER_A_PANEL_NAME, StringResources.NOVELL_GROUPWISE, 1);
            return false;
        }
        if (this.mode == DisplaySettingsMode.WEB_PAGE && this.txtWebPage.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, StringResources.PLEASE_ENTER_A_WEB_PAGE_ADDRESS, StringResources.NOVELL_GROUPWISE, 1);
            return false;
        }
        return true;
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        if (!this.checkSettings()) {
            logger.debug((Object)"validation failed");
            return;
        }
        this.saveChanges();
        super.processOkAction(event);
    }

    private class ActionChangeFolder
    extends AbstractAction {
        public ActionChangeFolder() {
            super(StringResources.CHANGE_FOLDER_D);
        }

        public void actionPerformed(ActionEvent e) {
            FoldersDialog foldersDialog = new FoldersDialog(AbstractEditPanelDialog.this, (MVCController)AbstractEditPanelDialog.this.getController(), AbstractEditPanelDialog.this.selectedFolder, StringResources.SELECT_THE_FOLDER_BELOW);
            foldersDialog.pack();
            foldersDialog.setLocationRelativeTo(null);
            foldersDialog.setVisible(true);
            if (foldersDialog.isOkActionProcessed()) {
                AbstractFolder selectedFolder = foldersDialog.getSelectedFolder();
                AbstractEditPanelDialog.this.handleSelectedFolderChange(selectedFolder);
            }
        }
    }
}

