/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.CustomizePanelsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.EditPanelDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AllColumnPanelsPane
extends OrientablePanel {
    private String panelName;
    private String columnName;
    private String selectedColumn;
    private int columnCount = 3;
    public DefaultListModel lstModel = new DefaultListModel();
    public OrientableList lstAllColumns = new OrientableList((ListModel)this.lstModel);
    private ActionMoveUpPanel actionMoveUp = new ActionMoveUpPanel();
    private ActionMoveDownPanel actionMoveDown = new ActionMoveDownPanel();
    private ActionDeletePanel actionDelete = new ActionDeletePanel();
    private ActionEditPanel actionEdit = new ActionEditPanel();

    public AllColumnPanelsPane(String panelName, String columnName) {
        this.panelName = panelName;
        this.columnName = columnName;
        this.lstAllColumns.setSelectionMode(0);
        for (int i = 0; i < this.columnCount; ++i) {
            this.lstModel.addElement(columnName + " " + (i + 1));
        }
        this.lstAllColumns.addListSelectionListener(new ColumnsListSelectionListener());
        this.lstAllColumns.setCellRenderer(new ColumnListCellRenderer());
        this.setActionsEnable(false);
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 25;
        constraints.insets = CustomizePanelsDialog.getPanelListCaptionInsets();
        this.add((Component)new OrientableLabel(this.panelName), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new OrientableScrollPane(this.lstAllColumns), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.createButtonsPanel(), constraints);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel(new GridLayout(4, 1, 0, 5));
        OrientableButton btnMoveUp = new OrientableButton(this.actionMoveUp);
        pnl.add(btnMoveUp);
        OrientableButton btnMoveDown = new OrientableButton(this.actionMoveDown);
        pnl.add(btnMoveDown);
        OrientableButton btnEdit = new OrientableButton(this.actionEdit);
        pnl.add(btnEdit);
        OrientableButton btnDelete = new OrientableButton(this.actionDelete);
        pnl.add(btnDelete);
        return pnl;
    }

    public void setColumnCount(int count) {
        if (count > this.columnCount) {
            this.lstModel.addElement(this.columnName + " " + count);
        } else if (count < this.columnCount) {
            if (this.lstAllColumns.getSelectionModel().getMinSelectionIndex() == count) {
                this.lstAllColumns.getSelectionModel().setLeadSelectionIndex(count - 1);
            }
            int nSize = this.lstModel.getSize();
            for (int i = 0; i < nSize; ++i) {
                if (!this.lstModel.getElementAt(i).equals(this.columnName + " " + this.columnCount) || !this.lstModel.getElementAt(i).getClass().equals(String.class)) continue;
                this.lstModel.remove(i);
                break;
            }
        }
        this.columnCount = count;
    }

    public void addPanel(IPanelDisplaySettings ds) {
        if (this.selectedColumn == null) {
            this.selectedColumn = this.lstModel.getElementAt(0).toString();
        }
        int nSize = this.lstModel.getSize();
        for (int i = 0; i < nSize; ++i) {
            if (!this.lstModel.getElementAt(i).equals(this.selectedColumn)) continue;
            this.lstModel.add(i + 1, ds);
            break;
        }
    }

    public void addPanel(IPanelDisplaySettings ds, int selected) {
        this.selectedColumn = this.columnName + " " + (selected + 1);
        int nSize = this.lstModel.getSize();
        for (int i = 0; i < nSize; ++i) {
            if (!this.lstModel.getElementAt(i).equals(this.selectedColumn)) continue;
            this.lstModel.add(i + this.getPanelCount(selected) + 1, ds);
            break;
        }
    }

    public IPanelDisplaySettings[] getPanels(int column) {
        IPanelDisplaySettings[] displaySettings = new IPanelDisplaySettings[this.getPanelCount(column)];
        int nCount = this.getPanelCount(column);
        for (int i = 0; i < nCount; ++i) {
            displaySettings[i] = (IPanelDisplaySettings)this.lstModel.getElementAt(this.getColumnIndex(column) + 1 + i);
        }
        return displaySettings;
    }

    public int getPanelCount(int column) {
        int panelCount = 0;
        panelCount = column == this.columnCount - 1 ? this.lstModel.getSize() - this.getColumnIndex(column) - 1 : this.getColumnIndex(column + 1) - this.getColumnIndex(column) - 1;
        return panelCount;
    }

    private int getColumnIndex(int column) {
        int index = 0;
        int nSize = this.lstModel.getSize();
        for (int i = 0; i < nSize; ++i) {
            if (!this.lstModel.getElementAt(i).equals(this.columnName + " " + (column + 1)) || !this.lstModel.getElementAt(i).getClass().equals(String.class)) continue;
            index = i;
            break;
        }
        return index;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void removeAllPanels() {
        int nSize = this.lstModel.getSize();
        for (int i = 0; i < nSize; ++i) {
            if (this.lstModel.getElementAt(i).getClass().equals(String.class)) continue;
            this.lstModel.remove(i);
        }
    }

    public void removePanel(IPanelDisplaySettings ds) {
        this.lstModel.removeElement(ds);
    }

    public void setPanels(IPanelDisplaySettings[][] ds) {
        this.removeAllPanels();
        int nCount = ds.length;
        for (int i = 0; i < nCount; ++i) {
            int j;
            if (i == this.columnCount) {
                for (j = 0; j < ds[i].length; ++j) {
                    this.lstModel.addElement(ds[i][j]);
                }
                continue;
            }
            for (j = 0; j < ds[i].length; ++j) {
                this.lstModel.add(this.getColumnIndex(i + 1), ds[i][j]);
            }
        }
    }

    public void setSelectedColumn(int selectedColumn) {
        if (selectedColumn == 1 || selectedColumn == 2) {
            this.selectedColumn = this.columnName + " " + selectedColumn;
        }
    }

    private void setActionsEnable(boolean b) {
        this.actionMoveDown.setEnabled(b);
        this.actionMoveUp.setEnabled(b);
        this.actionDelete.setEnabled(b);
        this.actionEdit.setEnabled(b);
    }

    private class ColumnListCellRenderer
    extends DefaultListCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        private ColumnListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color bg = null;
            Color fg = null;
            if (isSelected) {
                this.setBackground(bg == null ? list.getSelectionBackground() : bg);
                this.setForeground(fg == null ? list.getSelectionForeground() : fg);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value.getClass().equals(String.class)) {
                this.setForeground(Color.GRAY);
                if (isSelected) {
                    this.setForeground(Color.WHITE);
                }
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                if (value.getClass().equals(String.class)) {
                    this.setText(value == null ? "" : value.toString());
                } else {
                    this.setText(value == null ? "" : "    " + ((IPanelDisplaySettings)value).getPanelName());
                }
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.getNoFocusBorder();
            }
            this.setBorder(border);
            return this;
        }

        private Border getNoFocusBorder() {
            if (System.getSecurityManager() != null) {
                return this.SAFE_NO_FOCUS_BORDER;
            }
            return this.noFocusBorder;
        }
    }

    private class ActionEditPanel
    extends AbstractAction {
        public ActionEditPanel() {
            super(StringResources.EDIT);
        }

        public void actionPerformed(ActionEvent e) {
            IPanelDisplaySettings ds = (IPanelDisplaySettings)AllColumnPanelsPane.this.lstAllColumns.getSelectedValue();
            Window window = SwingUtilities.getWindowAncestor(AllColumnPanelsPane.this);
            EditPanelDialog dialog = new EditPanelDialog((JDialog)window, ControlsUtils.findClosestController(window), ds);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                AllColumnPanelsPane.this.lstAllColumns.repaint();
            }
            dialog.dispose();
        }
    }

    private class ActionDeletePanel
    extends AbstractAction {
        public ActionDeletePanel() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = AllColumnPanelsPane.this.lstAllColumns.getSelectedIndex();
            AllColumnPanelsPane.this.lstModel.remove(selectedIndex);
            if (AllColumnPanelsPane.this.lstModel.getSize() > selectedIndex) {
                AllColumnPanelsPane.this.lstAllColumns.setSelectedIndex(selectedIndex);
            } else if (AllColumnPanelsPane.this.lstModel.getSize() > 0) {
                AllColumnPanelsPane.this.lstAllColumns.setSelectedIndex(AllColumnPanelsPane.this.lstModel.getSize() - 1);
            }
        }
    }

    private class ActionMoveDownPanel
    extends AbstractAction {
        public ActionMoveDownPanel() {
            super(StringResources.MOVE_DOWN);
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = AllColumnPanelsPane.this.lstAllColumns.getSelectedIndex();
            Object elementAt = AllColumnPanelsPane.this.lstAllColumns.getModel().getElementAt(selectedIndex);
            AllColumnPanelsPane.this.lstModel.remove(selectedIndex);
            AllColumnPanelsPane.this.lstModel.insertElementAt(elementAt, selectedIndex + 1);
            AllColumnPanelsPane.this.lstAllColumns.setSelectedIndex(selectedIndex + 1);
        }
    }

    private class ActionMoveUpPanel
    extends AbstractAction {
        public ActionMoveUpPanel() {
            super(StringResources.MOVE_UP);
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = AllColumnPanelsPane.this.lstAllColumns.getSelectedIndex();
            Object elementAt = AllColumnPanelsPane.this.lstAllColumns.getModel().getElementAt(selectedIndex);
            AllColumnPanelsPane.this.lstModel.remove(selectedIndex);
            AllColumnPanelsPane.this.lstModel.insertElementAt(elementAt, selectedIndex - 1);
            AllColumnPanelsPane.this.lstAllColumns.setSelectedIndex(selectedIndex - 1);
        }
    }

    private class ColumnsListSelectionListener
    implements ListSelectionListener {
        private ColumnsListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel selectionModel = AllColumnPanelsPane.this.lstAllColumns.getSelectionModel();
            if (selectionModel.isSelectionEmpty()) {
                AllColumnPanelsPane.this.selectedColumn = AllColumnPanelsPane.this.lstModel.getElementAt(0).toString();
                return;
            }
            if (AllColumnPanelsPane.this.lstModel.getElementAt(selectionModel.getMinSelectionIndex()).getClass().equals(String.class)) {
                AllColumnPanelsPane.this.selectedColumn = AllColumnPanelsPane.this.lstModel.getElementAt(selectionModel.getMinSelectionIndex()).toString();
                AllColumnPanelsPane.this.setActionsEnable(false);
            } else {
                AllColumnPanelsPane.this.setActionsEnable(true);
                if (selectionModel.getMinSelectionIndex() == 1) {
                    AllColumnPanelsPane.this.actionMoveUp.setEnabled(false);
                } else if (selectionModel.getMinSelectionIndex() == AllColumnPanelsPane.this.lstModel.getSize() - 1) {
                    AllColumnPanelsPane.this.actionMoveDown.setEnabled(false);
                }
                for (int i = e.getLastIndex(); i >= 0; --i) {
                    if (!AllColumnPanelsPane.this.lstModel.getElementAt(i).getClass().equals(String.class)) continue;
                    AllColumnPanelsPane.this.selectedColumn = AllColumnPanelsPane.this.lstModel.getElementAt(i).toString();
                    return;
                }
            }
        }
    }
}

