/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class ColorChooserButton
extends OrientableButton {
    private static Logger logger = Logger.getLogger(ColorChooserButton.class);
    private static Color[] colorsData = new Color[]{new Color(0, 0, 0), new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(255, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(150, 150, 150), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 255), new Color(255, 255, 255)};
    public static String COLOR_CHANGE_PROPERTY_NAME = "color change";
    private Color mainColor;
    private int WIDTH = 40;
    private int HEIGHT = 24;
    private JPopupMenu menu = new GWPopupMenu();
    private ColorChooser menuColorChooser;
    private Object invoker;
    private boolean colorChange = false;

    public ColorChooserButton(Color color) {
        this.mainColor = color;
        this.menuColorChooser = new ColorChooser(color);
        this.setPreferredSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.setSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.addActionListener(new ActionShowPopupColorChooser());
        this.menu.add(this.menuColorChooser);
    }

    public void setColor(Color color) {
        this.mainColor = color;
    }

    public void setInvoker(Object theInvoker) {
        this.invoker = theInvoker;
    }

    public Object getInvoker() {
        return this.invoker;
    }

    public void setColorChange(boolean t) {
        this.colorChange = t;
    }

    public boolean isColorChange() {
        return this.colorChange;
    }

    private void showPopup() {
        this.menu.pack();
        if (this.getMousePosition() != null) {
            this.menu.show(this, (int)this.getMousePosition().getX(), (int)this.getMousePosition().getY());
        } else {
            this.menu.show(this, this.getWidth(), this.getHeight());
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isEnabled() && this.mainColor != null) {
            g.setColor(this.mainColor);
            g.fillRect(this.HEIGHT / 6, this.HEIGHT / 6, this.HEIGHT * 2 / 3, this.HEIGHT * 2 / 3);
            g.setColor(Color.BLACK);
            g.fillPolygon(new int[]{this.HEIGHT / 6 + this.HEIGHT * 2 / 3 + this.WIDTH / 8 - 1, this.HEIGHT / 6 + this.HEIGHT * 2 / 3 + 3 * this.WIDTH / 8 + 1, this.HEIGHT / 6 + this.HEIGHT * 2 / 3 + 2 * this.WIDTH / 8}, new int[]{this.HEIGHT / 2 - this.HEIGHT / 7, this.HEIGHT / 2 - this.HEIGHT / 7, this.HEIGHT / 2 + this.HEIGHT / 7}, 3);
        } else {
            g.setColor(Color.GRAY);
            g.fillRect(this.HEIGHT / 6, this.HEIGHT / 6, this.WIDTH - this.HEIGHT / 3, this.HEIGHT * 2 / 3);
        }
    }

    public Color getColor() {
        return this.mainColor;
    }

    public JPopupMenu getColorMenu() {
        return this.menu;
    }

    private class ActionShowPopupColorChooser
    extends AbstractAction {
        private ActionShowPopupColorChooser() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorChooserButton.this.showPopup();
        }
    }

    private class ColorButton
    extends OrientableButton {
        private Color color;
        private int width = 20;
        private int height = 20;
        private int iconWidth = 12;
        private int iconHeight = 12;

        public ColorButton(Color theColor) {
            this.color = theColor;
            this.setPreferredSize(new Dimension(this.width, this.height));
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addActionListener(new colorBtnAction());
            this.setColor(theColor);
        }

        public void setColor(Color theColor) {
            int[] pix = new int[this.iconWidth * this.iconHeight];
            int colorInt = theColor.getRGB();
            int nCount = this.iconWidth * this.iconHeight;
            for (int i = 0; i < nCount; ++i) {
                pix[i] = colorInt;
            }
            ImageIcon myIcon = new ImageIcon(this.createImage(new MemoryImageSource(this.iconWidth, this.iconHeight, pix, 0, this.iconWidth)));
            this.setIcon(myIcon);
            this.color = theColor;
        }

        public Color getColor() {
            return this.color;
        }

        private class colorBtnAction
        extends AbstractAction {
            private colorBtnAction() {
            }

            public void actionPerformed(ActionEvent e) {
                Color oldColor = ColorChooserButton.this.getColor();
                ColorChooserButton.this.setColor(((ColorButton)e.getSource()).getColor());
                ColorChooserButton.this.setColorChange(true);
                ColorChooserButton.this.firePropertyChange(COLOR_CHANGE_PROPERTY_NAME, oldColor, ColorChooserButton.this.getColor());
                ColorChooserButton.this.menu.setVisible(false);
            }
        }
    }

    private class ColorChooser
    extends JPanel {
        private Color currentColor;
        private JPanel btnPanel;

        public ColorChooser(Color theColor) {
            this.currentColor = theColor;
            this.buildUI();
        }

        private void buildUI() {
            JButton noFillBtn = new JButton(StringResources.NO_FILL);
            JButton moreColorsDataBtn = new JButton(StringResources.MORE_COLORS);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)noFillBtn, "North");
            this.fillAllButtonColorsData();
            this.add((Component)this.btnPanel, "Center");
            this.add((Component)moreColorsDataBtn, "South");
            moreColorsDataBtn.addActionListener(new ActionMoreColors());
            noFillBtn.addActionListener(new ActionNoFillColor());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
        }

        private void fillAllButtonColorsData() {
            this.btnPanel = new JPanel(new GridLayout(5, 8, 1, 1));
            int nCount = colorsData.length;
            for (int i = 0; i < nCount; ++i) {
                this.btnPanel.add(new ColorButton(colorsData[i]));
            }
        }

        private class ActionMoreColors
        extends AbstractAction {
            private ActionMoreColors() {
            }

            public void actionPerformed(ActionEvent e) {
                DialogColorChooser cl = new DialogColorChooser(ColorChooserButton.this.getColor());
                if (cl.getColor() != null) {
                    Color oldColor = ColorChooser.this.currentColor;
                    ColorChooser.this.currentColor = cl.getColor();
                    ColorChooserButton.this.setColor(cl.getColor());
                    ColorChooserButton.this.setColorChange(true);
                    ColorChooserButton.this.firePropertyChange(COLOR_CHANGE_PROPERTY_NAME, oldColor, ColorChooserButton.this.getColor());
                }
            }
        }

        private class ActionNoFillColor
        extends AbstractAction {
            private ActionNoFillColor() {
            }

            public void actionPerformed(ActionEvent e) {
                Color oldColor = ColorChooser.this.currentColor;
                ColorChooserButton.this.setColor(null);
                ColorChooserButton.this.menu.setVisible(false);
                ColorChooserButton.this.setColorChange(true);
                ColorChooserButton.this.firePropertyChange(COLOR_CHANGE_PROPERTY_NAME, oldColor, ColorChooserButton.this.getColor());
            }
        }

        class DialogColorChooser
        extends GWDialog {
            private Color selected = null;
            private JColorChooser cc;

            public DialogColorChooser(Color initialColor) {
                if (initialColor == null) {
                    initialColor = Color.BLACK;
                }
                OrientablePanel pnl = new OrientablePanel(new BorderLayout());
                OrientablePanel pnl2 = new OrientablePanel(new GridLayout(1, 2, 5, 5));
                OrientablePanel pnl3 = new OrientablePanel(new BorderLayout());
                this.setContentPane(pnl);
                this.cc = new JColorChooser(initialColor);
                pnl.add((Component)this.cc, "Center");
                pnl2.add(this.btnOK);
                pnl2.add(this.btnCancel);
                pnl3.add((Component)pnl2, "After");
                pnl2 = new OrientablePanel(new BorderLayout(5, 5));
                pnl2.add((Component)pnl3, "South");
                JSeparator sep = new JSeparator(1);
                pnl2.add((Component)sep, "Center");
                pnl.add((Component)pnl2, "South");
                this.pack();
                pnl.setFocusable(true);
                UIUtils.centerWindowOnScreen(this);
                this.setModal(true);
                this.setVisible(true);
            }

            public void disposeDialog() {
                this.dispose();
            }

            public Color getColor() {
                if (this.isActionCompleteSuccessfully()) {
                    this.selected = this.cc.getColor();
                }
                return this.selected;
            }
        }
    }
}

