/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWLabeledSeparator;
import com.novell.gw.jclient.application.controls.RadioButtonGroup;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.panelviews.PanelsManager;
import com.novell.gw.jclient.application.dialogs.folderproperties.AllColumnPanelsPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColumnPanelsPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.CreatePanelTemplateDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.CustomizePanelsDialogController;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsListModel;
import com.novell.gw.jclient.application.dialogs.folderproperties.EditPanelTemplateDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.PanelListCellRenderer;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizePanelsDialog
extends ApplicationDialog<CustomizePanelsDialogController> {
    private static Logger logger = Logger.getLogger(CustomizePanelsDialog.class);
    public static final int ONE_COLUMN_MODE = 1;
    public static final int TWO_COLUMNS_MODE = 2;
    private IFolder folder;
    private JButton btnColumnOneAdd = new OrientableButton(StringResources.ADD);
    private ColumnPanelsPane pnlColumnOne = new ColumnPanelsPane(StringResources.COLUMN_ONE);
    private JButton btnColumnTwoAdd = new OrientableButton(StringResources.ADD);
    private ColumnPanelsPane pnlColumnTwo = new ColumnPanelsPane(StringResources.COLUMN_TWO);
    private AllColumnPanelsPane pnlAllColumns = new AllColumnPanelsPane(StringResources.ALL_COLUMNS, StringResources.COLUMN);
    private OrientablePanel pnlColumns = new OrientablePanel(new BorderLayout());
    private int columnsToShow = 0;
    private DisplaySettingsListModel listModel = new DisplaySettingsListModel();
    private JList lstAvailablePanels = new OrientableList((ListModel)this.listModel);
    private JButton btnRestoreDefaults;
    private OrientableRadioButton rbOneColumn = new OrientableRadioButton(StringResources.ONE_COLUMN);
    private OrientableRadioButton rbTwoColumn = new OrientableRadioButton(StringResources.TWO_COLUMNS);
    private OrientableRadioButton rbAllColumns = new OrientableRadioButton(StringResources.THREE_OR_MORE_COLUMNS);
    private OrientableSpinner spnColumnsCount;
    private ActionEditPanelTemplate actionEditPanelTemplate = new ActionEditPanelTemplate();
    private ActionDeletePanelTemplate actionDeletePanelTemplate = new ActionDeletePanelTemplate();
    private boolean saveChanges;
    private IPanelDisplaySettings selectedTemplate;
    private IFolderDisplaySettings folderDisplaySettings;
    private PanelsManager panelsManager;

    public CustomizePanelsDialog(JDialog window, MVCController parentController, IFolder folder, IFolderDisplaySettings folderDisplaySettings, boolean saveChangesOnOkButton) {
        super((Dialog)window, parentController);
        this.init(folder, folderDisplaySettings, saveChangesOnOkButton);
    }

    public CustomizePanelsDialog(JFrame window, MVCController parentController, IFolder folder, IFolderDisplaySettings folderDisplaySettings, boolean saveChangesOnOkButton) {
        super((Frame)window, parentController);
        this.init(folder, folderDisplaySettings, saveChangesOnOkButton);
    }

    private void init(IFolder folder, IFolderDisplaySettings folderDisplaySettings, boolean saveChangesOnOkButton) {
        this.folder = folder;
        this.folderDisplaySettings = folderDisplaySettings;
        this.saveChanges = saveChangesOnOkButton;
        this.panelsManager = PanelsManager.getInstance(folderDisplaySettings);
        int mode = folderDisplaySettings.getPanelColumnCount();
        this.setTitle(StringResources.CUSTOMIZE_PANELS);
        this.buildComponents();
        this.layoutComponents();
        this.showColumns(2);
        this.pack();
        if (mode == 1) {
            this.showColumns(1);
            this.rbOneColumn.setSelected(true);
        } else if (mode == 2) {
            this.showColumns(2);
            this.rbTwoColumn.setSelected(true);
        } else if (mode > 2) {
            this.rbAllColumns.setSelected(true);
            this.spnColumnsCount.setValue(mode);
            this.setColumns(mode);
            this.showColumns(mode);
        } else {
            this.showColumns(1);
        }
        this.listModel.setSelectionModel(this.lstAvailablePanels.getSelectionModel());
        this.fillPanelsLists();
    }

    public static boolean show(Window window, MVCController parentController, IFolder folder, IFolderDisplaySettings folderDisplaySettings, boolean saveChangesOnOkButton) {
        CustomizePanelsDialog dialog = window instanceof JDialog ? new CustomizePanelsDialog((JDialog)window, parentController, folder, folderDisplaySettings, saveChangesOnOkButton) : new CustomizePanelsDialog((JFrame)window, parentController, folder, folderDisplaySettings, saveChangesOnOkButton);
        dialog.showMe();
        return dialog.isOkActionProcessed();
    }

    public void showMe() {
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public IFolder getFolder() {
        return this.folder;
    }

    void updateAvailablePanelList() {
        IDataStore currentDataStore = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        ArrayList<IPanelDisplaySettings> loadedDisplaySettings = new ArrayList<IPanelDisplaySettings>();
        int count = currentDataStore.getPanelTemplateSettingsCount();
        logger.debug((Object)("found " + count + " panel template(s)"));
        for (int i = 0; i < count; ++i) {
            loadedDisplaySettings.add(currentDataStore.getPanelTemplateSettings(i));
        }
        this.listModel.updateAllElements(loadedDisplaySettings, true);
    }

    void selectPanelTemplate(int displaySettingsId) {
        this.lstAvailablePanels.setSelectedValue(this.listModel.getElementById(displaySettingsId), true);
    }

    private void fillPanelsLists() {
        this.updateAvailablePanelList();
        this.pnlAllColumns.removeAllPanels();
        this.pnlColumnOne.removeAllPanels();
        this.pnlColumnTwo.removeAllPanels();
        if (this.columnsToShow == 1) {
            for (IPanelDisplaySettings settings : this.panelsManager.getPanelsForColumn(0)) {
                this.pnlColumnOne.addPanel(settings);
            }
        } else if (this.columnsToShow == 2) {
            for (IPanelDisplaySettings settings : this.panelsManager.getPanelsForColumn(0)) {
                this.pnlColumnOne.addPanel(settings);
            }
            for (IPanelDisplaySettings settings : this.panelsManager.getPanelsForColumn(1)) {
                this.pnlColumnTwo.addPanel(settings);
            }
            this.pnlColumnTwo.addNeighborPanelList(this.pnlColumnOne.getList(), false);
            this.pnlColumnOne.addNeighborPanelList(this.pnlColumnTwo.getList(), true);
        } else {
            int nCount = this.folderDisplaySettings.getPanelColumnCount();
            for (int i = 0; i < nCount; ++i) {
                for (IPanelDisplaySettings settings : this.panelsManager.getPanelsForColumn(i)) {
                    IDataStore dataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this)).getCurrentDataStore();
                    IPanelDisplaySettings newPanel = APIWrapperManager.createPanelDisplaySettings(dataStore, settings);
                    this.pnlAllColumns.addPanel(newPanel, i);
                }
            }
        }
    }

    private void buildComponents() {
        this.lstAvailablePanels.addMouseListener(new AddPanelMouseListener());
        this.lstAvailablePanels.addListSelectionListener(new TemplateListSelectionListener());
        this.lstAvailablePanels.setSelectionMode(0);
        this.lstAvailablePanels.setCellRenderer(new PanelListCellRenderer());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        RadioButtonGroup buttonGroup = new RadioButtonGroup(this);
        buttonGroup.add(this.rbOneColumn);
        buttonGroup.add(this.rbTwoColumn);
        buttonGroup.add(this.rbAllColumns);
        this.rbTwoColumn.setSelected(true);
        ShowColumnListener showColumnListener = new ShowColumnListener();
        this.rbOneColumn.addItemListener(showColumnListener);
        this.rbTwoColumn.addItemListener(showColumnListener);
        this.rbAllColumns.addItemListener(showColumnListener);
        this.btnColumnOneAdd.addActionListener(new AddActionListener());
        this.btnColumnTwoAdd.addActionListener(new AddActionListener());
        this.btnColumnOneAdd.setEnabled(false);
        this.btnColumnTwoAdd.setEnabled(false);
        this.spnColumnsCount = new OrientableSpinner(new SpinnerNumberModel(3, 3, 30, 1));
        this.spnColumnsCount.addChangeListener(new ChangeColumnCountAction());
        this.btnRestoreDefaults = new OrientableButton(new ActionRestoreDefaults());
    }

    private void layoutComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        OrientablePanel pnlAvalailable = new OrientablePanel(new GridBagLayout());
        OrientablePanel pnlModify = new OrientablePanel(new GridLayout());
        OrientablePanel pnlColumn = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        contentPane.add((Component)new GWLabeledSeparator(StringResources.CHOOSE_LAYOUT), constraints);
        OrientablePanel pnlRadioButtons = new OrientablePanel(new BorderLayout());
        pnlRadioButtons.add((Component)CustomizePanelsDialog.createImageComponent(ImageResources.IMG_ONE_COLUMN, this.rbOneColumn), "Before");
        pnlRadioButtons.add((Component)CustomizePanelsDialog.createImageComponent(ImageResources.IMG_TWO_COLUMN, this.rbTwoColumn), "Center");
        pnlRadioButtons.add((Component)this.createSpinnerComponent(ImageResources.IMG_THREE_COLUMN, this.rbAllColumns), "After");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(20, 20, 20, 20);
        contentPane.add((Component)pnlRadioButtons, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        contentPane.add((Component)new GWLabeledSeparator(StringResources.MODIFY_PANELS), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 25;
        constraints.insets = CustomizePanelsDialog.getPanelListCaptionInsets();
        pnlAvalailable.add((Component)new OrientableLabel(StringResources.AVAILABLE_PANELS), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 10);
        pnlAvalailable.add((Component)this.createModifyPanelsButtonsPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        pnlAvalailable.add((Component)new OrientableScrollPane(this.lstAvailablePanels), constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        pnlModify.add(pnlAvalailable);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 10, 0, 10);
        pnlAvalailable.add((Component)this.btnColumnOneAdd, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        pnlColumn.add((Component)this.pnlColumns, constraints);
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 20;
        constraints.insets = new Insets(0, 10, 0, 10);
        pnlAvalailable.add((Component)this.btnColumnTwoAdd, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        pnlModify.add((Component)pnlColumn, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        contentPane.add((Component)pnlModify, constraints);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        pnlAvalailable.add((Component)this.btnRestoreDefaults, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 26;
        constraints.insets = new Insets(10, 0, 0, 0);
        pnlColumn.add((Component)this.createOkCancelButtonsPanel(), constraints);
    }

    public static Insets getPanelListCaptionInsets() {
        return new Insets(10, 0, 2, 0);
    }

    private static JComponent createImageComponent(ImageIcon theImage, JComponent theCheckBox) {
        OrientablePanel result = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.gridx = 0;
        result.add((Component)new OrientableLabel(theImage), constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 5, 0, 0);
        result.add((Component)theCheckBox, constraints);
        return result;
    }

    private JComponent createSpinnerComponent(ImageIcon theImage, JComponent theCheckBox) {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.anchor = 21;
        constraints.fill = 0;
        pnl.add((Component)new OrientableLabel(theImage), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 21;
        constraints.fill = 0;
        pnl.add((Component)theCheckBox, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 0);
        pnl.add((Component)this.spnColumnsCount, constraints);
        return pnl;
    }

    private JComponent createModifyPanelsButtonsPanel() {
        OrientablePanel result = new OrientablePanel(new GridLayout(3, 1, 0, 5));
        OrientableButton btnNewPanel = new OrientableButton(new ActionCreatePanelTemplate());
        result.add(btnNewPanel);
        OrientableButton btnEditPanel = new OrientableButton(this.actionEditPanelTemplate);
        this.actionEditPanelTemplate.setEnabled(false);
        result.add(btnEditPanel);
        OrientableButton btnDeletePanel = new OrientableButton(this.actionDeletePanelTemplate);
        this.actionDeletePanelTemplate.setEnabled(false);
        result.add(btnDeletePanel);
        return result;
    }

    private void setColumns(int count) {
        block3: {
            block2: {
                if (count <= this.columnsToShow) break block2;
                for (int i = this.columnsToShow; i < count + 1; ++i) {
                    this.pnlAllColumns.setColumnCount(i);
                    this.showColumns(i);
                }
                break block3;
            }
            if (count >= this.columnsToShow) break block3;
            for (int i = this.columnsToShow; i > count - 1; --i) {
                this.pnlAllColumns.setColumnCount(i);
                this.showColumns(i);
            }
        }
    }

    public void showColumns(int value) {
        this.fillDisplaySettings(value);
        this.columnsToShow = value;
        this.pnlColumns.removeAll();
        if (this.columnsToShow == 1) {
            this.pnlColumns.add(this.pnlColumnOne);
            this.rbOneColumn.setSelected(true);
            this.btnColumnTwoAdd.setVisible(false);
            this.spnColumnsCount.setEnabled(false);
        } else if (this.columnsToShow == 2) {
            this.pnlColumns.setLayout(new GridLayout(0, 1));
            this.pnlColumns.add(this.pnlColumnOne);
            this.pnlColumns.add(this.pnlColumnTwo);
            this.rbTwoColumn.setSelected(true);
            this.btnColumnTwoAdd.setVisible(true);
            this.spnColumnsCount.setEnabled(false);
        } else {
            this.pnlColumns.add(this.pnlAllColumns);
            this.rbAllColumns.setSelected(true);
            this.btnColumnTwoAdd.setVisible(false);
            this.spnColumnsCount.setEnabled(true);
        }
        this.validate();
        this.repaint();
    }

    private void fillDisplaySettings(int newMode) {
        if (newMode == 1 && this.columnsToShow == 2) {
            int nCount = this.pnlColumnTwo.getPanelCount();
            for (int i = 0; i < nCount; ++i) {
                this.pnlColumnOne.addPanel(this.pnlColumnTwo.getPanels()[i]);
            }
            this.pnlColumnTwo.removeAllPanels();
        } else if (newMode == 1 && this.columnsToShow > 2) {
            this.pnlColumnOne.removeAllPanels();
            int nCount = this.pnlAllColumns.getColumnCount();
            for (int i = 0; i < nCount; ++i) {
                for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(i)) {
                    this.pnlColumnOne.addPanel(ds);
                }
            }
        } else if (newMode != 2 || this.columnsToShow != 1) {
            if (newMode == 2 && this.columnsToShow > 2) {
                this.pnlColumnOne.removeAllPanels();
                this.pnlColumnTwo.removeAllPanels();
                for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(0)) {
                    this.pnlColumnOne.addPanel(ds);
                }
                int nCount = this.pnlAllColumns.getColumnCount();
                for (int i = 1; i < nCount; ++i) {
                    for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(i)) {
                        this.pnlColumnTwo.addPanel(ds);
                    }
                }
            } else if (newMode > 2 && this.columnsToShow == 1) {
                int i;
                int nCount = this.pnlAllColumns.getColumnCount();
                for (i = 0; i < nCount; ++i) {
                    for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(i)) {
                        boolean b = false;
                        int nCount2 = this.pnlColumnOne.getPanelCount();
                        for (int j = 0; j < nCount2; ++j) {
                            if (!this.pnlColumnOne.getPanels()[j].equals(ds)) continue;
                            b = true;
                            break;
                        }
                        if (b) continue;
                        this.pnlAllColumns.removePanel(ds);
                    }
                }
                nCount = this.pnlColumnOne.getPanelCount();
                for (i = 0; i < nCount; ++i) {
                    boolean b = true;
                    int nCount2 = this.pnlAllColumns.getColumnCount();
                    block10: for (int j = 0; j < nCount2; ++j) {
                        for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(j)) {
                            if (!this.pnlColumnOne.getPanels()[i].equals(ds)) continue;
                            b = false;
                            continue block10;
                        }
                    }
                    if (!b) continue;
                    this.pnlAllColumns.addPanel(this.pnlColumnOne.getPanels()[i]);
                }
            } else if (newMode > 2 && this.columnsToShow == 2) {
                int j;
                int nCount2;
                int i;
                int nCount = this.pnlAllColumns.getColumnCount();
                for (i = 0; i < nCount; ++i) {
                    for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(i)) {
                        boolean b = true;
                        int nCount22 = this.pnlColumnOne.getPanelCount();
                        for (int j2 = 0; j2 < nCount22; ++j2) {
                            if (!this.pnlColumnOne.getPanels()[j2].equals(ds)) continue;
                            b = false;
                            break;
                        }
                        int nCount3 = this.pnlColumnTwo.getPanelCount();
                        for (int j3 = 0; j3 < nCount3; ++j3) {
                            if (!this.pnlColumnTwo.getPanels()[j3].equals(ds)) continue;
                            b = false;
                            break;
                        }
                        if (!b) continue;
                        this.pnlAllColumns.removePanel(ds);
                    }
                }
                nCount = this.pnlColumnOne.getPanelCount();
                for (i = 0; i < nCount; ++i) {
                    boolean b = true;
                    nCount2 = this.pnlAllColumns.getColumnCount();
                    block17: for (j = 0; j < nCount2; ++j) {
                        for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(j)) {
                            if (!this.pnlColumnOne.getPanels()[i].equals(ds)) continue;
                            b = false;
                            continue block17;
                        }
                    }
                    if (!b) continue;
                    this.pnlAllColumns.setSelectedColumn(1);
                    this.pnlAllColumns.addPanel(this.pnlColumnOne.getPanels()[i], 0);
                }
                nCount = this.pnlColumnTwo.getPanelCount();
                for (i = 0; i < nCount; ++i) {
                    boolean b = true;
                    nCount2 = this.pnlAllColumns.getColumnCount();
                    block20: for (j = 0; j < nCount2; ++j) {
                        for (IPanelDisplaySettings ds : this.pnlAllColumns.getPanels(j)) {
                            if (!this.pnlColumnTwo.getPanels()[i].equals(ds)) continue;
                            b = false;
                            continue block20;
                        }
                    }
                    if (!b) continue;
                    this.pnlAllColumns.setSelectedColumn(2);
                    this.pnlAllColumns.addPanel(this.pnlColumnTwo.getPanels()[i], 1);
                }
                this.pnlColumnTwo.removeAllPanels();
            }
        }
    }

    @Override
    protected CustomizePanelsDialogController createController(MVCController parentController) {
        return new CustomizePanelsDialogController(this, parentController);
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        IPanelDisplaySettings[][] ds = new IPanelDisplaySettings[][]{};
        if (1 == this.columnsToShow) {
            ds = new IPanelDisplaySettings[][]{this.pnlColumnOne.getPanels()};
        } else if (2 == this.columnsToShow) {
            ds = new IPanelDisplaySettings[][]{this.pnlColumnOne.getPanels(), this.pnlColumnTwo.getPanels()};
        } else if (2 < this.columnsToShow) {
            ds = new IPanelDisplaySettings[this.pnlAllColumns.getColumnCount()][];
            int nCount = this.pnlAllColumns.getColumnCount();
            for (int i = 0; i < nCount; ++i) {
                ds[i] = this.pnlAllColumns.getPanels(i);
                if (ds[i].length == 0) continue;
                ds[i][0].setPanelWidth(1);
            }
        }
        IPanelDisplaySettings[][] arr$ = ds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IPanelDisplaySettings[] d1;
            for (IPanelDisplaySettings aD1 : d1 = arr$[i$]) {
                aD1.setPanelWidth(1);
                aD1.setPanelHeight(1);
            }
        }
        boolean b = false;
        for (IPanelDisplaySettings[] d : ds) {
            if (d.length != 0) continue;
            b = true;
            break;
        }
        if (b) {
            JOptionPane.showMessageDialog(this, StringResources.YOU_NEED_AT_LEAST_ONE_PANEL_IN_EACH_COLUMN, null, 1);
            return;
        }
        if (this.saveChanges) {
            this.panelsManager.setPanels(ds);
        }
        super.processOkAction(event);
    }

    private void handleListSelectionChange() {
        boolean enableButtons = false;
        if (this.lstAvailablePanels.getModel().getSize() != 0 && !this.lstAvailablePanels.isSelectionEmpty()) {
            enableButtons = true;
            this.selectedTemplate = (IPanelDisplaySettings)this.lstAvailablePanels.getSelectedValue();
        }
        this.actionDeletePanelTemplate.setEnabled(enableButtons);
        this.actionEditPanelTemplate.setEnabled(enableButtons);
        this.btnColumnOneAdd.setEnabled(enableButtons);
        this.btnColumnTwoAdd.setEnabled(enableButtons);
    }

    private class TemplateListSelectionListener
    implements ListSelectionListener {
        private TemplateListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            CustomizePanelsDialog.this.handleListSelectionChange();
        }
    }

    private class ActionRestoreDefaults
    extends AbstractAction {
        public ActionRestoreDefaults() {
            super(StringResources.RESTORE_DEFAULTS);
        }

        public void actionPerformed(ActionEvent e) {
            IDataStore currentDataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(CustomizePanelsDialog.this)).getCurrentDataStore();
            APIWrapperManager.createPanelDisplaySettings(currentDataStore).createPanelTemplateDisplaySettings();
            ((CustomizePanelsDialogController)CustomizePanelsDialog.this.getController()).processCommand(new GlobalCommand(1610));
        }
    }

    private class ActionEditPanelTemplate
    extends AbstractAction {
        public ActionEditPanelTemplate() {
            super(StringResources.EDIT_PANEL_D);
        }

        public void actionPerformed(ActionEvent e) {
            EditPanelTemplateDialog dialog = new EditPanelTemplateDialog(CustomizePanelsDialog.this, (MVCController)CustomizePanelsDialog.this.getController(), CustomizePanelsDialog.this.selectedTemplate);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    private class ActionDeletePanelTemplate
    extends AbstractAction {
        public ActionDeletePanelTemplate() {
            super(StringResources.DELETE_PANEL);
        }

        public void actionPerformed(ActionEvent e) {
            int id = CustomizePanelsDialog.this.selectedTemplate.getId();
            boolean result = CustomizePanelsDialog.this.selectedTemplate.deleteSettings();
            if (result) {
                ((CustomizePanelsDialogController)CustomizePanelsDialog.this.getController()).processCommand(new GlobalCommand(1600, id));
            }
        }
    }

    private class ActionCreatePanelTemplate
    extends AbstractAction {
        public ActionCreatePanelTemplate() {
            super(StringResources.NEW_PANEL_D);
        }

        public void actionPerformed(ActionEvent e) {
            CustomizePanelsDialog parent = CustomizePanelsDialog.this;
            AbstractFolder abstractFolder = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(parent)).getGWFolder(CustomizePanelsDialog.this.folder);
            CreatePanelTemplateDialog dialog = new CreatePanelTemplateDialog(parent, (MVCController)CustomizePanelsDialog.this.getController(), abstractFolder);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    private class AddPanelMouseListener
    extends MouseAdapter {
        private AddPanelMouseListener() {
        }

        private void addNewPanel(IPanelDisplaySettings panelDisplaySettings) {
            if (panelDisplaySettings != null) {
                IDataStore dataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(CustomizePanelsDialog.this)).getCurrentDataStore();
                IPanelDisplaySettings newPanel = APIWrapperManager.createPanelDisplaySettings(dataStore, panelDisplaySettings);
                if (CustomizePanelsDialog.this.columnsToShow > 2) {
                    CustomizePanelsDialog.this.pnlAllColumns.addPanel(newPanel);
                } else {
                    CustomizePanelsDialog.this.pnlColumnOne.addPanel(newPanel);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            JList list;
            int index;
            super.mouseClicked(e);
            if (OS.isDoubleClick(e) && (index = (list = CustomizePanelsDialog.this.lstAvailablePanels).locationToIndex(e.getPoint())) >= 0) {
                this.addNewPanel((IPanelDisplaySettings)list.getModel().getElementAt(index));
            }
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            IDataStore dataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(CustomizePanelsDialog.this)).getCurrentDataStore();
            IPanelDisplaySettings newPanel = APIWrapperManager.createPanelDisplaySettings(dataStore, (IPanelDisplaySettings)CustomizePanelsDialog.this.lstAvailablePanels.getSelectedValue());
            if (CustomizePanelsDialog.this.columnsToShow > 2) {
                CustomizePanelsDialog.this.pnlAllColumns.addPanel(newPanel);
            } else if (e.getSource() == CustomizePanelsDialog.this.btnColumnOneAdd) {
                CustomizePanelsDialog.this.pnlColumnOne.addPanel(newPanel);
            } else if (e.getSource() == CustomizePanelsDialog.this.btnColumnTwoAdd) {
                CustomizePanelsDialog.this.pnlColumnTwo.addPanel(newPanel);
            }
        }
    }

    private class ShowColumnListener
    implements ItemListener {
        private ShowColumnListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            if (e.getSource() == CustomizePanelsDialog.this.rbOneColumn) {
                CustomizePanelsDialog.this.showColumns(1);
                CustomizePanelsDialog.this.pnlColumnTwo.addNeighborPanelList(null, false);
                CustomizePanelsDialog.this.pnlColumnOne.addNeighborPanelList(null, false);
            } else if (e.getSource() == CustomizePanelsDialog.this.rbTwoColumn) {
                CustomizePanelsDialog.this.showColumns(2);
                CustomizePanelsDialog.this.pnlColumnTwo.addNeighborPanelList(CustomizePanelsDialog.this.pnlColumnOne.getList(), false);
                CustomizePanelsDialog.this.pnlColumnOne.addNeighborPanelList(CustomizePanelsDialog.this.pnlColumnTwo.getList(), true);
            } else if (e.getSource() == CustomizePanelsDialog.this.rbAllColumns) {
                CustomizePanelsDialog.this.showColumns((Integer)CustomizePanelsDialog.this.spnColumnsCount.getValue());
                CustomizePanelsDialog.this.pnlColumnTwo.addNeighborPanelList(null, false);
                CustomizePanelsDialog.this.pnlColumnOne.addNeighborPanelList(null, false);
            }
        }
    }

    private class ChangeColumnCountAction
    implements ChangeListener {
        private ChangeColumnCountAction() {
        }

        public void stateChanged(ChangeEvent e) {
            CustomizePanelsDialog.this.setColumns((Integer)CustomizePanelsDialog.this.spnColumnsCount.getValue());
        }
    }
}

