/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsPanelNameIgnoreCaseComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplaySettingsListModel
extends AbstractListModel
implements ListSelectionListener {
    private static Logger logger = Logger.getLogger(DisplaySettingsListModel.class);
    private List<IPanelDisplaySettings> nameSortedList = new ArrayList<IPanelDisplaySettings>();
    private DisplaySettingsPanelNameIgnoreCaseComparator nameComparator = new DisplaySettingsPanelNameIgnoreCaseComparator();
    private ListSelectionModel selectionModel = null;
    private SelectionId selectionId = new SelectionId();
    private boolean ignoreSelectionEvent = false;

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this);
        } else if (selectionModel != null) {
            selectionModel.addListSelectionListener(this);
        }
        this.selectionModel = selectionModel;
    }

    @Override
    public int getSize() {
        return this.nameSortedList.size();
    }

    @Override
    public IPanelDisplaySettings getElementAt(int index) {
        return this.nameSortedList.get(index);
    }

    public void removeAllElements() {
        int size = this.nameSortedList.size();
        if (size > 0) {
            this.nameSortedList.clear();
            this.fireIntervalRemoved(this, 0, --size);
        }
    }

    public void updateAllElements(Collection<IPanelDisplaySettings> elements, boolean keepSelection) {
        this.ignoreSelectionEvent = true;
        this.removeAllElements();
        if (elements.size() > 0) {
            this.nameSortedList.addAll(elements);
            Collections.sort(this.nameSortedList, this.nameComparator);
            this.fireIntervalAdded(this, 0, this.nameSortedList.size() - 1);
            if (keepSelection) {
                if (this.selectionModel == null) {
                    throw new IllegalStateException("selectionModel is null");
                }
                this.selectionId.makeSelection();
            }
        }
        this.ignoreSelectionEvent = false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.ignoreSelectionEvent) {
            return;
        }
        assert (this.selectionModel != null) : "selectionModel is null";
        this.selectionId.saveSelection();
    }

    public IPanelDisplaySettings getElementById(int id) {
        for (IPanelDisplaySettings displaySettings : this.nameSortedList) {
            if (displaySettings.getId() != id) continue;
            return displaySettings;
        }
        logger.debug((Object)("element with ID " + id + " was not found"));
        return null;
    }

    private class SelectionId {
        private static final int UNDEFINED = -1;
        int current = -1;
        int next = -1;

        private SelectionId() {
        }

        void saveSelection() {
            int selectedIndex = DisplaySettingsListModel.this.selectionModel.getMaxSelectionIndex();
            logger.debug((Object)("index: " + selectedIndex));
            if (selectedIndex == -1) {
                this.current = -1;
                this.next = -1;
                return;
            }
            IPanelDisplaySettings displaySettings = (IPanelDisplaySettings)DisplaySettingsListModel.this.nameSortedList.get(selectedIndex);
            assert (displaySettings != null) : "displaySettings (selected element) is null";
            this.current = displaySettings.getId();
            this.next = DisplaySettingsListModel.this.nameSortedList.isEmpty() || DisplaySettingsListModel.this.nameSortedList.size() == 1 ? -1 : (selectedIndex == DisplaySettingsListModel.this.nameSortedList.size() - 1 ? ((IPanelDisplaySettings)DisplaySettingsListModel.this.nameSortedList.get(selectedIndex - 1)).getId() : ((IPanelDisplaySettings)DisplaySettingsListModel.this.nameSortedList.get(selectedIndex + 1)).getId());
            logger.debug((Object)("current: " + this.current + ", next: " + this.next));
        }

        void makeSelection() {
            int index;
            assert (DisplaySettingsListModel.this.selectionModel != null) : "selectionModel is null";
            if (DisplaySettingsListModel.this.nameSortedList.isEmpty()) {
                logger.debug((Object)"list is empty > skipping selection");
                return;
            }
            if (this.isUndefined()) {
                logger.debug((Object)"undefined state > selecting first element");
                index = 0;
            } else {
                assert (this.current != -1) : "current id is undefined";
                IPanelDisplaySettings displaySettings = DisplaySettingsListModel.this.getElementById(this.current);
                if (displaySettings == null) {
                    logger.debug((Object)"current element not found, probably deleted > selecting next");
                    if (this.next == -1) {
                        index = 0;
                    } else {
                        displaySettings = DisplaySettingsListModel.this.getElementById(this.next);
                        if (displaySettings == null) {
                            logger.warn((Object)"next not found!");
                            index = 0;
                        } else {
                            index = DisplaySettingsListModel.this.nameSortedList.indexOf(displaySettings);
                        }
                    }
                } else {
                    index = DisplaySettingsListModel.this.nameSortedList.indexOf(displaySettings);
                }
            }
            logger.debug((Object)("index: " + index));
            DisplaySettingsListModel.this.selectionModel.setSelectionInterval(index, index);
            this.saveSelection();
        }

        boolean isUndefined() {
            return this.current == -1 && this.next == -1;
        }
    }
}

