/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyManager;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DisplaySettingsSaveAsDialog
extends OkCancelDialog
implements GWPropertyChangeListener {
    private final String name;
    private final String description;
    private JTextArea taDescription = new GWTextArea(3, 10);
    private JTextField tfName = new GWTextField();

    public DisplaySettingsSaveAsDialog(Dialog owner, String name, String description) {
        super(owner);
        this.name = name;
        this.description = description;
        this.init();
        this.buildUI();
    }

    public DisplaySettingsSaveAsDialog(Frame owner, String name, String description) {
        super(owner);
        this.name = name;
        this.description = description;
        this.init();
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DISPLAY_SETTINGS_SAVE_AS);
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.fill = 2;
        panel.add((Component)new OrientableLabel(StringResources.DISPLAY_SETTINGS_NAME), constraints);
        ++constraints.gridy;
        panel.add((Component)this.tfName, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)new OrientableLabel(StringResources.DISPLAY_SETTINGS_DESCRIPTION), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.top = 0;
        panel.add((Component)new OrientableScrollPane(this.taDescription), constraints);
        this.add((Component)panel, "Center");
        this.add((Component)this.createOkCancelButtonsPanel(), "Last");
        this.pack();
    }

    private void init() {
        PropertyManager propertyManager = new PropertyManager();
        propertyManager.addPropertyView(this.tfName);
        propertyManager.addGWPropertyChangeListener(this);
        this.tfName.setText(this.name);
        this.taDescription.setText(this.description);
        propertyManager.readInitialProperties();
    }

    public String getDisplaySettingsName() {
        return this.tfName.getText();
    }

    public String getDisplaySettingsDescription() {
        return this.taDescription.getText();
    }

    public void propertyChanged(GWPropertyChangeEvent event) {
        if (event.getPropertyManager().hasChangedProperties()) {
            if (this.taDescription.getText().equals(this.description)) {
                this.taDescription.setText("");
            }
        } else if ("".equals(this.taDescription.getText())) {
            this.taDescription.setText(this.description);
        }
    }
}

