/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractListModel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ParticipantsPane
extends OrientablePanel {
    private GWTextField tfSubject = new GWTextField();
    private OrientableTextArea taMessage = new GWTextArea();
    private OrientableList listParticipanceUI = new OrientableList();
    private DistributionList participants;

    public ParticipantsPane(String thePatricipantsLabelText) {
        this.buildUI(thePatricipantsLabelText);
        this.listParticipanceUI.setModel(new AbstractListModel(){

            public int getSize() {
                int size = 0;
                if (ParticipantsPane.this.participants != null) {
                    size = ParticipantsPane.this.participants.getSize();
                }
                return size;
            }

            public Object getElementAt(int index) {
                String value = null;
                if (ParticipantsPane.this.participants != null && ParticipantsPane.this.participants.getSize() > 0) {
                    value = ParticipantsPane.this.participants.getRecipient(index).getAddressable().getUserName();
                }
                return value;
            }
        });
    }

    public ParticipantsPane(String thePatricipantsLabelText, String theSubject) {
        this(thePatricipantsLabelText);
        this.setSubject(theSubject);
    }

    private void buildUI(String patricipantsLabelText) {
        this.setLayout(new BorderLayout(0, 10));
        GWTextArea mainText = new GWTextArea();
        OrientablePanel pnlDown = new OrientablePanel(new GridBagLayout());
        mainText.setOpaque(false);
        mainText.setEditable(false);
        mainText.setText(patricipantsLabelText);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)mainText, "North");
        this.add((Component)pnlDown, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        OrientableLabel lbl = new OrientableLabel(StringResources.PARTICIPANTS);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        pnlDown.add((Component)lbl, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 3;
        gbc.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(this.listParticipanceUI);
        pnlDown.add((Component)scroll, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 10, 10, 0);
        lbl = new OrientableLabel(StringResources.SUBJECT_C);
        pnlDown.add((Component)lbl, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 10, 0);
        pnlDown.add((Component)this.tfSubject, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 10, 0, 0);
        lbl = new OrientableLabel(StringResources.MESSAGE_C);
        pnlDown.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        scroll = new JScrollPane(this.taMessage);
        pnlDown.add((Component)scroll, gbc);
        this.listParticipanceUI.setPreferredSize(new Dimension(200, 150));
        this.taMessage.setPreferredSize(new Dimension(250, 150));
    }

    private void onParticipantsChanged() {
        if (this.participants != null) {
            this.listParticipanceUI.repaint();
        }
    }

    public void setParticipants(DistributionList aParticipantsList) {
        if (this.participants != aParticipantsList) {
            this.participants = aParticipantsList;
            this.onParticipantsChanged();
        }
    }

    public String getMessage() {
        return this.taMessage.getText();
    }

    public void setMessage(String aMessage) {
        this.taMessage.setText(aMessage);
    }

    public String getSubject() {
        return this.tfSubject.getText();
    }

    public void setSubject(String aSubject) {
        this.tfSubject.setText(aSubject);
    }
}

