/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.AdvancedViewByTableMode;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AdvancedViewByDetails_Contacts
extends AdvancedViewByTableMode {
    private JCheckBox cbPerson = new OrientableCheckBox(StringResources.PERSONAL);
    private JCheckBox cbGroup = new OrientableCheckBox(StringResources.GROUP);
    private JCheckBox cbResource = new OrientableCheckBox(StringResources.RESOURCE);
    private JCheckBox cbOrganization = new OrientableCheckBox(StringResources.ORGANIZATION);

    protected AdvancedViewByDetails_Contacts(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        this.propertyManager.addPropertyView(this.cbPerson);
        this.propertyManager.addPropertyView(this.cbGroup);
        this.propertyManager.addPropertyView(this.cbResource);
        this.propertyManager.addPropertyView(this.cbOrganization);
    }

    public boolean loadProperties() {
        int contactType = this.folderDisplaySettings.getContactType();
        this.cbPerson.setSelected((contactType & 1) == 1);
        this.cbGroup.setSelected((contactType & 2) == 2);
        this.cbResource.setSelected((contactType & 4) == 4);
        this.cbOrganization.setSelected((contactType & 8) == 8);
        return super.loadProperties();
    }

    public boolean saveProperties() {
        boolean result = super.saveProperties();
        int contactType = 0;
        contactType = this.cbPerson.isSelected() ? contactType | 1 : contactType;
        contactType = this.cbResource.isSelected() ? contactType | 4 : contactType;
        contactType = this.cbGroup.isSelected() ? contactType | 2 : contactType;
        contactType = this.cbOrganization.isSelected() ? contactType | 8 : contactType;
        result = result && this.folderDisplaySettings.setContactType(contactType);
        return result;
    }

    public JPanel getRightPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 5;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)AdvancedViewByDetails_Contacts.createLabelWithSeparator(StringResources.CHOOSE_CONTACT_TYPE_C), constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)AdvancedViewByDetails_Contacts.createCheckBoxesPanel(new JCheckBox[][]{{this.cbPerson, this.cbGroup}, {this.cbResource, this.cbOrganization}}), constraints);
        return panel;
    }

    public JPanel getLeftPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        panel.add((Component)new OrientableLabel(StringResources.SORT_BY_C), constraints);
        ++constraints.gridy;
        panel.add((Component)this.cmbSortBy, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)new OrientableLabel(StringResources.SORT_ORDER_C), constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.cmbSortOrder, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.cbShowGroupLabels, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.rbSummary, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.rbColumns, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.top = 10;
        constraints.fill = 1;
        panel.add((Component)this.createColumnsPanel(), constraints);
        return panel;
    }

    public int getViewMode() {
        return 1;
    }

    public String getViewName() {
        return StringResources.DETAILS;
    }
}

