/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBy;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ViewByCalendar
extends ViewBy {
    protected JCheckBox cbShowMonthPicker = new OrientableCheckBox(StringResources.SHOW_MONTH_PICKER);
    protected JCheckBox cbShowCalendarToolbar = new OrientableCheckBox(StringResources.SHOW_CALENDAR_TOOLBAR);
    protected JSpinner spnOnWeekViewShowDays = new OrientableSpinner(new SpinnerNumberModel(1, 1, 99, 1));

    protected ViewByCalendar(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        this.propertyManager.addPropertyView(this.cbShowCalendarToolbar);
        this.propertyManager.addPropertyView(this.cbShowMonthPicker);
        this.propertyManager.addPropertyView(this.spnOnWeekViewShowDays);
    }

    public JPanel getLeftPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.anchor = 21;
        panel.add((Component)this.cbShowMonthPicker, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)this.cbShowCalendarToolbar, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.createOnWeekViewShowNDaysPanel(), constraints);
        return panel;
    }

    protected JPanel createOnWeekViewShowNDaysPanel() {
        OrientablePanel panel = new OrientablePanel(new FlowLayout());
        panel.add(new OrientableLabel(StringResources.ON_WEEK_VIEW_SHOW));
        panel.add(this.spnOnWeekViewShowDays);
        panel.add(new OrientableLabel(StringResources.DAYS));
        return panel;
    }

    public JPanel getRightPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 25;
        panel.add((Component)this.btnMoreDisplaySettings, constraints);
        return panel;
    }

    public boolean loadProperties() {
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        this.cbShowCalendarToolbar.setSelected(viewDisplaySettings.showCalToolbar());
        this.cbShowMonthPicker.setSelected(viewDisplaySettings.showCalSmallMonths());
        this.spnOnWeekViewShowDays.setValue(viewDisplaySettings.getCalWeekColumnCount());
        return super.loadProperties();
    }

    public int getViewMode() {
        return 6;
    }

    public String getViewName() {
        return StringResources.CALENDAR;
    }

    public boolean saveProperties() {
        boolean result = super.saveProperties();
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        viewDisplaySettings.setShowCalSmallMonths(this.cbShowMonthPicker.isSelected());
        viewDisplaySettings.setShowCalToolbar(this.cbShowCalendarToolbar.isSelected());
        viewDisplaySettings.setCalWeekColumnCount((Integer)this.spnOnWeekViewShowDays.getValue());
        return result;
    }
}

