/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByTableMode;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class ViewByTableMode_Messages
extends ViewByTableMode {
    protected JRadioButton rbWnenCompleted = new OrientableRadioButton(StringResources.WHEN_COMPLETED);
    protected JRadioButton rbNextDayAfterCompleted = new OrientableRadioButton(StringResources.NEXT_DAY_AFTER_COMPLETED);
    protected JCheckBox cbMessagePreview = new OrientableCheckBox(StringResources.MESSAGE_PREVIEW);
    protected JCheckBox cbHideItemsNotInTaskList = new OrientableCheckBox(StringResources.HIDE_ITEMS_NOT_IN_TASKLIST);
    protected JCheckBox cbHideTasklistItems = new OrientableCheckBox(StringResources.HIDE_TASKLIST_ITEMS_C);

    protected ViewByTableMode_Messages(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        this.cbHideItemsNotInTaskList.setEnabled(false);
        this.cbHideTasklistItems.setEnabled(false);
        this.rbWnenCompleted.setEnabled(false);
        this.rbNextDayAfterCompleted.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbWnenCompleted);
        group.add(this.rbNextDayAfterCompleted);
        this.propertyManager.addPropertyView(this.rbWnenCompleted);
        this.propertyManager.addPropertyView(this.rbNextDayAfterCompleted);
        this.propertyManager.addPropertyView(this.cbMessagePreview);
        this.propertyManager.addPropertyView(this.cbHideItemsNotInTaskList);
        this.propertyManager.addPropertyView(this.cbHideTasklistItems);
        this.cbHideTasklistItems.addItemListener(new HideItemsNotInTasklistListener());
    }

    public boolean loadProperties() {
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        this.cbMessagePreview.setSelected(viewDisplaySettings.getMsgPreview());
        this.cbHideItemsNotInTaskList.setSelected(viewDisplaySettings.isHideNonChecklist());
        boolean hideCompleted = viewDisplaySettings.getHideCompleted();
        boolean hideCompletedAfterADay = viewDisplaySettings.getHideCompletedAfterADay();
        this.cbHideTasklistItems.setSelected(hideCompleted || hideCompletedAfterADay);
        if (hideCompletedAfterADay) {
            this.rbNextDayAfterCompleted.setSelected(true);
        } else {
            this.rbWnenCompleted.setSelected(true);
        }
        this.refreshHideItemsNotInTasklist();
        return super.loadProperties();
    }

    public JPanel getRightPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.anchor = 23;
        panel.add((Component)this.rbSummary, constraints);
        ++constraints.gridy;
        panel.add((Component)this.rbColumns, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.cbShowGroupLabels, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.cbMessagePreview, constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        panel.add((Component)this.cbHideItemsNotInTaskList, constraints);
        ++constraints.gridy;
        panel.add((Component)this.cbHideTasklistItems, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 20, 0, 0);
        panel.add((Component)this.rbWnenCompleted, constraints);
        ++constraints.gridy;
        constraints.insets.top = 0;
        panel.add((Component)this.rbNextDayAfterCompleted, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.top = 10;
        constraints.anchor = 25;
        panel.add((Component)this.btnMoreDisplaySettings, constraints);
        return panel;
    }

    public boolean saveProperties() {
        boolean result = super.saveProperties();
        IViewDisplaySettings viewDisplaySettings = this.folderDisplaySettings.asViewDisplaySettings();
        viewDisplaySettings.setHideNonChecklist(this.cbHideItemsNotInTaskList.isSelected());
        viewDisplaySettings.setMsgPreview(this.cbMessagePreview.isSelected());
        return result;
    }

    private void refreshHideItemsNotInTasklist() {
        boolean selected = this.cbHideTasklistItems.isSelected() && this.cbHideTasklistItems.isEnabled();
        this.rbWnenCompleted.setEnabled(selected);
        this.rbNextDayAfterCompleted.setEnabled(selected);
    }

    private class HideItemsNotInTasklistListener
    implements ItemListener {
        private HideItemsNotInTasklistListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ViewByTableMode_Messages.this.refreshHideItemsNotInTasklist();
        }
    }
}

