/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.nameformat;

import com.appframework.Application;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.ab.SystemAddressBook;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressBookTree;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class NameFormatDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(NameFormatDialog.class);
    static final int interval = 1000;
    static final boolean ORDER_FIRST_LAST = true;
    static final boolean ORDER_LAST_FIRST = false;
    private JList personalAddressBooksList;
    private JButton btnApply = new OrientableButton(StringResources.APPLY_TO_SELECTED_BOOKS);
    private JRadioButton firstThenLastRadio = new JRadioButton(StringResources.SHOW_FIRST_LAST);
    private JRadioButton lastThenFirstRadio = new JRadioButton(StringResources.SHOW_LAST_FIRST);
    private Window parentWindow;
    private Timer timer;
    private JProgressBar progressBar;
    private int k = 0;
    private boolean displayOrder = true;
    private boolean warningDialogShow = true;
    private ArrayList personalAddressBooks = null;
    private SystemAddressBook systemAddressBook = null;
    private AbstractAddressBook sysAbstractAddressBook = null;

    public NameFormatDialog(JFrame theFrame) {
        super(theFrame);
        this.parentWindow = theFrame;
        this.setModal(true);
        this.setTitle(StringResources.DISPLAY_NAME_FORMAT);
        this.getAllAdressBooks();
        this.buildUI();
        this.buildListeners();
        this.pack();
    }

    public static void show(Window window) {
        NameFormatDialog dialog = new NameFormatDialog((JFrame)window);
        dialog.showMe();
    }

    public boolean getWarningDialogShow() {
        return this.warningDialogShow;
    }

    private void buildUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new MatteBorder(5, 5, 5, 5, this.getBackground()));
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.fill = 2;
        contentPane.add((Component)this.buildDisplaySettingsPanel(), c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        contentPane.add((Component)this.buildListPanel(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 2;
        c.fill = 0;
        c.anchor = 19;
        contentPane.add((Component)this.buildButtonsPanel(), c);
    }

    private void buildListeners() {
        this.personalAddressBooksList.addMouseListener(new PABListListener());
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel thePanel = new OrientablePanel();
        thePanel.removeAll();
        thePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.btnOK.setEnabled(false);
        this.btnOK.addActionListener(new OkListener());
        this.btnCancel.addActionListener(new CancelListener());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 2;
        thePanel.add((Component)this.btnOK, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        c.fill = 2;
        thePanel.add((Component)this.btnCancel, c);
        return thePanel;
    }

    private JPanel buildDisplaySettingsPanel() {
        OrientablePanel thePanel = new OrientablePanel();
        thePanel.setBorder(new TitledBorder(StringResources.TITLE_DISPLAY_NAME_FORMAT));
        thePanel.removeAll();
        thePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.displayOrder = this.systemAddressBook.getNameFormat() == 50091;
        this.firstThenLastRadio.setSelected(this.displayOrder);
        this.firstThenLastRadio.addActionListener(new FirstLastRadioListener());
        this.lastThenFirstRadio.setSelected(!this.displayOrder);
        this.lastThenFirstRadio.addActionListener(new LastFirstRadioListener());
        this.btnApply.addActionListener(new ApplySettingsListener());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        thePanel.add((Component)this.firstThenLastRadio, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        thePanel.add((Component)this.lastThenFirstRadio, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 5, 5, 5);
        c.fill = 2;
        thePanel.add((Component)this.btnApply, c);
        return thePanel;
    }

    private JPanel buildListPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        GWTextArea labelText = new GWTextArea();
        ((JTextComponent)labelText).setEditable(false);
        labelText.setOpaque(false);
        ((JTextComponent)labelText).setText(StringResources.TITLE_FOR_PERSONAL_AB_LIST_C);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 0, 5);
        c.fill = 2;
        panel.add((Component)labelText, c);
        ++c.gridy;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)this.buildPABScrollPane(), c);
        GWTextArea noteText = new GWTextArea();
        ((JTextComponent)noteText).setEditable(false);
        noteText.setOpaque(false);
        ((JTextComponent)noteText).setText(StringResources.formatString(StringResources.NOTE_NAME_FORMAT, this.systemAddressBook.getName()));
        ++c.gridy;
        c.insets = new Insets(5, 5, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)noteText, c);
        return panel;
    }

    private JPanel buildProgressBarPanel() {
        OrientablePanel thePanel = new OrientablePanel();
        thePanel.removeAll();
        thePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.progressBar = new JProgressBar(0, 2);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        thePanel.add((Component)new JSeparator(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        thePanel.add((Component)this.progressBar, c);
        return thePanel;
    }

    private JScrollPane buildPABScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        this.personalAddressBooksList = new OrientableList(this.personalAddressBooks.toArray());
        this.personalAddressBooksList.setBorder(BorderFactory.createEtchedBorder());
        this.personalAddressBooksList.setSelectionMode(2);
        for (int i = 0; i < this.personalAddressBooksList.getModel().getSize(); ++i) {
            this.personalAddressBooksList.addSelectionInterval(i, i);
        }
        this.personalAddressBooksList.setVisibleRowCount(10);
        scrollPane.getViewport().setView(this.personalAddressBooksList);
        return scrollPane;
    }

    private void getAllAdressBooks() {
        this.personalAddressBooks = new ArrayList();
        for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
            if (addressBook.isSystemAddressBook()) {
                this.sysAbstractAddressBook = addressBook;
                this.systemAddressBook = (SystemAddressBook)this.sysAbstractAddressBook.getNativeAddressBook();
                continue;
            }
            this.personalAddressBooks.add(addressBook);
        }
    }

    private void applyFormattingForPABs(int displayNameFormat) throws EngineException {
        int[] indicies = this.personalAddressBooksList.getSelectedIndices();
        Arrays.sort(indicies);
        for (int i = 0; i < indicies.length; ++i) {
            AbstractAddressBook abstarctBook = (AbstractAddressBook)this.personalAddressBooks.get(indicies[i]);
            AddressBook book = abstarctBook.getNativeAddressBook();
            logger.debug((Object)("### ---- Selected Personal Address Books: <" + book.getName() + ">, is read only: " + book.isReadOnly()));
            PersonalAddressBook pb = (PersonalAddressBook)book;
            if (pb.isReadOnly()) continue;
            pb.setNameFormat(displayNameFormat);
            this.getController().processCommand(new GlobalCommand(1190, abstarctBook));
        }
    }

    private void applyFormattingForSystemAB(int displayNameFormat) throws EngineException {
        this.systemAddressBook.setNameFormat(displayNameFormat);
        this.getController().processCommand(new GlobalCommand(1190, this.sysAbstractAddressBook));
    }

    private int getDisplayNameFormat() {
        int displayNameFormat = 50091;
        if (this.firstThenLastRadio.isSelected()) {
            displayNameFormat = 50091;
        }
        if (this.lastThenFirstRadio.isSelected()) {
            displayNameFormat = 50093;
        }
        return displayNameFormat;
    }

    private void setSelectedAB() {
        AddressBookTree tree = Application.getAddressBookFrame().getAddressBookTree();
        Object selectedObject = tree.getSelectionPath().getLastPathComponent();
        AbstractAddressBook directory = (AbstractAddressBook)((DefaultMutableTreeNode)selectedObject).getUserObject();
        Command command = new Command(360, directory);
        this.getController().processCommand(command);
    }

    private void disposeOperation() {
        logger.debug((Object)"dispose operation ...");
        GWDialog.disposeDialog((GWDialog)this.getParent());
    }

    private void saveOptions() {
        logger.debug((Object)"The user's choice has just been saved");
        int nameFormat = this.firstThenLastRadio.isSelected() ? 50091 : 50093;
        try {
            this.systemAddressBook.setNameFormat(nameFormat);
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    public MVCController getController() {
        return ControlsUtils.findClosestController(this.parentWindow);
    }

    private class PABListListener
    extends MouseAdapter {
        private PABListListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (NameFormatDialog.this.warningDialogShow) {
                NameFormatDialog.this.warningDialogShow = false;
                JOptionPane.showMessageDialog(NameFormatDialog.this, StringResources.ADDRESS_BOOK_WARNING_MESSAGE, StringResources.ADDRESS_BOOK_WARNING, 2);
            }
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            NameFormatDialog.this.k = NameFormatDialog.this.k + 1;
            NameFormatDialog.this.progressBar.setValue(NameFormatDialog.this.k);
            if (NameFormatDialog.this.k == 2) {
                NameFormatDialog.this.timer.stop();
                NameFormatDialog.this.btnApply.setEnabled(true);
                NameFormatDialog.this.progressBar.setValue(NameFormatDialog.this.progressBar.getMinimum());
            }
        }
    }

    private class LastFirstRadioListener
    implements ActionListener {
        private LastFirstRadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            NameFormatDialog.this.firstThenLastRadio.setSelected(false);
            NameFormatDialog.this.lastThenFirstRadio.setSelected(true);
            NameFormatDialog.this.btnOK.setEnabled(NameFormatDialog.this.displayOrder);
        }
    }

    private class FirstLastRadioListener
    implements ActionListener {
        private FirstLastRadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            NameFormatDialog.this.firstThenLastRadio.setSelected(true);
            NameFormatDialog.this.lastThenFirstRadio.setSelected(false);
            NameFormatDialog.this.btnOK.setEnabled(!NameFormatDialog.this.displayOrder);
        }
    }

    private class ApplySettingsListener
    implements ActionListener {
        private ApplySettingsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NameFormatDialog.this.applyFormattingForPABs(NameFormatDialog.this.getDisplayNameFormat());
                NameFormatDialog.this.setSelectedAB();
            }
            catch (EngineException e1) {
                logger.error((Object)e1);
                logger.debug((Object)e1, (Throwable)e1);
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class OkListener
    implements ActionListener {
        private OkListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int displayNameFormat = NameFormatDialog.this.getDisplayNameFormat();
                NameFormatDialog.this.applyFormattingForSystemAB(displayNameFormat);
                NameFormatDialog.this.applyFormattingForPABs(displayNameFormat);
                NameFormatDialog.this.setSelectedAB();
            }
            catch (EngineException e1) {
                logger.error((Object)e1);
                logger.debug((Object)e1, (Throwable)e1);
            }
            NameFormatDialog.this.saveOptions();
        }
    }
}

