/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.dialogs.rules.IVacationRuleDataProvider;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.rules.VacationRuleInfo;
import java.util.Date;

public class VacationRuleDialogController
extends MVCController
implements IVacationRuleDataProvider {
    private static final String EMPTY_STRING = "";
    private static final Date TODAY_DATE = GWCalendarUtils.getTodayWithoutTimeFraction().getTime();
    private static final VacationRuleInfo DEFAULT_VACATION_RULE_INFO = new VacationRuleInfo(StringResources.VACATION_RULE, "", "", true, null, null, true);
    private IDataStore dataStore;
    private VacationRuleExtraInfo originalVacationRuleInfo;
    private boolean isDatesSelected = false;

    public VacationRuleDialogController(MVCView theView, MVCController theParentController) {
        super(theView, theParentController);
    }

    private IDataStore getDataStore() {
        if (this.dataStore == null) {
            this.initDataStore();
        }
        return this.dataStore;
    }

    private VacationRuleInfo getDefaultVacationRuleInfo() {
        return DEFAULT_VACATION_RULE_INFO;
    }

    private VacationRuleExtraInfo getOriginalVacationRuleInfo() {
        if (this.originalVacationRuleInfo == null) {
            VacationRuleInfo vacationRuleInfoFromDataStore = this.getDataStore().getVacationRuleInfo();
            if (vacationRuleInfoFromDataStore == null) {
                this.originalVacationRuleInfo = new VacationRuleExtraInfo(this.getDefaultVacationRuleInfo());
                this.isDatesSelected = false;
            } else {
                this.originalVacationRuleInfo = new VacationRuleExtraInfo(vacationRuleInfoFromDataStore);
                this.isDatesSelected = vacationRuleInfoFromDataStore.getStartDate() != null && vacationRuleInfoFromDataStore.getEndDate() != null;
            }
        }
        return this.originalVacationRuleInfo;
    }

    private void initDataStore() {
        GWCommandManager commandManager = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this));
        this.dataStore = commandManager.getCurrentDataStore();
    }

    public VacationRuleInfo getVacationRuleInfo() {
        return this.getOriginalVacationRuleInfo();
    }

    public void setVacationRuleInfo(VacationRuleInfo vacationRuleInfo) {
        if (vacationRuleInfo != null && !this.getOriginalVacationRuleInfo().equals(vacationRuleInfo)) {
            this.getDataStore().modifyVacationRule(vacationRuleInfo.getName(), vacationRuleInfo.getReplySubject(), vacationRuleInfo.getReplyMessage(), vacationRuleInfo.isActive(), vacationRuleInfo.getStartDate(), vacationRuleInfo.getEndDate(), vacationRuleInfo.isReplyToExternalUsers());
            this.originalVacationRuleInfo = null;
            this.isDatesSelected = false;
        }
    }

    public boolean isDatesSelected() {
        return this.isDatesSelected;
    }

    private class VacationRuleExtraInfo
    extends VacationRuleInfo {
        public VacationRuleExtraInfo(VacationRuleInfo info) {
            super(info.getName(), info.getReplySubject(), info.getReplyMessage(), info.isActive(), info.getStartDate(), info.getEndDate(), info.isReplyToExternalUsers());
        }

        private boolean endDatesEquals(Date date) {
            boolean equals;
            boolean bl = equals = super.getEndDate() == date;
            if (date != null && super.getEndDate() != null) {
                equals = this.getEndDate().equals(date);
            }
            return equals;
        }

        private boolean startDatesEquals(Date date) {
            boolean equals;
            boolean bl = equals = super.getStartDate() == date;
            if (date != null && super.getStartDate() != null) {
                equals = this.getStartDate().equals(date);
            }
            return equals;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            boolean equals = false;
            if (obj != null && obj.getClass() == VacationRuleInfo.class) {
                VacationRuleInfo vacationRuleInfo = (VacationRuleInfo)obj;
                equals = this.getName().equals(vacationRuleInfo.getName());
                equals &= this.getReplySubject().equals(vacationRuleInfo.getReplySubject());
                equals &= this.getReplyMessage().equals(vacationRuleInfo.getReplyMessage());
                equals &= this.isActive() == vacationRuleInfo.isActive();
                equals &= this.isReplyToExternalUsers() == vacationRuleInfo.isReplyToExternalUsers();
                equals &= this.startDatesEquals(vacationRuleInfo.getStartDate());
                equals &= this.endDatesEquals(vacationRuleInfo.getEndDate());
            }
            return equals;
        }

        public Date getStartDate() {
            Date startDate = super.getStartDate();
            if (startDate == null) {
                startDate = TODAY_DATE;
            }
            return startDate;
        }

        public Date getEndDate() {
            Date endDate = super.getEndDate();
            if (endDate == null) {
                endDate = TODAY_DATE;
            }
            return endDate;
        }
    }
}

