/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules.actions;

import com.appframework.mvc.MVCController;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.dialogs.rules.actions.AbstractMailActionDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import com.novell.gw.rules.RuleActionForward;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.JDialog;

class ForwardMailActionDialog
extends AbstractMailActionDialog {
    public ForwardMailActionDialog(JDialog parentDialog, MVCController parentController, RuleAction theRuleAction, Rule thRule, String userGuid) {
        super(parentDialog, parentController, theRuleAction, thRule, userGuid);
        this.setTitle(StringResources.FORWARD);
    }

    protected boolean writeRuleAction() {
        boolean bRet = true;
        List<IRecipient> result = this.getRecipients();
        if (result.size() > 0) {
            DistributionList distributionList = new DistributionList();
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                distributionList.addRecipient(result.get(i).getNativeRecipient());
            }
            if (this.ruleAction == null) {
                this.ruleAction = new RuleActionForward(this.rule, distributionList);
            } else {
                ((RuleActionForward)this.ruleAction).setDistributionList(distributionList);
            }
            RuleActionForward ruleActionForward = (RuleActionForward)this.ruleAction;
            ruleActionForward.setFrom(this.tfFrom.getText());
            ruleActionForward.setMessage(this.taMessage.getText());
            ruleActionForward.setSubject(this.tfSubject.getText());
            ruleActionForward.setAttachments(this.getAttachments(ruleActionForward.getAttachments()));
        } else {
            Toolkit.getDefaultToolkit().beep();
            bRet = false;
        }
        return bRet;
    }

    protected void readRuleAction() {
        RuleActionForward actionForward = (RuleActionForward)this.ruleAction;
        this.setRecipients(actionForward.getDistributionList());
        this.tfFrom.setText(actionForward.getFrom());
        this.tfSubject.setText(actionForward.getSubject());
        this.taMessage.setText(actionForward.getMessage());
        this.tfFiles.setText(actionForward.getAttachments());
    }
}

