/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.timedifference;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.timedifference.HourDocument;
import com.novell.gw.jclient.application.dialogs.timedifference.MinuteDocument;
import com.novell.gw.jclient.application.dialogs.timedifference.TimeDocument;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.options.GWTimeZone;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class TimeDifferenceDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger(TimeDifferenceDialog.class);
    private JComboBox[] cmbZone = new OrientableComboBox[2];
    private JTextField[] tfHours = new JTextField[2];
    private JTextField[] tfMins = new JTextField[2];
    private TimeZone[] tz = new TimeZone[2];
    Calendar[] gc = new Calendar[2];
    private JButton btnClose;
    private DateFormat hourFormat;
    private DateFormat ampmFormat;
    private DateFormat minFormat;
    private JComboBox[] cmbAMPM = new OrientableComboBox[2];
    private AMPMCmbAdapter[] ampmCmbAdapter = new AMPMCmbAdapter[2];
    private Vector<String> AMPM = new Vector();

    public TimeDifferenceDialog() {
        this((JFrame)null);
    }

    public TimeDifferenceDialog(JFrame parent) {
        super((Frame)parent, true);
        this.init();
        this.buildUI();
        this.refreshUI();
        this.setDefaultButton(this.btnClose);
    }

    private void init() {
        this.gc[0] = GWCalendarUtils.getTodayUTC();
        this.gc[1] = GWCalendarUtils.getTodayUTC();
        this.minFormat = new SimpleDateFormat("mm");
        if (DateAndTimeFormattingUtils.is24HourFormat()) {
            this.hourFormat = new SimpleDateFormat("HH");
        } else {
            this.hourFormat = new SimpleDateFormat("hh");
            this.ampmFormat = new SimpleDateFormat("aa");
        }
        this.AMPM.add("AM");
        this.AMPM.add("PM");
    }

    private void buildUI() {
        this.setTitle(StringResources.TIME_DIFFERENCE);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setComponentOrientation(UIUtils.getComponentOrientation());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.anchor = 21;
        c.weightx = 1.0;
        this.getContentPane().add((Component)this.buildInfoPanel(), c);
        c.gridy = 1;
        c.anchor = 10;
        c.fill = 2;
        this.getContentPane().add((Component)this.buildZonePanel(0), c);
        c.gridy = 2;
        this.getContentPane().add((Component)this.buildZonePanel(1), c);
        this.btnClose = new JButton(StringResources.CLOSE);
        this.btnClose.addActionListener(new BtnClose());
        c.gridy = 3;
        c.fill = 0;
        this.getContentPane().add((Component)this.btnClose, c);
        this.pack();
    }

    private JPanel buildInfoPanel() {
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Calendar gc = GWCalendarUtils.getToday();
        TimeZone timeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        OrientableLabel lbl = new OrientableLabel(StringResources.HOST_TIME_ZONE_C);
        c.anchor = 21;
        c.insets = new Insets(10, 10, 0, 10);
        pnl.add((Component)lbl, c);
        lbl = new OrientableLabel(GWTimeZone.createGwTimeZoneName(timeZone));
        c.gridx = 1;
        pnl.add((Component)lbl, c);
        lbl = new OrientableLabel(StringResources.HOST_TIME_C);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 10, 0, 10);
        pnl.add((Component)lbl, c);
        DateFormat dtf = DateFormat.getDateTimeInstance(3, 3, EngineCommandManager.getLocale());
        dtf.setTimeZone(timeZone);
        lbl = new OrientableLabel(dtf.format(gc.getTime()));
        c.gridx = 1;
        pnl.add((Component)lbl, c);
        return pnl;
    }

    private JPanel buildZonePanel(int index) {
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        String title = StringResources.TIME_ZONE;
        title = index == 0 ? title + " A" : title + " B";
        Border border = BorderFactory.createEtchedBorder(0);
        pnl.setBorder(BorderFactory.createTitledBorder(border, title));
        GridBagConstraints c = new GridBagConstraints();
        OrientableLabel lbl = new OrientableLabel(StringResources.SELECT_TIME_ZONE_C + ' ');
        c.insets = new Insets(0, 10, 0, 10);
        c.fill = 1;
        c.anchor = 21;
        pnl.add((Component)lbl, c);
        this.cmbZone[index] = new OrientableComboBox(OptionManager.getInstance().getDateTimeOptions().getTimeZoneOptions().getTimeZoneNames());
        this.cmbZone[index].setSelectedItem(new GWTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone()));
        this.tz[index] = ((GWTimeZone)this.cmbZone[index].getSelectedItem()).getTimeZone();
        this.cmbZone[index].addActionListener(new CbmTimeZoneAction(index));
        c.gridx = 1;
        c.anchor = 22;
        pnl.add((Component)this.cmbZone[index], c);
        OrientablePanel pnlTime = new OrientablePanel();
        lbl = new OrientableLabel(StringResources.TIME_C + ' ');
        pnlTime.add(lbl);
        this.tfHours[index] = new GWTextField();
        this.tfHours[index].setDocument(new HourDocument());
        this.tfHours[index].setColumns(2);
        this.tfHours[index].addKeyListener(new TfHourKeyAdapter(index));
        pnlTime.add(this.tfHours[index]);
        if (!DateAndTimeFormattingUtils.is24HourFormat()) {
            this.ampmCmbAdapter[index] = new AMPMCmbAdapter(index);
            this.cmbAMPM[index] = new OrientableComboBox((Vector)this.AMPM);
            this.cmbAMPM[index].addActionListener(this.ampmCmbAdapter[index]);
            pnlTime.add(this.cmbAMPM[index]);
        }
        lbl = new OrientableLabel(StringResources.HOUR_S + ' ');
        pnlTime.add(lbl);
        this.tfMins[index] = new GWTextField();
        this.tfMins[index].setDocument(new MinuteDocument());
        this.tfMins[index].setColumns(2);
        this.tfMins[index].addKeyListener(new TfMinKeyAdapter(index));
        pnlTime.add(this.tfMins[index]);
        lbl = new OrientableLabel(StringResources.MIN_S);
        pnlTime.add(lbl);
        c.gridy = 1;
        c.anchor = 22;
        pnl.add((Component)pnlTime, c);
        return pnl;
    }

    private void refreshUI() {
        this.setTime(0);
        this.setTime(1);
    }

    private void setTime(int index) {
        this.hourFormat.setTimeZone(this.tz[index]);
        if (!DateAndTimeFormattingUtils.is24HourFormat()) {
            this.ampmFormat.setTimeZone(this.tz[index]);
            this.cmbAMPM[index].removeActionListener(this.ampmCmbAdapter[index]);
            if (this.ampmFormat.format(this.gc[index].getTime()).toUpperCase().equals("AM")) {
                this.cmbAMPM[index].setSelectedItem(this.AMPM.get(0));
            } else {
                this.cmbAMPM[index].setSelectedItem(this.AMPM.get(1));
            }
            this.cmbAMPM[index].addActionListener(this.ampmCmbAdapter[index]);
        }
        this.minFormat.setTimeZone(this.tz[index]);
        this.gc[index].setTimeZone(this.tz[index]);
        this.tfHours[index].setText(this.hourFormat.format(this.gc[index].getTime()));
        this.tfMins[index].setText(this.minFormat.format(this.gc[index].getTime()));
    }

    private void refreshTime(int index) {
        if (!TimeDocument.isDigit(this.tfMins[index].getText()) || !TimeDocument.isDigit(this.tfHours[index].getText())) {
            return;
        }
        if (DateAndTimeFormattingUtils.is24HourFormat()) {
            this.gc[index].set(11, Integer.parseInt(this.tfHours[index].getText()));
        } else {
            this.gc[index].set(9, this.cmbAMPM[index].getSelectedIndex());
            this.gc[index].set(10, Integer.parseInt(this.tfHours[index].getText()));
        }
        this.gc[index].set(12, Integer.parseInt(this.tfMins[index].getText()));
        int another = index == 0 ? 1 : 0;
        long time = this.gc[index].getTimeInMillis();
        this.gc[another].setTimeInMillis(time);
        this.setTime(another);
    }

    class AMPMCmbAdapter
    extends AbstractAction {
        int index = 0;

        public AMPMCmbAdapter(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            TimeDifferenceDialog.this.refreshTime(this.index);
        }
    }

    class TfMinKeyAdapter
    extends KeyAdapter {
        int index = 0;

        public TfMinKeyAdapter(int theIndex) {
            this.index = theIndex;
        }

        public void keyReleased(KeyEvent e) {
            if (Character.isDigit(e.getKeyChar())) {
                TimeDifferenceDialog.this.refreshTime(this.index);
            }
        }
    }

    class TfHourKeyAdapter
    extends KeyAdapter {
        int index = 0;

        public TfHourKeyAdapter(int theIndex) {
            this.index = theIndex;
        }

        public void keyReleased(KeyEvent e) {
            if (Character.isDigit(e.getKeyChar())) {
                TimeDifferenceDialog.this.refreshTime(this.index);
            }
        }
    }

    class BtnClose
    extends AbstractAction {
        BtnClose() {
        }

        public void actionPerformed(ActionEvent e) {
            TimeDifferenceDialog.this.setVisible(false);
        }
    }

    class CbmTimeZoneAction
    extends AbstractAction {
        int index = 0;

        public CbmTimeZoneAction(int theIndex) {
            this.index = theIndex;
        }

        public void actionPerformed(ActionEvent e) {
            ((TimeDifferenceDialog)TimeDifferenceDialog.this).tz[this.index] = ((GWTimeZone)TimeDifferenceDialog.this.cmbZone[this.index].getSelectedItem()).getTimeZone();
            TimeDifferenceDialog.this.refreshUI();
        }
    }
}

