/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.calendar;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.impl.ViewDisplaySettingsProxy;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionSwitchMainToolBar;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ItemListComponentDataModelImpl;
import com.novell.gw.jclient.application.controls.filter.IFilterOwner;
import com.novell.gw.jclient.application.controls.filter.QuickFilterPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewPanel;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FrameCalendarMenuBar;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcher;
import com.novell.gw.jclient.application.controls.toolbars.FrameCalendarToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendarActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameCalendar
extends ApplicationFrame<FrameCalendarActionList, Object>
implements IFilterOwner {
    private Calendar gcCurrDay = GWCalendarUtils.getToday();
    private SkinnablePanel headerPanel;
    private StorageSwitcher treeStorageSwitcher;
    private HeaderPopupMenu headerPopupMenu;
    private QuickFilterPanel pnlQuickFilter;
    private PropertiesViewListItem calendarType;
    private ItemListView itemListView;
    private boolean daily = false;

    public FrameCalendar(Date date, AbstractFolder folder, String userGuid, PropertiesViewListItem calendarType) {
        this(date, folder, false, userGuid, calendarType);
    }

    public FrameCalendar(Date date, AbstractFolder folder, boolean isDaily, String userGuid) {
        this(date, folder, isDaily, userGuid, PropertiesViewList.getItemTypesList().get(0));
    }

    public FrameCalendar(Date date, AbstractFolder folder, boolean isDaily, String userGuid, PropertiesViewListItem calendarType) {
        super(calendarType.getViewName(), "CALENDAR_FRAME", userGuid);
        this.setController(new FrameCalendarActionList(this, (MVCController)GWClient.getApplication()));
        this.toolBarName = "FRAME_CALENDAR_TOOLBAR_VISIBLE";
        this.calendarType = calendarType;
        if (date != null) {
            this.gcCurrDay.setTime(date);
        } else {
            this.gcCurrDay.setTime(GWCalendarUtils.getToday().getTime());
        }
        this.daily = isDaily;
        this.buildUI(folder);
    }

    protected void buildUI(AbstractFolder folder) {
        this.getContentPane().setPreferredSize(new Dimension(800, 600));
        this.treeStorageSwitcher = new StorageSwitcher((ActionList)this.getController());
        this.headerPopupMenu = new HeaderPopupMenu(this.appActionList);
        this.setGWMenuBar(new FrameCalendarMenuBar((ApplicationFrameActionList)this.getController()));
        GWToolBarPanel toolBarPanel = new GWToolBarPanel();
        toolBarPanel.add((Component)new FrameCalendarToolBar((ApplicationFrameActionList)this.getController()), "Center");
        this.buildHeader();
        toolBarPanel.add((Component)this.headerPanel, "South");
        this.setToolBarPanel(toolBarPanel, "North");
        IViewDisplaySettings viewDisplaySettings = this.wrapViewDisplaySettings(folder.getDisplaySettings().asViewDisplaySettings());
        viewDisplaySettings.setCalViewType(this.calendarType.getView());
        this.itemListView = new FrameCalendarItemListViewPanel(folder, viewDisplaySettings, null, this.getController());
        this.centeredContentPanel.add((Component)this.itemListView.getComponent(), "Center");
        this.setIconImage(ImageResources.ICON_ACT_VIEW_CALENDAR.getImage());
    }

    @Override
    public void showMe() {
        super.showMe();
        this.itemListView.refresh();
    }

    private void buildHeader() {
        this.headerPanel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(this.headerPanel);
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        GridBagConstraints c = new GridBagConstraints();
        JComponent headerRigidArea = (JComponent)Box.createRigidArea(new Dimension(10, 1));
        c.gridx = 0;
        c.gridy = 0;
        this.headerPanel.add((Component)headerRigidArea, c);
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 1;
        this.headerPanel.add(Box.createHorizontalStrut(10), c);
        c.gridx = 2;
        this.headerPanel.add((Component)this.treeStorageSwitcher, c);
        c.weightx = 1.0;
        c.gridx = 3;
        c.insets = new Insets(0, 0, 0, 0);
        this.headerPanel.add(Box.createHorizontalStrut(10), c);
        this.pnlQuickFilter = new QuickFilterPanel(this.appActionList);
        this.headerPanel.add(this.pnlQuickFilter);
        this.headerPanel.add(Box.createHorizontalStrut(10));
        this.headerPanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(this.headerPopupMenu));
    }

    @Override
    public Filter getFilter() {
        return this.pnlQuickFilter.getFilter();
    }

    public AbstractFolder getFolder() {
        return this.itemListView.getAbstractFolder();
    }

    public void setFolder(AbstractFolder folder) {
        this.itemListView.setData(folder, this.wrapViewDisplaySettings(folder.getDisplaySettings().asViewDisplaySettings()), this.itemListView.getFilter());
        this.itemListView.refresh();
    }

    private IViewDisplaySettings wrapViewDisplaySettings(IViewDisplaySettings viewDisplaySettings) {
        return new FrameCalendarViewDisplaySettings(viewDisplaySettings);
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        this.itemListView.setActivated(true);
    }

    @Override
    public void release() {
        super.release();
        this.itemListView = null;
        this.gcCurrDay = null;
        this.headerPanel = null;
        this.pnlQuickFilter = null;
    }

    public String getPreferedMenuText() {
        return this.calendarType.getName();
    }

    private class FrameCalendarItemListViewPanel
    extends ItemListViewPanel {
        private FrameCalendarItemListViewPanel(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, Filter filter, MVCController parentController) {
            super(folder, viewDisplaySettings, filter, parentController);
        }

        protected GWCalendar createCalendar() {
            ItemListComponentDataModelImpl calendarModel = new ItemListComponentDataModelImpl(this.getAbstractFolder(), this.getViewDisplaySettings(), this.getItemList());
            return new GWCalendar(FrameCalendar.this.gcCurrDay, FrameCalendar.this.daily, this.getController(), FrameCalendar.this.calendarType, false, calendarModel, true);
        }

        protected void initItemListComponent() {
            super.initItemListComponent();
            ActionSwitchMainToolBar actionSwitch = (ActionSwitchMainToolBar)this.getController().getActionList().getAction(ActionKey.SWITCH_MAIN_TOOLBAR);
            actionSwitch.setToolBarName(FrameCalendar.this.toolBarName);
            FrameCalendar.this.showToolbar();
            this.getController().processCommand(new Command(70, FrameCalendar.this.gcCurrDay));
        }
    }

    private class FrameCalendarViewDisplaySettings
    extends ViewDisplaySettingsProxy {
        private CalendarViewType type;
        private int itemType;
        private int calWeekColumnCount;

        private FrameCalendarViewDisplaySettings(IViewDisplaySettings delegate) {
            super(delegate);
            this.type = super.getCalViewType();
            this.itemType = super.getItemType();
            this.calWeekColumnCount = super.getCalWeekColumnCount();
        }

        public int getViewMode() {
            return 6;
        }

        public boolean showCalToolbar() {
            return true;
        }

        public CalendarViewType getCalViewType() {
            return this.type;
        }

        public void setCalViewType(CalendarViewType type) {
            this.type = type;
        }

        public int getItemType() {
            return this.itemType;
        }

        public boolean setItemType(int itemType) {
            this.itemType = itemType;
            return true;
        }

        public void setCalWeekColumnCount(int calWeekColumnCount) {
            this.calWeekColumnCount = calWeekColumnCount;
        }

        public int getCalWeekColumnCount() {
            return this.calWeekColumnCount;
        }
    }
}

