/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.help;

import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.ToolkitUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanel;
import com.novell.gw.jclient.application.controls.toolbars.FrameHelpToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.AbstractEditPanelDialog;
import com.novell.gw.jclient.application.frames.help.FrameHelpActionList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Component;
import java.io.File;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameHelp
extends ApplicationFrame<FrameHelpActionList, Object> {
    private static Logger logger = Logger.getLogger(FrameHelp.class);
    private BrowserPanel browserPanel;
    private String initialRelativeUrl = "index.html";

    public FrameHelp(String userGuid) {
        super(StringResources.GROUPWISE_HELP, "HELP_FRAME", userGuid);
        this.setController(new FrameHelpActionList(this, (MVCController)GWClient.getApplication()));
        this.buildUI();
    }

    public FrameHelp(String userGuid, String initialRelativeUrl) {
        super(StringResources.GROUPWISE_HELP, "HELP_FRAME", userGuid);
        this.initialRelativeUrl = initialRelativeUrl;
        this.setController(new FrameHelpActionList(this, (MVCController)GWClient.getApplication()));
        this.buildUI();
    }

    public static String getHelpDirUrl() {
        String language;
        String libDir = APIFactory.getEngine().getInstallLibPath();
        logger.debug((Object)("libDir: " + libDir));
        if (OS.isWinOS()) {
            libDir = libDir + Utils.FILE_SEPARATOR + "lib";
        }
        if ((language = EngineCommandManager.getLocale().getLanguage()).equals("zh")) {
            language = EngineCommandManager.getLocale().toString();
        }
        logger.debug((Object)("locale language: " + language));
        File helpDir = new File(libDir, "help");
        File localizedDir = new File(helpDir, language);
        logger.debug((Object)("localized help directory exists: " + helpDir.exists()));
        if (!localizedDir.exists()) {
            localizedDir = new File(helpDir, "en");
            logger.debug((Object)("default help directory exists: " + helpDir.exists()));
        }
        return "file:" + localizedDir.getAbsolutePath() + '/';
    }

    public static String getInitialUrl() {
        return FrameHelp.getHelpDirUrl() + "index.html";
    }

    private void buildUI() {
        FrameHelpToolBar toolBar = new FrameHelpToolBar((ApplicationFrameActionList)this.getController(), "Help toolbar");
        GWToolBarPanel toolBarPanel = new GWToolBarPanel();
        toolBarPanel.add((Component)toolBar, "Center");
        this.setToolBarPanel(toolBarPanel, "North");
        String initialUrl = FrameHelp.getHelpDirUrl() + this.initialRelativeUrl;
        logger.debug((Object)("initialUrl: " + initialUrl));
        this.browserPanel = new BrowserPanel(this.getController(), AbstractEditPanelDialog.UNSET_REFRESH_INTERVAL);
        this.browserPanel.setJavascriptEnabled(true);
        logger.debug((Object)("Javascript enabled: " + this.browserPanel.isJavascriptEnabled()));
        this.browserPanel.setPage(initialUrl);
        this.centeredContentPanel.add((Component)this.browserPanel, "Center");
    }

    public BrowserPanel getBrowserPanel() {
        return this.browserPanel;
    }

    @Override
    public void release() {
        this.browserPanel.cleanUp();
        super.release();
    }

    public void setModalExclusionType(ToolkitUtils.ModalExclusionType modalExclusionType) {
        ToolkitUtils.setWindowModalExclusionType(this, modalExclusionType);
    }
}

