/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.open;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.htmleditor.HTMLExternalTextViewer;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionSwitchMainToolBar;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ItemBox;
import com.novell.gw.jclient.application.controls.itemedit.ItemViewTabbedPane;
import com.novell.gw.jclient.application.controls.itemview.CheckListViewPanel;
import com.novell.gw.jclient.application.controls.itemview.GWItemPropertiesPersonalizePanel;
import com.novell.gw.jclient.application.controls.itemview.ItemProperties;
import com.novell.gw.jclient.application.controls.itemview.MessageSource;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.controls.menus.FrameOpenMenuBar;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.FrameOpenAppointmentToolBar;
import com.novell.gw.jclient.application.controls.toolbars.FrameOpenMailToolBar;
import com.novell.gw.jclient.application.controls.toolbars.FrameOpenReminderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.FrameOpenTaskToolBar;
import com.novell.gw.jclient.application.controls.toolbars.FrameOpenToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.AbstractOpenViewFrame;
import com.novell.gw.jclient.application.frames.WindowFocusOwnerChangeListener;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameOpen
extends AbstractOpenViewFrame<FrameOpenActionList> {
    private static Logger logger = Logger.getLogger(FrameOpen.class);
    private static final int CONT_INDEX = 0;
    private static final int PROP_INDEX = 1;
    private ItemViewer viewer;
    private ItemProperties itemProperties;
    private JPanel pnlItemProperties;
    private GWItemPropertiesPersonalizePanel pnlItemPersonalize;
    private OrientablePanel pnlMessageSource;
    private MessageSource messageSourceViewer;
    private JTabbedPane tabbedPane;
    private ApplicationFrameToolBar toolbar;
    private CheckListViewPanel checkListViewPanel;
    private boolean isPersonal = this.getItem().isPersonal();
    private boolean isInCheckList;

    public FrameOpen(IItemList itemList, AbstractItem item, String userGuid) {
        this(ControlsUtils.getItemTypeName(item) + ' ' + StringResources.FROM_C + ' ', itemList, item, userGuid);
    }

    private FrameOpen(String theTitle, IItemList itemList, AbstractItem item, String userGuid) {
        super(itemList, item, theTitle + item.getSender().getDisplayText(), FrameOpen.getFrameName(item), userGuid);
        this.setController(new FrameOpenActionList(this, (MVCController)GWClient.getApplication()));
        this.addWindowListener(new FocusWindowsListener());
        this.buildUI();
        this.setFocusPolicy();
        this.init();
        this.showToolbar();
        WindowFocusOwnerChangeListener propertyChangeListener = new WindowFocusOwnerChangeListener(this);
        ControlsUtils.getListenerManager(this.getController()).addListener(KeyboardFocusManager.getCurrentKeyboardFocusManager(), propertyChangeListener, ListenerType.PROPERTY_CHANGE_LISTENER);
    }

    private void init() {
        AbstractItem item = this.getItem();
        ActionSwitchMainToolBar actionSwitch = (ActionSwitchMainToolBar)((FrameOpenActionList)this.appActionList).getAction(ActionKey.SWITCH_MAIN_TOOLBAR);
        if (item instanceof AppointmentItem) {
            AppointmentItem appointment = (AppointmentItem)item;
            this.panStatusPanel.setMessage(appointment.getTimeZoneName());
            this.toolBarName = "APPOINTMENT_ITEM_TOOLBAR_VISIBLE";
        } else {
            this.toolBarName = item instanceof TaskItem ? "TASK_ITEM_TOOLBAR_VISIBLE" : (item instanceof ReminderNote ? "REMINDER_NOTE_ITEM_TOOLBAR_VISIBLE" : "MAIL_ITEM_TOOLBAR_VISIBLE");
        }
        actionSwitch.setToolBarName(this.toolBarName);
    }

    private void setFocusPolicy() {
        if (this.viewer != null && this.viewer.getFocusPolicy() != null) {
            this.setFocusTraversalPolicy(this.viewer.getFocusPolicy());
        }
    }

    protected void buildUI() {
        this.toolbar = this.createToolBar(this.getItem().getClass());
        this.setGWMenuBar(this.createMenuBar());
        GWToolBarPanel toolBarPanel = new GWToolBarPanel();
        toolBarPanel.add((Component)this.toolbar, "Center");
        this.setToolBarPanel(toolBarPanel, "North");
        AbstractItem item = this.getItem();
        this.viewer = new ItemViewer(this.getController(), "ATTACHLIST_SPLITPOS_OPEN", true);
        this.tabbedPane = new ItemViewTabbedPane((ActionList)this.getController());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Component comp = FrameOpen.this.tabbedPane.getSelectedComponent();
                if (comp == FrameOpen.this.pnlItemProperties) {
                    if (FrameOpen.this.pnlItemProperties.getComponentCount() == 0) {
                        FrameOpen.this.pnlItemProperties.add((Component)FrameOpen.this.itemProperties, "Center");
                    }
                    FrameOpen.this.itemProperties.loadContent();
                    ((FrameOpenActionList)FrameOpen.this.getController()).processCommand(new Command(1360));
                } else if (comp == FrameOpen.this.pnlMessageSource) {
                    if (FrameOpen.this.pnlMessageSource.getComponentCount() == 0) {
                        FrameOpen.this.pnlMessageSource.add((Component)FrameOpen.this.messageSourceViewer, "Center");
                    }
                    FrameOpen.this.messageSourceViewer.loadContent();
                } else if (comp == FrameOpen.this.pnlItemPersonalize) {
                    logger.debug((Object)"personalize tab selected");
                    FrameOpen.this.pnlItemPersonalize.processPanelSelected();
                } else {
                    ((FrameOpenActionList)FrameOpen.this.getController()).processCommand(new Command(1350));
                }
            }
        });
        this.tabbedPane.addTab(ControlsUtils.getItemTypeName(item), this.viewer);
        if (!this.isPersonal) {
            this.itemProperties = new ItemProperties(this.getController());
            this.itemProperties.setItem(this.getItem());
            this.pnlItemProperties = new JPanel(new BorderLayout());
            this.tabbedPane.addTab(StringResources.PROPERTIES_C, this.pnlItemProperties);
            if (MessageUtils.canShowPersonalizeTab(item)) {
                this.pnlItemPersonalize = new GWItemPropertiesPersonalizePanel(this.getController(), this.getItem());
                this.tabbedPane.addTab(StringResources.PERSONALIZE, this.pnlItemPersonalize);
            }
        }
        this.isInCheckList = item.getNativeItem().isInChecklist();
        if (this.isInCheckList) {
            this.checkListViewPanel = new CheckListViewPanel(this.getController());
            this.checkListViewPanel.setItem(item);
            this.tabbedPane.add(this.checkListViewPanel.getName(), this.checkListViewPanel);
        }
        this.toggleMessageSourceTab(this.getItem());
        this.centeredContentPanel.add((Component)this.tabbedPane, "Center");
        this.setIconImage(ControlsUtils.getImageForGWItem(item).getImage());
        try {
            item.markOpen();
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
        }
        Command command = new Command(20, new SelectedItemsInfoImpl(this.getItemList(), this.getItem()));
        ((FrameOpenActionList)this.getController()).processCommand(command);
        command = new Command(1070, this.getController());
        ((FrameOpenActionList)this.getController()).processCommand(command);
        this.pack();
    }

    private void toggleMessageSourceTab(AbstractItem item) {
        if (!item.isPersonal() && !item.isDraft() && item.hasSourceAttachment() && this.tabbedPane != null) {
            if (this.messageSourceViewer != null && this.messageSourceViewer.getItem() == item) {
                return;
            }
            this.messageSourceViewer = new MessageSource(item, this.getController());
            this.pnlMessageSource = new OrientablePanel(new BorderLayout());
            this.tabbedPane.addTab(StringResources.MESSAGE_SOURCE, this.pnlMessageSource);
        } else if (this.tabbedPane != null) {
            this.tabbedPane.remove(this.pnlMessageSource);
        }
    }

    public void itemSelected(AbstractItem item) {
        this.toggleMessageSourceTab(item);
        if (this.itemProperties != null) {
            this.itemProperties.setItem(item);
            Component comp = this.tabbedPane.getSelectedComponent();
            if (comp instanceof ItemProperties) {
                ((ItemBox)((Object)comp)).loadContent();
            }
        }
    }

    public ItemProperties getItemProperties() {
        return this.itemProperties;
    }

    private ApplicationFrameToolBar createToolBar(Class gwItemClass) {
        FrameOpenToolBar toolBar = gwItemClass == AppointmentItem.class ? new FrameOpenAppointmentToolBar((ApplicationFrameActionList)this.getController()) : (gwItemClass == TaskItem.class ? new FrameOpenTaskToolBar((ApplicationFrameActionList)this.getController()) : (gwItemClass == ReminderNote.class ? new FrameOpenReminderToolBar((ApplicationFrameActionList)this.getController()) : (gwItemClass == MailItem.class ? new FrameOpenMailToolBar((ApplicationFrameActionList)this.getController()) : new FrameOpenToolBar((ApplicationFrameActionList)this.getController(), "Open mail toolbar"))));
        return toolBar;
    }

    public GWMenuBar createMenuBar() {
        return new FrameOpenMenuBar((ApplicationFrameActionList)this.getController());
    }

    public void showItemContent() {
        this.tabbedPane.setSelectedIndex(0);
        ((FrameOpenActionList)this.getController()).processCommand(new Command(1350));
    }

    public void showProperties() {
        this.tabbedPane.setSelectedIndex(1);
        ((FrameOpenActionList)this.getController()).processCommand(new Command(1360));
    }

    private static String getFrameName(AbstractItem item) {
        boolean personal = item.isPersonal();
        if (item instanceof MailItem) {
            return personal ? "POST_MAIL_FRAME" : "OPEN_MAIL_FRAME";
        }
        if (item instanceof AppointmentItem) {
            return personal ? "POST_APPOINTMENT_FRAME" : "OPEN_APPOINTMENT_FRAME";
        }
        if (item instanceof TaskItem) {
            return personal ? "POST_TASK_FRAME" : "OPEN_TASK_FRAME";
        }
        if (item instanceof ReminderNote) {
            return personal ? "POST_REMINDER_NOTE_FRAME" : "OPEN_REMINDER_NOTE_FRAME";
        }
        if (item instanceof PhoneItem) {
            return "OPEN_PHONE_FRAME";
        }
        return "AbstractOpenViewFrame";
    }

    public String getSelectedText() {
        return ((HTMLViewer)this.viewer.getComponentForFocus()).getSelectedText();
    }

    void processWindowClosed() {
        logger.debug((Object)"window is closing");
        if (!this.isPersonal) {
            if (this.pnlItemPersonalize != null) {
                this.pnlItemPersonalize.save();
            }
            if (this.isInCheckList) {
                this.checkListViewPanel.saveChanges();
                this.viewer.save();
            }
        }
    }

    @Override
    public void release() {
        logger.debug((Object)"window is releasing");
        super.release();
        if (this.viewer != null) {
            this.viewer.release();
            this.viewer = null;
        }
        if (this.itemProperties != null) {
            this.itemProperties.release();
            this.itemProperties = null;
        }
        if (this.checkListViewPanel != null) {
            this.checkListViewPanel.release();
            this.checkListViewPanel = null;
        }
        if (this.pnlItemPersonalize != null) {
            this.pnlItemPersonalize.release();
            this.pnlItemPersonalize = null;
        }
        if (this.messageSourceViewer != null) {
            this.messageSourceViewer.release();
            this.messageSourceViewer = null;
        }
        this.tabbedPane = null;
        this.toolbar = null;
    }

    private class FocusWindowsListener
    extends WindowAdapter {
        private FocusWindowsListener() {
        }

        public void windowOpened(WindowEvent e) {
            HTMLExternalTextViewer htmlExternalTextViewer;
            JComponent component = FrameOpen.this.viewer.getComponentForFocus();
            component.requestFocus();
            if (component instanceof HTMLExternalTextViewer && (htmlExternalTextViewer = (HTMLExternalTextViewer)component).getMode() == 2) {
                htmlExternalTextViewer.getTextComponent().requestFocus();
            }
        }
    }
}

