/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.frames.options.AccountOptionsDialog;
import com.novell.gw.jclient.application.frames.options.compose.send.SelectCategoryControl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import org.apache.log4j.Logger;

public class AccountGeneralOptionsDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(AccountGeneralOptionsDialog.class);
    private int mode;
    private JCheckBox ckSendRetrieveRepeatable;
    private JSpinner spSendRetrieveRepeateTime;
    private JCheckBox ckSendRetrieveOnStartup;
    private JTextField tfDisplayName;
    private JCheckBox ckMaximumLineLength;
    private JSpinner spMaximumLineLength;
    private JCheckBox ckIndentReplyText;
    private JTextField tfIndentReplyText;
    private SelectCategoryControl categoryControlNNTP;
    private JCheckBox ckAlwaysUsePlainText;
    private String userGuid;

    public AccountGeneralOptionsDialog(JDialog parent, int mode) {
        super(parent);
        this.userGuid = ControlsUtils.getUserGuid(((ApplicationDialog)parent).getController());
        this.mode = mode;
        this.buildUI();
        this.initControls();
        this.setTitle(StringResources.INTERNET_ACCOUNT_GENERAL_SETTINGS);
        this.setDefaultCloseOperation(2);
        this.enableControls();
        this.pack();
    }

    private void initControls() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        this.ckSendRetrieveRepeatable.setSelected(accountSettings.isIntervalSyncEnabled());
        this.spSendRetrieveRepeateTime.setValue(new Integer(accountSettings.getSyncInterval()));
        this.ckSendRetrieveOnStartup.setSelected(accountSettings.isStartupSyncEnabled());
        this.tfDisplayName.setText(accountSettings.getFromText());
        int nntpPostingLineLength = accountSettings.getNNTPPostingLineLength();
        if (nntpPostingLineLength == -1) {
            this.ckMaximumLineLength.setSelected(false);
            this.spMaximumLineLength.setEnabled(false);
            this.ckIndentReplyText.setEnabled(false);
        } else {
            this.ckMaximumLineLength.setSelected(true);
            this.spMaximumLineLength.setValue(nntpPostingLineLength);
            char replyChar = accountSettings.getNNTPReplyChar();
            if (replyChar == '\u0000') {
                this.ckIndentReplyText.setSelected(false);
                this.tfIndentReplyText.setEnabled(false);
            } else {
                this.ckIndentReplyText.setSelected(true);
                this.tfIndentReplyText.setText("" + replyChar);
            }
        }
        ICategoryList selectedCategories = CategoryUtils.createNewCategoryList(this.userGuid);
        ICategory nntpWatchCategory = APIWrapperManager.getCategory(accountSettings.getNNTPWatchCategory());
        if (nntpWatchCategory != null) {
            selectedCategories.addCategory(nntpWatchCategory, CategoryListRecordStatusType.ADD);
        }
        this.categoryControlNNTP.setCategories(selectedCategories);
        this.ckAlwaysUsePlainText.setSelected(accountSettings.getNNTPAlwaysPostPlain());
        this.initListeners();
    }

    private void initListeners() {
        this.ckMaximumLineLength.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountGeneralOptionsDialog.this.ckMaximumLineLength.isSelected()) {
                    AccountGeneralOptionsDialog.this.spMaximumLineLength.setEnabled(true);
                    AccountGeneralOptionsDialog.this.ckIndentReplyText.setEnabled(true);
                } else {
                    AccountGeneralOptionsDialog.this.spMaximumLineLength.setEnabled(false);
                    AccountGeneralOptionsDialog.this.ckIndentReplyText.setEnabled(false);
                    AccountGeneralOptionsDialog.this.ckIndentReplyText.setSelected(false);
                }
            }
        });
        this.ckIndentReplyText.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountGeneralOptionsDialog.this.ckIndentReplyText.isSelected()) {
                    AccountGeneralOptionsDialog.this.tfIndentReplyText.setEnabled(true);
                } else {
                    AccountGeneralOptionsDialog.this.tfIndentReplyText.setEnabled(false);
                    AccountGeneralOptionsDialog.this.tfIndentReplyText.setText("");
                }
            }
        });
    }

    private void buildUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel optionsPanel = this.buildOptionsPanel();
        JButton btnOK = new JButton(new OKDialogAction());
        this.setDefaultButton(btnOK);
        JButton btnCancel = new JButton(new GWDialog.CancelDialogAction(this));
        this.setCancelButton(btnCancel);
        OrientablePanel buttonPanel = new OrientablePanel();
        buttonPanel.setLayout(new FlowLayout(4));
        OS.addButtons(buttonPanel, btnOK, btnCancel);
        OrientableTabbedPane tabPane = new OrientableTabbedPane();
        ((JTabbedPane)tabPane).addTab(StringResources.GENERAL, optionsPanel);
        contentPane.add((Component)tabPane, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private JPanel buildOptionsPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        OrientablePanel namePanel = new OrientablePanel(new BorderLayout());
        OrientableLabel lblDisplayName = new OrientableLabel(StringResources.DISPLAY_NAME_C);
        this.tfDisplayName = new JTextField("");
        namePanel.add((Component)lblDisplayName, "Before");
        namePanel.add((Component)this.tfDisplayName, "Center");
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)namePanel, c);
        this.ckSendRetrieveRepeatable = new OrientableCheckBox(StringResources.SEND_RETRIEVE_ALL_MARKED_ACCOUNTS_EVERY);
        this.ckSendRetrieveRepeatable.addActionListener(new SendRetireveRepeatableUpdateListener());
        this.spSendRetrieveRepeateTime = new OrientableSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this.spSendRetrieveRepeateTime.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.spSendRetrieveRepeateTime.setComponentOrientation(UIUtils.getComponentOrientation());
        OrientableLabel lblSendRetrieveRepeateTime = new OrientableLabel(' ' + StringResources.MINUTE_S_SMALL);
        OrientablePanel pnlSendRetrieveRepeatable = new OrientablePanel(new BorderLayout());
        pnlSendRetrieveRepeatable.add((Component)this.ckSendRetrieveRepeatable, "Before");
        pnlSendRetrieveRepeatable.add((Component)this.spSendRetrieveRepeateTime, "Center");
        pnlSendRetrieveRepeatable.add((Component)lblSendRetrieveRepeateTime, "After");
        ++c.gridy;
        panel.add((Component)pnlSendRetrieveRepeatable, c);
        this.ckSendRetrieveOnStartup = new OrientableCheckBox(StringResources.SEND_RETRIEVE_ALL_MARKED_ACCOUNTS_AT_STARTUP);
        ++c.gridy;
        panel.add((Component)this.ckSendRetrieveOnStartup, c);
        c.insets = new Insets(10, 10, 30, 10);
        ++c.gridy;
        JPanel content = this.buildNNTPPanel();
        if (this.mode == AccountOptionsDialog.MODE_NEWS) {
            panel.add((Component)content, c);
        }
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private JPanel buildNNTPPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(5, 10, 5, 10);
        c.anchor = 21;
        this.ckMaximumLineLength = new OrientableCheckBox(StringResources.MAXIMUM_LINE_LENGTH_IN_NNTP_POSTINGS);
        c.gridy = 0;
        c.gridx = 0;
        panel.add((Component)this.ckMaximumLineLength, c);
        this.spMaximumLineLength = new OrientableSpinner(new SpinnerNumberModel(60, 60, 90, 1));
        c.gridx = 1;
        panel.add((Component)this.spMaximumLineLength, c);
        this.ckIndentReplyText = new OrientableCheckBox(StringResources.INDENT_NNTP_REPLY_TEXT_USING_C);
        this.addSideBorderToComponent(this.ckIndentReplyText);
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)this.ckIndentReplyText, c);
        this.tfIndentReplyText = new GWTextField(1);
        DefaultStyledDocument document = new DefaultStyledDocument();
        document.setDocumentFilter(new DocumentSizeFilter());
        this.tfIndentReplyText.setDocument(document);
        c.gridx = 1;
        panel.add((Component)this.tfIndentReplyText, c);
        c.insets = new Insets(10, 10, 5, 10);
        c.gridwidth = 2;
        c.gridx = 0;
        OrientablePanel categoryPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        categoryPanel.setBorder(BorderFactory.createEmptyBorder());
        gbc.gridy = 0;
        gbc.gridx = 0;
        categoryPanel.add((Component)new OrientableLabel(StringResources.CATEGORY_FOR_WATCHED_THREADS_C), gbc);
        ++gbc.gridx;
        this.categoryControlNNTP = new SelectCategoryControl(CategoryUtils.createNewCategoryList(this.userGuid), false, this.userGuid);
        categoryPanel.add((Component)this.categoryControlNNTP, gbc);
        ++c.gridy;
        panel.add((Component)categoryPanel, c);
        this.ckAlwaysUsePlainText = new OrientableCheckBox(StringResources.ALWAYS_USE_PLAIN_TEXT_FOR_NNTP_POSTS);
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)this.ckAlwaysUsePlainText, c);
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private void addSideBorderToComponent(JComponent component) {
        if (UIUtils.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            component.setBorder(new EmptyBorder(0, 60, 0, 0));
        } else {
            component.setBorder(new EmptyBorder(0, 0, 0, 60));
        }
    }

    private void enableControls() {
        this.spSendRetrieveRepeateTime.setEnabled(this.ckSendRetrieveRepeatable.isSelected());
    }

    private void applyChanges() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        accountSettings.setIntervalSyncEnabled(this.ckSendRetrieveRepeatable.isSelected());
        accountSettings.setSyncInterval(((Integer)this.spSendRetrieveRepeateTime.getValue()).intValue());
        accountSettings.setStartupSyncEnabled(this.ckSendRetrieveOnStartup.isSelected());
        accountSettings.setFromText(this.tfDisplayName.getText());
        if (this.ckMaximumLineLength.isSelected()) {
            accountSettings.setNNTPPostingLineLength(((Integer)this.spMaximumLineLength.getValue()).intValue());
            if (this.ckIndentReplyText.isSelected()) {
                accountSettings.setNNTPReplyChar(this.tfIndentReplyText.getText().charAt(0));
            } else {
                accountSettings.setNNTPReplyChar('\u0000');
            }
        } else {
            accountSettings.setNNTPPostingLineLength(-1);
        }
        ICategory category = this.categoryControlNNTP.getCategories().getCategoryAt(0);
        if (category != null) {
            accountSettings.setNNTPWatchCategory(category.getNativeCategory());
        }
        accountSettings.setNNTPAlwaysPostPlain(this.ckAlwaysUsePlainText.isSelected());
        GWClient.getGwClientActionList().processCommand(new GlobalCommand(810));
    }

    private class DocumentSizeFilter
    extends DocumentFilter {
        int maxCharacters = 1;

        private DocumentSizeFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            if (fb.getDocument().getLength() + str.length() <= this.maxCharacters) {
                super.insertString(fb, offs, str, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
            if (fb.getDocument().getLength() + str.length() - length <= this.maxCharacters) {
                super.replace(fb, offs, length, str, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private class OKDialogAction
    extends AbstractAction {
        public OKDialogAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            AccountGeneralOptionsDialog.this.applyChanges();
            GWDialog.disposeDialog(AccountGeneralOptionsDialog.this);
        }
    }

    private class SendRetireveRepeatableUpdateListener
    implements ActionListener {
        private SendRetireveRepeatableUpdateListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AccountGeneralOptionsDialog.this.enableControls();
        }
    }
}

