/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewsAccountDialog
extends ApplicationDialog<ApplicationDialogController> {
    private static Logger logger = Logger.getLogger(CreateNewsAccountDialog.class);
    private static final String[] TITLES = new String[]{StringResources.CREATE_NEWS_ACCOUNT_CREATE_NEWS_ACCOUNT, StringResources.CREATE_NEWS_ACCOUNT_CREATE_NEWS_ACCOUNT, StringResources.CREATE_NEWS_ACCOUNT_CREATE_NEWS_SERVER_FOLDER};
    private int currentDialog = 1;
    private CardLayout cardLayout = new CardLayout();
    private OrientablePanel cardPnl = new OrientablePanel(this.cardLayout);
    private OrientableButton btnBack = new OrientableButton();
    private OrientableButton btnNext = new OrientableButton();
    OrientableCheckBox d1UploadCheckBox = new OrientableCheckBox(StringResources.CREATE_ACCOUNT_D1_UPLOAD_THIS_ACCOUNT);
    GWTextField d1AccountNameField;
    GWTextField d2FromNameField;
    GWTextField d2ServerField;
    OrientableCheckBox d2ServerRequiresAuthenticationCheckBox;
    GWTextField d2LoginNameField;
    JPasswordField d2PasswordField;
    GWTextField d2EmailAddressField;
    private FolderNamePane folderNamePane;
    private String[] names;

    CreateNewsAccountDialog(JDialog window, MVCController parentController) {
        super((Dialog)window, parentController);
        this.d1UploadCheckBox.setSelected(true);
        this.d1AccountNameField = new GWTextField(20);
        this.d2ServerField = new GWTextField(20);
        this.d2ServerRequiresAuthenticationCheckBox = new OrientableCheckBox(StringResources.CREATE_NEWS_ACCOUNT_D2_MY_SERVER_REQUIRES_AUTHENTICATION);
        this.d2LoginNameField = new GWTextField(20);
        this.d2PasswordField = new OrientablePasswordField(20);
        this.folderNamePane = new FolderNamePane((MVCController)this.getController(), FoldersCache.getMailboxFolder(ControlsUtils.getUserGuid(this.getController())), this.btnNext, true);
        this.folderNamePane.setMVCModel((Object)true);
        this.buildUI();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<CreateNewsAccountDialog>(this, parentController);
    }

    private void buildUI() {
        JSeparator separator = new JSeparator(0);
        OrientablePanel contentPane = new OrientablePanel(new BorderLayout());
        OrientablePanel btnPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel downPnl = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.btnBack.setText(StringResources.BACK_G);
        this.btnNext.setText(StringResources.NEXT_G);
        this.btnBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateNewsAccountDialog.this.btnBackPressed(e);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateNewsAccountDialog.this.btnNextPressed(e);
            }
        });
        this.btnBack.setEnabled(false);
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        btnPnl.add((Component)this.btnBack, gbc);
        gbc.gridx = 1;
        btnPnl.add((Component)this.btnNext, gbc);
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.gridx = 2;
        btnPnl.add((Component)this.getBtnCancel(), gbc);
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        downPnl.add((Component)separator, gbc);
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        downPnl.add((Component)btnPnl, gbc);
        this.btnBack.setMnemonic(66);
        this.btnNext.setMnemonic(78);
        contentPane.add((Component)this.cardPnl, "Center");
        contentPane.add((Component)downPnl, "South");
        this.cardPnl.add((Component)this.buildDialog1(), "1");
        this.cardPnl.add((Component)this.buildDialog2(), "2");
        this.cardPnl.add((Component)this.folderNamePane, "3");
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(2);
        this.setTitle(TITLES[0]);
        this.pack();
        this.d1AccountNameField.requestFocus(true);
    }

    private OrientablePanel buildDialog1() {
        OrientablePanel dialog1 = new OrientablePanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GWTextArea d1LblMain = new GWTextArea();
        OrientableLabel d1LblAccount = new OrientableLabel(StringResources.CREATE_NEWS_ACCOUNT_D1_ACCOUNT_NAME);
        OrientablePanel d1MainPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d1AccountPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d1MainLblPnl = new OrientablePanel(new BorderLayout());
        ((JTextComponent)d1LblMain).setText(StringResources.CREATE_NEWS_ACCOUNT_D1_ENTER_THE_NAME);
        ((JTextComponent)d1LblMain).setEditable(false);
        d1LblMain.setOpaque(false);
        d1MainLblPnl.add((Component)d1LblMain, "Center");
        d1AccountPnl.add((Component)d1LblAccount, "Before");
        d1AccountPnl.add((Component)this.d1AccountNameField, "Center");
        gbc.fill = 1;
        gbc.anchor = 19;
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        d1MainPnl.add((Component)d1MainLblPnl, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        d1MainPnl.add((Component)d1AccountPnl, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        d1MainPnl.add((Component)this.d1UploadCheckBox, gbc);
        dialog1.add((Component)d1MainPnl, "North");
        return dialog1;
    }

    private OrientablePanel buildDialog2() {
        OrientablePanel dialog2 = new OrientablePanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GWTextArea d2MainLbl = new GWTextArea();
        ((JTextComponent)d2MainLbl).setText(StringResources.CREATE_NEWS_ACCOUNT_D2_YOUR_INTERNET_SERVICE_PROVIDER);
        ((JTextComponent)d2MainLbl).setEditable(false);
        d2MainLbl.setOpaque(false);
        OrientableLabel d2NameLbl = new OrientableLabel(StringResources.NEWS_SERVER_C);
        OrientableLabel d2LoginName = new OrientableLabel(StringResources.LOGIN_NAME_C);
        OrientableLabel d2PasswordLbl = new OrientableLabel(StringResources.CREATE_NEWS_ACCOUNT_D2_PASSWORD);
        OrientableLabel d2EMailLbl = new OrientableLabel(StringResources.CREATE_ACCOUNT_D2_EMAIL_ADDRESS);
        OrientableLabel d2FromLbl = new OrientableLabel(StringResources.CREATE_ACCOUNT_D2_FROM_NAME);
        OrientablePanel d2MainPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d2AccountPnl = new OrientablePanel(new GridBagLayout());
        OrientablePanel d2NamePnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d2EMailPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel d2FromPnl = new OrientablePanel(new BorderLayout());
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        d2AccountPnl.add((Component)d2LoginName, gbc);
        gbc.gridy = 1;
        d2AccountPnl.add((Component)d2PasswordLbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.d2LoginNameField.setEnabled(false);
        d2AccountPnl.add((Component)this.d2LoginNameField, gbc);
        gbc.gridy = 1;
        this.d2PasswordField.setEnabled(false);
        d2AccountPnl.add((Component)this.d2PasswordField, gbc);
        String userGuid = ControlsUtils.getUserGuid(this.getController());
        d2NamePnl.add((Component)d2NameLbl, "North");
        d2NamePnl.add((Component)this.d2ServerField, "Center");
        d2EMailPnl.add((Component)d2EMailLbl, "North");
        this.d2EmailAddressField = new GWTextField(GWCommandManager.getInstance(userGuid).getCurrentDataStore().getGroupWiseAccount().getEmailAddress(), 20);
        d2EMailPnl.add((Component)this.d2EmailAddressField, "Center");
        d2FromPnl.add((Component)d2FromLbl, "North");
        this.d2FromNameField = new GWTextField(GWCommandManager.getInstance(userGuid).getCurrentUserInfo().getFromText(), 20);
        d2FromPnl.add((Component)this.d2FromNameField, "Center");
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        d2MainPnl.add((Component)d2MainLbl, gbc);
        gbc.gridy = 1;
        d2MainPnl.add((Component)d2NamePnl, gbc);
        gbc.gridy = 2;
        if (UIUtils.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            this.d2ServerRequiresAuthenticationCheckBox.setBorder(new EmptyBorder(0, 70, 0, 0));
        } else {
            this.d2ServerRequiresAuthenticationCheckBox.setBorder(new EmptyBorder(0, 0, 0, 70));
        }
        this.d2ServerRequiresAuthenticationCheckBox.addItemListener(new ServerAuthCheckBoxItemListener());
        d2MainPnl.add((Component)this.d2ServerRequiresAuthenticationCheckBox, gbc);
        gbc.gridy = 3;
        if (UIUtils.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            d2AccountPnl.setBorder(new EmptyBorder(0, 60, 0, 0));
        } else {
            d2AccountPnl.setBorder(new EmptyBorder(0, 0, 0, 60));
        }
        d2MainPnl.add((Component)d2AccountPnl, gbc);
        gbc.gridy = 4;
        d2MainPnl.add((Component)d2EMailPnl, gbc);
        gbc.gridy = 5;
        d2MainPnl.add((Component)d2FromPnl, gbc);
        dialog2.add((Component)d2MainPnl, "North");
        return dialog2;
    }

    public void btnBackPressed(ActionEvent e) {
        this.cardLayout.previous(this.cardPnl);
        --this.currentDialog;
        if (this.currentDialog == 1) {
            this.btnBack.setEnabled(false);
            this.d1AccountNameField.requestFocus(true);
        }
        if (this.currentDialog == 2) {
            this.btnNext.setText(StringResources.NEXT_G);
        }
        this.setTitle(TITLES[this.currentDialog - 1]);
    }

    public void btnNextPressed(ActionEvent e) {
        if (this.currentDialog == 1) {
            if (this.d1AccountNameField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, StringResources.CREATE_MAIL_ACCOUNT_PLEASE_ENTER_AN_ACCOUNT_NAME);
                this.d1AccountNameField.requestFocus(true);
                return;
            }
            for (String currentName : this.names) {
                if (!this.d1AccountNameField.getText().equals(currentName)) continue;
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.THE_NAME_HAS_BEEN_ALREADY_USED, currentName) + '\n' + StringResources.PLEASE_ENTER_A_UNIQUE_ACCOUNT_NAME, StringResources.NOVELL_GROUPWISE, 1);
                this.d1AccountNameField.requestFocus(true);
                return;
            }
            this.folderNamePane.setFolderName(this.d1AccountNameField.getText());
        }
        if (this.currentDialog == 2 && this.d2ServerField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, StringResources.CREATE_NEWS_ACCOUNT_PLEASE_ENTER_SERVER);
            return;
        }
        ++this.currentDialog;
        if (this.currentDialog == 4) {
            this.createNewsAccount();
        }
        if (this.currentDialog == 3) {
            this.btnNext.setText(StringResources.FINISH);
        }
        this.btnBack.setEnabled(true);
        this.cardLayout.next(this.cardPnl);
        this.setTitle(TITLES[this.currentDialog - 2]);
    }

    private void createNewsAccount() {
        IDataStore dataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getCurrentDataStore();
        NntpAccount account = dataStore.createNntpAccount(this.d1AccountNameField.getText(), this.d2ServerRequiresAuthenticationCheckBox.isSelected(), this.d2ServerField.getText(), this.d2LoginNameField.getText(), this.d2PasswordField.getText(), this.d2EmailAddressField.getText(), this.d2FromNameField.getText(), this.folderNamePane.getParentFolder().getNativeFolder(), this.folderNamePane.getFolderPosition());
        logger.debug((Object)("canUploadToMaster: " + account.canUploadToMaster()));
        if (account.canUploadToMaster()) {
            account.setUploadToMaster(this.d1UploadCheckBox.isSelected(), true);
        }
        dataStore.writeMemoryCachedData();
        this.setVisible(false);
        this.dispose();
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    private class ServerAuthCheckBoxItemListener
    implements ItemListener {
        private ServerAuthCheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CreateNewsAccountDialog.this.d2LoginNameField.setEnabled(true);
                CreateNewsAccountDialog.this.d2PasswordField.setEnabled(true);
            } else {
                CreateNewsAccountDialog.this.d2LoginNameField.setEnabled(false);
                CreateNewsAccountDialog.this.d2PasswordField.setEnabled(false);
            }
        }
    }
}

