/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.OptionsController;
import com.novell.gw.jclient.application.frames.options.compose.OptionsViewPane;
import com.novell.gw.jclient.application.frames.options.pageselector.OptionsPageSelector;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class Options
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(Options.class);
    public static final String OPTION_GENERAL = "General";
    public static final String OPTION_SEND = "Send";
    public static final String OPTION_SECURITY = "Security";
    public static final String OPTION_PRINTING = "Printing";
    public static final String OPTION_DATE_AND_TIME = "Date and Time";
    private MVCController controller;
    private OptionsPageSelector optionsPageSelector;
    private OptionsViewPane optionsViewPane;
    private String defaultOptionID;
    private String currentPage;

    public Options(MVCController theParentController, String userGuid) {
        this.currentPage = this.defaultOptionID = OPTION_GENERAL;
        this.controller = new OptionsController(this, theParentController);
        LinkedHashMap<String, String> buttons = new LinkedHashMap<String, String>();
        buttons.put(OPTION_GENERAL, StringResources.ENVIRONMENT);
        buttons.put(OPTION_SEND, StringResources.SEND);
        buttons.put(OPTION_SECURITY, StringResources.SECURITY);
        buttons.put(OPTION_DATE_AND_TIME, StringResources.CALENDAR);
        buttons.put(OPTION_PRINTING, StringResources.PRINTING);
        this.optionsPageSelector = new OptionsPageSelector(buttons, this.controller);
        this.optionsViewPane = new OptionsViewPane(this.controller, userGuid);
        this.optionsViewPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.optionsPageSelector.setSelectedOption(this.defaultOptionID);
        this.optionsViewPane.setSelectedPage(this.defaultOptionID);
        this.build();
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionsPageSelector, "Before");
        this.add((Component)this.optionsViewPane, "Center");
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public void setPreferencesPage(String name) {
        if (name != null && !this.currentPage.equals(name)) {
            this.optionsPageSelector.setSelectedOption(name);
            this.optionsViewPane.setSelectedPage(name);
            this.currentPage = name;
        }
    }

    public String getPreferencesPage() {
        return this.currentPage;
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        this.currentPage = (String)theModel;
    }

    public Object getMVCModel() {
        return this.currentPage;
    }

    public OptionsViewPane getOptionsViewPane() {
        return this.optionsViewPane;
    }
}

