/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.BusySearchOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.CalendarOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateTimeFormatOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.WorkScheduleOptionsPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DateTimeOptionsPane
extends ComposeOption {
    private static Logger logger = Logger.getLogger(DateTimeOptionsPane.class);
    private DateTimeFormatOptionsPanel pnlDateTimeFormaOptions;
    private CalendarOptionsPanel calendarOptionsPanel;
    private BusySearchOptionsPanel busySearchOptionsPanel;
    private AbstractOptionPanel pnlWorkSheduleOptions;

    public DateTimeOptionsPane(String opID, MVCController theParentController) {
        super(opID, theParentController);
    }

    public void prepareForShow() {
        this.build();
    }

    protected void build() {
        super.build();
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        OrientableTabbedPane tabFormats = new OrientableTabbedPane();
        this.pnlDateTimeFormaOptions = new DateTimeFormatOptionsPanel(dateTimeOptions, this.changesListener, this.controller);
        this.calendarOptionsPanel = new CalendarOptionsPanel(this.changesListener, this.getController());
        this.busySearchOptionsPanel = new BusySearchOptionsPanel(this.changesListener, this.controller);
        this.pnlWorkSheduleOptions = new WorkScheduleOptionsPanel(this.changesListener, this.controller);
        this.setLayout(new BorderLayout());
        tabFormats.add(StringResources.GENERAL, new OrientableScrollPane(this.calendarOptionsPanel));
        tabFormats.add(StringResources.WORK_SCHEDULE, new OrientableScrollPane(this.pnlWorkSheduleOptions));
        tabFormats.add(StringResources.BUSY_SEARCH, new OrientableScrollPane(this.busySearchOptionsPanel));
        tabFormats.add(StringResources.DATE_TIME, new OrientableScrollPane(this.pnlDateTimeFormaOptions));
        tabFormats.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractOptionPanel option = (AbstractOptionPanel)((JScrollPane)((JTabbedPane)e.getSource()).getSelectedComponent()).getViewport().getComponent(0);
                boolean b = DateTimeOptionsPane.this.changesListener.valueHasChanged();
                option.prepareForShow();
                if (!b) {
                    DateTimeOptionsPane.this.changesListener.setValueSaved();
                }
            }
        });
        this.add((Component)tabFormats, "Center");
        this.putOptionValuesIntoFields();
    }

    public void save() {
        this.collectValues();
        this.changesListener.setValueSaved();
    }

    public void putOptionValuesIntoFields() {
        this.calendarOptionsPanel.fireOptionsChanged();
        this.changesListener.setValueSaved();
    }

    public void collectValues() {
        if (this.calendarOptionsPanel.isPrepared) {
            this.calendarOptionsPanel.collectValues();
        }
        if (this.busySearchOptionsPanel.isPrepared) {
            this.busySearchOptionsPanel.collectValues();
        }
        if (this.pnlWorkSheduleOptions.isPrepared) {
            this.pnlWorkSheduleOptions.collectValues();
        }
        if (this.pnlDateTimeFormaOptions.isPrepared) {
            this.pnlDateTimeFormaOptions.collectValues();
        }
    }
}

